/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.components;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaEnumEntrySymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u0000 \u00042\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/components/ShortenStrategy;", "", "<init>", "(Ljava/lang/String;I)V", "Companion", "DO_NOT_SHORTEN", "SHORTEN_IF_ALREADY_IMPORTED", "SHORTEN_AND_IMPORT", "SHORTEN_AND_STAR_IMPORT"})
public final class ShortenStrategy
extends Enum<ShortenStrategy> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Function1<KaClassLikeSymbol, ShortenStrategy> defaultClassShortenStrategy;
    @NotNull
    private static final Function1<KaCallableSymbol, ShortenStrategy> defaultCallableShortenStrategy;
    public static final /* enum */ ShortenStrategy DO_NOT_SHORTEN;
    public static final /* enum */ ShortenStrategy SHORTEN_IF_ALREADY_IMPORTED;
    public static final /* enum */ ShortenStrategy SHORTEN_AND_IMPORT;
    public static final /* enum */ ShortenStrategy SHORTEN_AND_STAR_IMPORT;
    private static final /* synthetic */ ShortenStrategy[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    public static ShortenStrategy[] values() {
        return (ShortenStrategy[])$VALUES.clone();
    }

    public static ShortenStrategy valueOf(String value2) {
        return Enum.valueOf(ShortenStrategy.class, value2);
    }

    @NotNull
    public static EnumEntries<ShortenStrategy> getEntries() {
        return $ENTRIES;
    }

    private static final ShortenStrategy defaultClassShortenStrategy$lambda$0(KaClassLikeSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        ClassId classId = it.getClassId();
        return (classId != null ? classId.isNestedClass() : false) ? SHORTEN_IF_ALREADY_IMPORTED : SHORTEN_AND_IMPORT;
    }

    private static final ShortenStrategy defaultCallableShortenStrategy$lambda$1(KaCallableSymbol symbol) {
        ShortenStrategy shortenStrategy;
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        KaCallableSymbol kaCallableSymbol = symbol;
        if (kaCallableSymbol instanceof KaEnumEntrySymbol) {
            shortenStrategy = DO_NOT_SHORTEN;
        } else if (kaCallableSymbol instanceof KaConstructorSymbol) {
            boolean isNestedClassConstructor;
            ClassId classId = ((KaConstructorSymbol)symbol).getContainingClassId();
            boolean bl = classId != null ? classId.isNestedClass() : (isNestedClassConstructor = false);
            shortenStrategy = isNestedClassConstructor ? SHORTEN_IF_ALREADY_IMPORTED : SHORTEN_AND_IMPORT;
        } else {
            CallableId callableId = symbol.getCallableId();
            boolean isNotTopLevel = (callableId != null ? callableId.getClassId() : null) != null;
            shortenStrategy = isNotTopLevel ? SHORTEN_IF_ALREADY_IMPORTED : SHORTEN_AND_IMPORT;
        }
        return shortenStrategy;
    }

    static {
        DO_NOT_SHORTEN = new ShortenStrategy();
        SHORTEN_IF_ALREADY_IMPORTED = new ShortenStrategy();
        SHORTEN_AND_IMPORT = new ShortenStrategy();
        SHORTEN_AND_STAR_IMPORT = new ShortenStrategy();
        $VALUES = shortenStrategyArray = new ShortenStrategy[]{ShortenStrategy.DO_NOT_SHORTEN, ShortenStrategy.SHORTEN_IF_ALREADY_IMPORTED, ShortenStrategy.SHORTEN_AND_IMPORT, ShortenStrategy.SHORTEN_AND_STAR_IMPORT};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        defaultClassShortenStrategy = ShortenStrategy::defaultClassShortenStrategy$lambda$0;
        defaultCallableShortenStrategy = ShortenStrategy::defaultCallableShortenStrategy$lambda$1;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R)\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0007\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\b\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\t\u0010\nR)\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u00048\u0007\u00a2\u0006\u0012\n\u0004\b\r\u0010\b\u0012\u0004\b\u000f\u0010\u0003\u001a\u0004\b\u000e\u0010\n"}, d2={"Lorg/jetbrains/kotlin/analysis/api/components/ShortenStrategy$Companion;", "", "<init>", "()V", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol;", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenStrategy;", "defaultClassShortenStrategy", "Lkotlin/jvm/functions/Function1;", "getDefaultClassShortenStrategy", "()Lkotlin/jvm/functions/Function1;", "getDefaultClassShortenStrategy$annotations", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "defaultCallableShortenStrategy", "getDefaultCallableShortenStrategy", "getDefaultCallableShortenStrategy$annotations"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<KaClassLikeSymbol, ShortenStrategy> getDefaultClassShortenStrategy() {
            return defaultClassShortenStrategy;
        }

        public static /* synthetic */ void getDefaultClassShortenStrategy$annotations() {
        }

        @NotNull
        public final Function1<KaCallableSymbol, ShortenStrategy> getDefaultCallableShortenStrategy() {
            return defaultCallableShortenStrategy;
        }

        public static /* synthetic */ void getDefaultCallableShortenStrategy$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

