/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSessionProviderKt;
import org.jetbrains.kotlin.analysis.api.fir.utils.KaFirCacheCleaner;
import org.jetbrains.kotlin.analysis.api.fir.utils.KaFirNoOpCacheCleaner;
import org.jetbrains.kotlin.analysis.api.fir.utils.KaFirStopWorldCacheCleaner;
import org.jetbrains.kotlin.analysis.api.impl.base.sessions.KaBaseSessionProvider;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProvider;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModuleKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.LLStatisticsService;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.domains.LLAnalysisSessionStatistics;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0017\u00a2\u0006\u0004\b\r\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0019J\u001f\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u001f\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001b\u0010\tJ\u000f\u0010\u001c\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001c\u0010\tJ\u000f\u0010\u001d\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001d\u0010\tR \u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u001e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0018\u0010\"\u001a\u0006\u0012\u0002\b\u00030!8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u001b\u0010)\u001a\u00020$8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R#\u0010/\u001a\u0004\u0018\u00010*8BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b+\u0010&\u0012\u0004\b.\u0010\t\u001a\u0004\b,\u0010-"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/sessions/KaBaseSessionProvider;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/project/Project;", "project", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "", "performCacheMaintenance", "()V", "Lorg/jetbrains/kotlin/psi/KtElement;", "useSiteElement", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "getAnalysisSession", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/analysis/api/KaSession;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "useSiteModule", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)Lorg/jetbrains/kotlin/analysis/api/KaSession;", "useSiteKtModule", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "createAnalysisSession", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "session", "beforeEnteringAnalysis", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtElement;)V", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)V", "afterLeavingAnalysis", "handleLowMemoryEvent", "clearCaches", "dispose", "Lcom/github/benmanes/caffeine/cache/Cache;", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Ljava/util/concurrent/Future;", "scheduledCacheMaintenance", "Ljava/util/concurrent/Future;", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/KaFirCacheCleaner;", "cacheCleaner$delegate", "Lkotlin/Lazy;", "getCacheCleaner", "()Lorg/jetbrains/kotlin/analysis/api/fir/utils/KaFirCacheCleaner;", "cacheCleaner", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLAnalysisSessionStatistics;", "analysisSessionStatistics$delegate", "getAnalysisSessionStatistics", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLAnalysisSessionStatistics;", "getAnalysisSessionStatistics$annotations", "analysisSessionStatistics"})
public final class KaFirSessionProvider
extends KaBaseSessionProvider
implements Disposable {
    @NotNull
    private final Cache<KaModule, KaSession> cache;
    @NotNull
    private final Future<?> scheduledCacheMaintenance;
    @NotNull
    private final Lazy cacheCleaner$delegate;
    @NotNull
    private final Lazy analysisSessionStatistics$delegate;

    public KaFirSessionProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        super(project);
        Cache cache2 = Caffeine.newBuilder().weakValues().build();
        Intrinsics.checkNotNullExpressionValue(cache2, "build(...)");
        this.cache = cache2;
        this.cacheCleaner$delegate = LazyKt.lazy(() -> KaFirSessionProvider.cacheCleaner_delegate$lambda$0(project));
        this.analysisSessionStatistics$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, () -> KaFirSessionProvider.analysisSessionStatistics_delegate$lambda$1(project));
        LowMemoryWatcher.register(this::handleLowMemoryEvent, project);
        ScheduledFuture<?> scheduledFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> KaFirSessionProvider._init_$lambda$2(this), 10L, 10L, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, "scheduleWithFixedDelay(...)");
        this.scheduledCacheMaintenance = scheduledFuture;
    }

    private final KaFirCacheCleaner getCacheCleaner() {
        Lazy lazy = this.cacheCleaner$delegate;
        return (KaFirCacheCleaner)lazy.getValue();
    }

    private final LLAnalysisSessionStatistics getAnalysisSessionStatistics() {
        Lazy lazy = this.analysisSessionStatistics$delegate;
        return (LLAnalysisSessionStatistics)lazy.getValue();
    }

    private static /* synthetic */ void getAnalysisSessionStatistics$annotations() {
    }

    private final void performCacheMaintenance() {
        this.cache.cleanUp();
    }

    @Override
    @NotNull
    public KaSession getAnalysisSession(@NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter(useSiteElement, "useSiteElement");
        KaModule module2 = KotlinProjectStructureProvider.Companion.getModule(this.getProject(), useSiteElement, null);
        return this.getAnalysisSession(module2);
    }

    @Override
    @NotNull
    public KaSession getAnalysisSession(@NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter(useSiteModule, "useSiteModule");
        ProgressManager.checkCanceled();
        this.getCacheCleaner().enterAnalysis();
        try {
            if (useSiteModule instanceof KaDanglingFileModule && !KaModuleKt.isStable((KaDanglingFileModule)useSiteModule)) {
                return this.createAnalysisSession(useSiteModule);
            }
            KClass<? extends KaLifetimeToken> identifier = this.getTokenFactory().getIdentifier();
            KaFirSessionProviderKt.access$flushPendingChanges(identifier, this.getProject());
            KaSession kaSession = this.cache.get(useSiteModule, arg_0 -> KaFirSessionProvider.getAnalysisSession$lambda$3(new Function1<KaModule, KaFirSession>((Object)this){

                public final KaFirSession invoke(KaModule p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return KaFirSessionProvider.access$createAnalysisSession((KaFirSessionProvider)this.receiver, p0);
                }
            }, arg_0));
            if (kaSession == null) {
                throw new IllegalStateException("`createAnalysisSession` must not return `null`.".toString());
            }
            return kaSession;
        }
        catch (Throwable e) {
            this.getCacheCleaner().exitAnalysis();
            throw e;
        }
    }

    private final KaFirSession createAnalysisSession(KaModule useSiteKtModule) {
        LLFirResolveSession firResolveSession = LowLevelFirApiFacadeKt.getFirResolveSession(useSiteKtModule, this.getProject());
        KaLifetimeToken validityToken = this.getTokenFactory().create(this.getProject(), firResolveSession.getUseSiteFirSession().createValidityTracker());
        return KaFirSession.Companion.createAnalysisSessionByFirResolveSession$analysis_api_fir(firResolveSession, validityToken);
    }

    @Override
    public void beforeEnteringAnalysis(@NotNull KaSession session, @NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(useSiteElement, "useSiteElement");
        try {
            LLAnalysisSessionStatistics lLAnalysisSessionStatistics = this.getAnalysisSessionStatistics();
            if (lLAnalysisSessionStatistics != null && (lLAnalysisSessionStatistics = lLAnalysisSessionStatistics.getAnalyzeCallCounter()) != null) {
                lLAnalysisSessionStatistics.add(1L);
            }
            super.beforeEnteringAnalysis(session, useSiteElement);
        }
        catch (Throwable e) {
            this.getCacheCleaner().exitAnalysis();
            throw e;
        }
    }

    @Override
    public void beforeEnteringAnalysis(@NotNull KaSession session, @NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(useSiteModule, "useSiteModule");
        try {
            LLAnalysisSessionStatistics lLAnalysisSessionStatistics = this.getAnalysisSessionStatistics();
            if (lLAnalysisSessionStatistics != null && (lLAnalysisSessionStatistics = lLAnalysisSessionStatistics.getAnalyzeCallCounter()) != null) {
                lLAnalysisSessionStatistics.add(1L);
            }
            super.beforeEnteringAnalysis(session, useSiteModule);
        }
        catch (Throwable e) {
            this.getCacheCleaner().exitAnalysis();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLeavingAnalysis(@NotNull KaSession session, @NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(useSiteElement, "useSiteElement");
        try {
            super.afterLeavingAnalysis(session, useSiteElement);
        }
        finally {
            this.getCacheCleaner().exitAnalysis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLeavingAnalysis(@NotNull KaSession session, @NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(useSiteModule, "useSiteModule");
        try {
            super.afterLeavingAnalysis(session, useSiteModule);
        }
        finally {
            this.getCacheCleaner().exitAnalysis();
        }
    }

    private final void handleLowMemoryEvent() {
        this.performCacheMaintenance();
        this.getCacheCleaner().scheduleCleanup();
    }

    @Override
    public void clearCaches() {
        this.cache.invalidateAll();
    }

    @Override
    public void dispose() {
        this.scheduledCacheMaintenance.cancel(false);
    }

    private static final KaFirCacheCleaner cacheCleaner_delegate$lambda$0(Project $project) {
        return Registry.is("kotlin.analysis.lowMemoryCacheCleanup", false) ? (KaFirCacheCleaner)new KaFirStopWorldCacheCleaner($project) : (KaFirCacheCleaner)KaFirNoOpCacheCleaner.INSTANCE;
    }

    private static final LLAnalysisSessionStatistics analysisSessionStatistics_delegate$lambda$1(Project $project) {
        LLStatisticsService lLStatisticsService = LLStatisticsService.Companion.getInstance($project);
        return lLStatisticsService != null ? lLStatisticsService.getAnalysisSessions() : null;
    }

    private static final void _init_$lambda$2(KaFirSessionProvider this$0) {
        this$0.performCacheMaintenance();
    }

    private static final KaSession getAnalysisSession$lambda$3(Function1 $tmp0, Object p0) {
        return (KaSession)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ KaFirSession access$createAnalysisSession(KaFirSessionProvider $this, KaModule useSiteKtModule) {
        return $this.createAnalysisSession(useSiteKtModule);
    }

    public static final /* synthetic */ Cache access$getCache$p(KaFirSessionProvider $this) {
        return $this.cache;
    }
}

