/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.components.ElementsToShortenCollector;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010!\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020\b2\u0006\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010)\u001a\u00020\b2\u0006\u0010(\u001a\u00020'H\u0016\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010-\u001a\u00020\b2\u0006\u0010,\u001a\u00020+H\u0016\u00a2\u0006\u0004\b-\u0010.J\u0017\u00101\u001a\u00020\b2\u0006\u00100\u001a\u00020/H\u0016\u00a2\u0006\u0004\b1\u00102R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00103R\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\u000b048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/CollectingVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/ElementsToShortenCollector;", "collector", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/fir/components/ElementsToShortenCollector;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "valueParameter", "", "visitValueParameter", "(Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "property", "visitProperty", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirScript;", "script", "visitScript", "(Lorg/jetbrains/kotlin/fir/declarations/FirScript;)V", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "visitElement", "(Lorg/jetbrains/kotlin/fir/FirElement;)V", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "errorTypeRef", "visitErrorTypeRef", "(Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;)V", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "resolvedTypeRef", "visitResolvedTypeRef", "(Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "resolvedQualifier", "visitResolvedQualifier", "(Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorResolvedQualifier;", "errorResolvedQualifier", "visitErrorResolvedQualifier", "(Lorg/jetbrains/kotlin/fir/expressions/FirErrorResolvedQualifier;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "functionCall", "visitFunctionCall", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "propertyAccessExpression", "visitPropertyAccessExpression", "(Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;)V", "Lorg/jetbrains/kotlin/fir/references/FirThisReference;", "thisReference", "visitThisReference", "(Lorg/jetbrains/kotlin/fir/references/FirThisReference;)V", "Lorg/jetbrains/kotlin/analysis/api/fir/components/ElementsToShortenCollector;", "", "visitedProperty", "Ljava/util/Set;"})
final class CollectingVisitor
extends FirVisitorVoid {
    @NotNull
    private final ElementsToShortenCollector collector;
    @NotNull
    private final Set<FirProperty> visitedProperty;

    public CollectingVisitor(@NotNull ElementsToShortenCollector collector2) {
        Intrinsics.checkNotNullParameter(collector2, "collector");
        this.collector = collector2;
        this.visitedProperty = new LinkedHashSet();
    }

    @Override
    public void visitValueParameter(@NotNull FirValueParameter valueParameter2) {
        block0: {
            Intrinsics.checkNotNullParameter(valueParameter2, "valueParameter");
            super.visitValueParameter(valueParameter2);
            FirProperty firProperty = ClassMembersKt.getCorrespondingProperty(valueParameter2);
            if (firProperty == null) break block0;
            FirProperty it = firProperty;
            boolean bl = false;
            this.visitProperty(it);
        }
    }

    @Override
    public void visitProperty(@NotNull FirProperty property) {
        Intrinsics.checkNotNullParameter(property, "property");
        if (this.visitedProperty.add(property)) {
            super.visitProperty(property);
        }
    }

    @Override
    public void visitScript(@NotNull FirScript script) {
        Intrinsics.checkNotNullParameter(script, "script");
        Iterable $this$forEach$iv = script.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl = false;
            it.accept(this);
        }
    }

    @Override
    public void visitElement(@NotNull FirElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        element.acceptChildren(this);
    }

    @Override
    public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef) {
        block0: {
            Intrinsics.checkNotNullParameter(errorTypeRef, "errorTypeRef");
            this.visitResolvedTypeRef(errorTypeRef);
            FirTypeRef firTypeRef = errorTypeRef.getPartiallyResolvedTypeRef();
            if (firTypeRef == null) break block0;
            firTypeRef.accept(this);
        }
    }

    @Override
    public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef) {
        block0: {
            Intrinsics.checkNotNullParameter(resolvedTypeRef, "resolvedTypeRef");
            this.collector.processTypeRef(resolvedTypeRef);
            resolvedTypeRef.acceptChildren(this);
            FirTypeRef firTypeRef = resolvedTypeRef.getDelegatedTypeRef();
            if (firTypeRef == null) break block0;
            firTypeRef.accept(this);
        }
    }

    @Override
    public void visitResolvedQualifier(@NotNull FirResolvedQualifier resolvedQualifier) {
        Intrinsics.checkNotNullParameter(resolvedQualifier, "resolvedQualifier");
        super.visitResolvedQualifier(resolvedQualifier);
        this.collector.processTypeQualifier(resolvedQualifier);
    }

    @Override
    public void visitErrorResolvedQualifier(@NotNull FirErrorResolvedQualifier errorResolvedQualifier) {
        Intrinsics.checkNotNullParameter(errorResolvedQualifier, "errorResolvedQualifier");
        super.visitErrorResolvedQualifier(errorResolvedQualifier);
        this.collector.processTypeQualifier(errorResolvedQualifier);
    }

    @Override
    public void visitFunctionCall(@NotNull FirFunctionCall functionCall) {
        Intrinsics.checkNotNullParameter(functionCall, "functionCall");
        super.visitFunctionCall(functionCall);
        this.collector.processFunctionCall(functionCall);
    }

    @Override
    public void visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression) {
        Intrinsics.checkNotNullParameter(propertyAccessExpression, "propertyAccessExpression");
        super.visitPropertyAccessExpression(propertyAccessExpression);
        this.collector.processPropertyAccess(propertyAccessExpression);
    }

    @Override
    public void visitThisReference(@NotNull FirThisReference thisReference) {
        Intrinsics.checkNotNullParameter(thisReference, "thisReference");
        super.visitThisReference(thisReference);
        this.collector.processThisReference(thisReference);
    }
}

