/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignation;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ContextCollector;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataContext;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SessionHolderImpl;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/FirTowerDataContextProvider;", "", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$ContextProvider;", "contextProvider", "<init>", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$ContextProvider;)V", "Lorg/jetbrains/kotlin/psi/KtElement;", "ktElement", "Lorg/jetbrains/kotlin/fir/declarations/FirTowerDataContext;", "getClosestAvailableParentContext", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/fir/declarations/FirTowerDataContext;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/ContextCollector$ContextProvider;", "Companion"})
final class FirTowerDataContextProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ContextCollector.ContextProvider contextProvider;

    private FirTowerDataContextProvider(ContextCollector.ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Nullable
    public final FirTowerDataContext getClosestAvailableParentContext(@NotNull KtElement ktElement) {
        Intrinsics.checkNotNullParameter(ktElement, "ktElement");
        Iterator<PsiElement> iterator2 = PsiUtilsKt.getParentsWithSelf(ktElement).iterator();
        while (iterator2.hasNext()) {
            PsiElement parent2 = iterator2.next();
            ContextCollector.Context context = this.contextProvider.get(parent2, ContextCollector.ContextKind.SELF);
            if (context == null) continue;
            return context.getTowerDataContext();
        }
        return null;
    }

    public /* synthetic */ FirTowerDataContextProvider(ContextCollector.ContextProvider contextProvider, DefaultConstructorMarker $constructor_marker) {
        this(contextProvider);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/FirTowerDataContextProvider$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;", "firResolveSession", "Lorg/jetbrains/kotlin/psi/KtElement;", "targetElement", "Lorg/jetbrains/kotlin/analysis/api/fir/components/FirTowerDataContextProvider;", "create", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/analysis/api/fir/components/FirTowerDataContextProvider;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FirTowerDataContextProvider create(@NotNull LLFirResolveSession firResolveSession, @NotNull KtElement targetElement) {
            Intrinsics.checkNotNullParameter(firResolveSession, "firResolveSession");
            Intrinsics.checkNotNullParameter(targetElement, "targetElement");
            KtFile ktFile = targetElement.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue(ktFile, "getContainingKtFile(...)");
            FirFile firFile = LowLevelFirApiFacadeKt.getOrBuildFirFile(ktFile, firResolveSession);
            Companion $this$create_u24lambda_u240 = this;
            boolean bl = false;
            LLFirSession firSession = firResolveSession.getUseSiteFirSession();
            ScopeSession scopeSession = firResolveSession.getScopeSessionFor(firSession);
            SessionHolderImpl sessionHolder = new SessionHolderImpl(firSession, scopeSession);
            FirDesignation designation = ContextCollector.INSTANCE.computeDesignation(firFile, targetElement);
            ContextCollector.ContextProvider contextProvider = ContextCollector.INSTANCE.process(firFile, sessionHolder, designation, false, Companion::create$lambda$1);
            return new FirTowerDataContextProvider(contextProvider, null);
        }

        private static final ContextCollector.FilterResponse create$lambda$1(PsiElement it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return ContextCollector.FilterResponse.CONTINUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

