/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.calls.FirSyntheticPropertiesScope;
import org.jetbrains.kotlin.fir.scopes.FirDelegatingTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0017\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0014\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\t2\u0016\u0010\u0013\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J!\u0010\u001a\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018H\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b \u0010!"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/FirTypeScopeWithSyntheticProperties;", "Lorg/jetbrains/kotlin/fir/scopes/FirDelegatingTypeScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "typeScope", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirSyntheticPropertiesScope;", "syntheticPropertiesScope", "<init>", "(Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;Lorg/jetbrains/kotlin/fir/resolve/calls/FirSyntheticPropertiesScope;)V", "", "Lorg/jetbrains/kotlin/name/Name;", "getCallableNames", "()Ljava/util/Set;", "name", "", "mayContainName", "(Lorg/jetbrains/kotlin/name/Name;)Z", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "", "processor", "processPropertiesByName", "(Lorg/jetbrains/kotlin/name/Name;Lkotlin/jvm/functions/Function1;)V", "Lorg/jetbrains/kotlin/fir/FirSession;", "newSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "newScopeSession", "withReplacedSessionOrNull", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)Lorg/jetbrains/kotlin/analysis/api/fir/components/FirTypeScopeWithSyntheticProperties;", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "getTypeScope", "()Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirSyntheticPropertiesScope;", "getSyntheticPropertiesScope", "()Lorg/jetbrains/kotlin/fir/resolve/calls/FirSyntheticPropertiesScope;"})
final class FirTypeScopeWithSyntheticProperties
extends FirDelegatingTypeScope {
    @NotNull
    private final FirTypeScope typeScope;
    @NotNull
    private final FirSyntheticPropertiesScope syntheticPropertiesScope;

    public FirTypeScopeWithSyntheticProperties(@NotNull FirTypeScope typeScope, @NotNull FirSyntheticPropertiesScope syntheticPropertiesScope) {
        Intrinsics.checkNotNullParameter(typeScope, "typeScope");
        Intrinsics.checkNotNullParameter(syntheticPropertiesScope, "syntheticPropertiesScope");
        super(typeScope);
        this.typeScope = typeScope;
        this.syntheticPropertiesScope = syntheticPropertiesScope;
    }

    @NotNull
    public final FirTypeScope getTypeScope() {
        return this.typeScope;
    }

    @NotNull
    public final FirSyntheticPropertiesScope getSyntheticPropertiesScope() {
        return this.syntheticPropertiesScope;
    }

    @Override
    @NotNull
    public Set<Name> getCallableNames() {
        return SetsKt.plus(this.typeScope.getCallableNames(), (Iterable)this.syntheticPropertiesScope.getCallableNames());
    }

    @Override
    public boolean mayContainName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.typeScope.mayContainName(name) || this.syntheticPropertiesScope.mayContainName(name);
    }

    @Override
    public void processPropertiesByName(@NotNull Name name, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        this.typeScope.processPropertiesByName(name, processor);
        this.syntheticPropertiesScope.processPropertiesByName(name, processor);
    }

    @Override
    @Nullable
    public FirTypeScopeWithSyntheticProperties withReplacedSessionOrNull(@NotNull FirSession newSession, @NotNull ScopeSession newScopeSession) {
        FirSyntheticPropertiesScope firSyntheticPropertiesScope;
        Intrinsics.checkNotNullParameter(newSession, "newSession");
        Intrinsics.checkNotNullParameter(newScopeSession, "newScopeSession");
        FirTypeScope newTypeScope = this.typeScope.withReplacedSessionOrNull(newSession, newScopeSession);
        FirSyntheticPropertiesScope newSyntheticPropertiesScope = this.syntheticPropertiesScope.withReplacedSessionOrNull(newSession, newScopeSession);
        if (newTypeScope == null && newSyntheticPropertiesScope == null) {
            return null;
        }
        FirTypeScope firTypeScope = newTypeScope;
        if (firTypeScope == null) {
            firTypeScope = this.typeScope;
        }
        if ((firSyntheticPropertiesScope = newSyntheticPropertiesScope) == null) {
            firSyntheticPropertiesScope = this.syntheticPropertiesScope;
        }
        return new FirTypeScopeWithSyntheticProperties(firTypeScope, firSyntheticPropertiesScope);
    }
}

