/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.components.ShortenStrategy;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.components.AdditionalImports;
import org.jetbrains.kotlin.analysis.api.fir.components.KaFirReferenceShortenerKt;
import org.jetbrains.kotlin.analysis.api.fir.components.ShortenKDocQualifier;
import org.jetbrains.kotlin.analysis.api.fir.references.KDocReferenceResolver;
import org.jetbrains.kotlin.analysis.api.fir.utils.KtSymbolUtilsKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0016\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014JO\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00062\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\b2\u0016\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\n0\bH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J-\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u001b\u0010!\u001a\u00020\u0017*\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010%R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010&R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010'R$\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010(R$\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\n0\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010(R \u0010+\u001a\b\u0012\u0004\u0012\u00020*0)8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010."}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KDocQualifiersToShortenCollector;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "analysisSession", "Lcom/intellij/openapi/util/TextRange;", "selection", "Lorg/jetbrains/kotlin/analysis/api/fir/components/AdditionalImports;", "additionalImports", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenStrategy;", "classShortenStrategy", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "callableShortenStrategy", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;Lcom/intellij/openapi/util/TextRange;Lorg/jetbrains/kotlin/analysis/api/fir/components/AdditionalImports;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "Lcom/intellij/psi/PsiElement;", "element", "", "visitElement", "(Lcom/intellij/psi/PsiElement;)V", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocName;", "kDocName", "", "shouldShortenKDocQualifier", "(Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocName;Lorg/jetbrains/kotlin/analysis/api/fir/components/AdditionalImports;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Z", "Lorg/jetbrains/kotlin/name/FqName;", "fqNameToShorten", "fqNameOfAvailableSymbol", "Lkotlin/Function0;", "getShortenStrategy", "canShorten", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Lkotlin/jvm/functions/Function0;)Z", "isInNewImports", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/analysis/api/fir/components/AdditionalImports;)Z", "addKDocQualifierToShorten", "(Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocName;)V", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "Lcom/intellij/openapi/util/TextRange;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/AdditionalImports;", "Lkotlin/jvm/functions/Function1;", "", "Lorg/jetbrains/kotlin/analysis/api/fir/components/ShortenKDocQualifier;", "kDocQualifiersToShorten", "Ljava/util/List;", "getKDocQualifiersToShorten", "()Ljava/util/List;"})
final class KDocQualifiersToShortenCollector
extends KtVisitorVoid {
    @NotNull
    private final KaFirSession analysisSession;
    @NotNull
    private final TextRange selection;
    @NotNull
    private final AdditionalImports additionalImports;
    @NotNull
    private final Function1<FirClassLikeSymbol<?>, ShortenStrategy> classShortenStrategy;
    @NotNull
    private final Function1<FirCallableSymbol<?>, ShortenStrategy> callableShortenStrategy;
    @NotNull
    private final List<ShortenKDocQualifier> kDocQualifiersToShorten;

    public KDocQualifiersToShortenCollector(@NotNull KaFirSession analysisSession, @NotNull TextRange selection, @NotNull AdditionalImports additionalImports, @NotNull Function1<? super FirClassLikeSymbol<?>, ? extends ShortenStrategy> classShortenStrategy, @NotNull Function1<? super FirCallableSymbol<?>, ? extends ShortenStrategy> callableShortenStrategy) {
        Intrinsics.checkNotNullParameter(analysisSession, "analysisSession");
        Intrinsics.checkNotNullParameter(selection, "selection");
        Intrinsics.checkNotNullParameter(additionalImports, "additionalImports");
        Intrinsics.checkNotNullParameter(classShortenStrategy, "classShortenStrategy");
        Intrinsics.checkNotNullParameter(callableShortenStrategy, "callableShortenStrategy");
        this.analysisSession = analysisSession;
        this.selection = selection;
        this.additionalImports = additionalImports;
        this.classShortenStrategy = classShortenStrategy;
        this.callableShortenStrategy = callableShortenStrategy;
        this.kDocQualifiersToShorten = new ArrayList();
    }

    @NotNull
    public final List<ShortenKDocQualifier> getKDocQualifiersToShorten() {
        return this.kDocQualifiersToShorten;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        if (!element.getTextRange().intersects(this.selection)) {
            return;
        }
        if (!this.selection.contains(element.getTextRange()) || !(element instanceof KDocName)) {
            element.acceptChildren(this);
            return;
        }
        if (((KDocName)element).getQualifier() == null) {
            return;
        }
        boolean shouldShortenKDocQualifier = this.shouldShortenKDocQualifier((KDocName)element, this.additionalImports, arg_0 -> KDocQualifiersToShortenCollector.visitElement$lambda$0(this, arg_0), arg_0 -> KDocQualifiersToShortenCollector.visitElement$lambda$1(this, arg_0));
        if (shouldShortenKDocQualifier) {
            this.addKDocQualifierToShorten((KDocName)element);
        } else {
            ((KDocName)element).acceptChildren(this);
            KDocName kDocName = ((KDocName)element).getQualifier();
            if (Intrinsics.areEqual(kDocName != null ? kDocName.getNameText() : null, "_root_ide_package_")) {
                this.addKDocQualifierToShorten((KDocName)element);
            }
        }
    }

    private final boolean shouldShortenKDocQualifier(KDocName kDocName, AdditionalImports additionalImports, Function1<? super FirClassLikeSymbol<?>, ? extends ShortenStrategy> classShortenStrategy, Function1<? super FirCallableSymbol<?>, ? extends ShortenStrategy> callableShortenStrategy) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        Object v4;
        KaDeclarationSymbol kaDeclarationSymbol;
        FqName fqName2;
        block8: {
            Iterator availableCallable;
            Object v3;
            Object element$iv;
            boolean $i$f$firstIsInstanceOrNull;
            Iterator $this$firstIsInstanceOrNull$iv;
            Collection<KaSymbol> resolvedSymbols;
            block7: {
                KtAnnotated ktAnnotated;
                KtDeclaration owner;
                fqName2 = KaFirReferenceShortenerKt.access$dropFakeRootPrefixIfPresent(kDocName.getQualifiedNameAsFqName());
                if (this.isInNewImports(fqName2, additionalImports)) {
                    return true;
                }
                KaFirSession $this$shouldShortenKDocQualifier_u24lambda_u242 = this.analysisSession;
                boolean bl = false;
                Object shortFqName = FqName.Companion.topLevel(fqName2.shortName());
                KtDeclaration ktDeclaration = owner = kDocName.getContainingDoc().getOwner();
                if (ktDeclaration != null) {
                    ktAnnotated = ktDeclaration;
                } else {
                    KtFile ktFile = kDocName.getContainingKtFile();
                    Intrinsics.checkNotNullExpressionValue(ktFile, "getContainingKtFile(...)");
                    ktAnnotated = ktFile;
                }
                KtAnnotated contextElement = ktAnnotated;
                resolvedSymbols = KDocReferenceResolver.INSTANCE.resolveKdocFqName$analysis_api_fir($this$shouldShortenKDocQualifier_u24lambda_u242.getUseSiteSession(), (FqName)shortFqName, (FqName)shortFqName, contextElement);
                $this$firstIsInstanceOrNull$iv = resolvedSymbols;
                $i$f$firstIsInstanceOrNull = false;
                shortFqName = $this$firstIsInstanceOrNull$iv.iterator();
                while (shortFqName.hasNext()) {
                    element$iv = shortFqName.next();
                    if (!(element$iv instanceof KaCallableSymbol)) continue;
                    v3 = element$iv;
                    break block7;
                }
                v3 = null;
            }
            kaDeclarationSymbol = v3;
            if (kaDeclarationSymbol != null && ($this$firstIsInstanceOrNull$iv = KtSymbolUtilsKt.getFirSymbol(kaDeclarationSymbol)) != null) {
                availableCallable = $this$firstIsInstanceOrNull$iv;
                boolean bl = false;
                return this.canShorten(fqName2, ((FirCallableSymbol)((Object)availableCallable)).getCallableId().asSingleFqName(), () -> KDocQualifiersToShortenCollector.shouldShortenKDocQualifier$lambda$4$lambda$3(callableShortenStrategy, availableCallable));
            }
            $this$firstIsInstanceOrNull$iv = resolvedSymbols;
            $i$f$firstIsInstanceOrNull = false;
            availableCallable = $this$firstIsInstanceOrNull$iv.iterator();
            while (availableCallable.hasNext()) {
                element$iv = availableCallable.next();
                if (!(element$iv instanceof KaClassLikeSymbol)) continue;
                v4 = element$iv;
                break block8;
            }
            v4 = null;
        }
        kaDeclarationSymbol = v4;
        if (kaDeclarationSymbol != null && (firClassLikeSymbol = KtSymbolUtilsKt.getFirSymbol((KaClassLikeSymbol)kaDeclarationSymbol)) != null) {
            FirClassLikeSymbol<?> availableClassifier = firClassLikeSymbol;
            boolean bl = false;
            return this.canShorten(fqName2, availableClassifier.getClassId().asSingleFqName(), () -> KDocQualifiersToShortenCollector.shouldShortenKDocQualifier$lambda$6$lambda$5(classShortenStrategy, availableClassifier));
        }
        return false;
    }

    private final boolean canShorten(FqName fqNameToShorten, FqName fqNameOfAvailableSymbol, Function0<? extends ShortenStrategy> getShortenStrategy) {
        return Intrinsics.areEqual(fqNameToShorten, fqNameOfAvailableSymbol) && getShortenStrategy.invoke() != ShortenStrategy.DO_NOT_SHORTEN;
    }

    private final boolean isInNewImports(FqName $this$isInNewImports, AdditionalImports additionalImports) {
        return additionalImports.getSimpleImports().contains($this$isInNewImports) || additionalImports.getStarImports().contains($this$isInNewImports.parent());
    }

    private final void addKDocQualifierToShorten(KDocName kDocName) {
        this.kDocQualifiersToShorten.add(new ShortenKDocQualifier(kDocName));
    }

    private static final ShortenStrategy visitElement$lambda$0(KDocQualifiersToShortenCollector this$0, FirClassLikeSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.classShortenStrategy.invoke(it);
    }

    private static final ShortenStrategy visitElement$lambda$1(KDocQualifiersToShortenCollector this$0, FirCallableSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.callableShortenStrategy.invoke(it);
    }

    private static final ShortenStrategy shouldShortenKDocQualifier$lambda$4$lambda$3(Function1 $callableShortenStrategy, FirCallableSymbol $availableCallable) {
        return (ShortenStrategy)((Object)$callableShortenStrategy.invoke($availableCallable));
    }

    private static final ShortenStrategy shouldShortenKDocQualifier$lambda$6$lambda$5(Function1 $classShortenStrategy, FirClassLikeSymbol $availableClassifier) {
        return (ShortenStrategy)((Object)$classShortenStrategy.invoke($availableClassifier));
    }
}

