/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotationValue;
import org.jetbrains.kotlin.analysis.api.base.KaConstantValue;
import org.jetbrains.kotlin.analysis.api.components.KaEvaluator;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.components.KaFirSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirAnnotationValueConverter;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirCompileTimeConstantEvaluator;
import org.jetbrains.kotlin.analysis.api.impl.base.KaErrorConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.components.KaBaseSessionComponent;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInaccessibleLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInvalidLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u0015\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u0004\u0018\u00010\n*\u00020\tH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u0004\u0018\u00010\r*\u00020\tH\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ#\u0010\u0013\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirEvaluator;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseSessionComponent;", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "Lorg/jetbrains/kotlin/analysis/api/components/KaEvaluator;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirSessionComponent;", "Lkotlin/Function0;", "analysisSessionProvider", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/analysis/api/base/KaConstantValue;", "evaluate", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/analysis/api/base/KaConstantValue;", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue;", "evaluateAsAnnotationValue", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue;", "Lorg/jetbrains/kotlin/fir/FirElement;", "fir", "sourcePsi", "evaluateFir", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/analysis/api/base/KaConstantValue;", "Lkotlin/jvm/functions/Function0;", "getAnalysisSessionProvider", "()Lkotlin/jvm/functions/Function0;"})
public final class KaFirEvaluator
extends KaBaseSessionComponent<KaFirSession>
implements KaEvaluator,
KaFirSessionComponent {
    @NotNull
    private final Function0<KaFirSession> analysisSessionProvider;

    public KaFirEvaluator(@NotNull Function0<KaFirSession> analysisSessionProvider) {
        Intrinsics.checkNotNullParameter(analysisSessionProvider, "analysisSessionProvider");
        this.analysisSessionProvider = analysisSessionProvider;
    }

    @Override
    @NotNull
    public Function0<KaFirSession> getAnalysisSessionProvider() {
        return this.analysisSessionProvider;
    }

    @Override
    @Nullable
    public KaConstantValue evaluate(@NotNull KtExpression $this$evaluate) {
        Intrinsics.checkNotNullParameter($this$evaluate, "<this>");
        KaLifetimeOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        KaLifetimeOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KaLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        KaLifetimeToken $this$assertIsValid$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsValid = false;
        if (!$this$assertIsValid$iv$iv$iv$iv.isValid()) {
            throw new KaInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValid$iv$iv$iv$iv + ": " + $this$assertIsValid$iv$iv$iv$iv.getInvalidationReason());
        }
        KaLifetimeToken $this$assertIsAccessible$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsAccessible = false;
        if (!$this$assertIsAccessible$iv$iv$iv$iv.isAccessible()) {
            throw new KaInaccessibleLifetimeOwnerAccessException($this$assertIsAccessible$iv$iv$iv$iv + " is inaccessible: " + $this$assertIsAccessible$iv$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        return this.evaluateFir(LowLevelFirApiFacadeKt.getOrBuildFir($this$evaluate, this.getFirResolveSession()), $this$evaluate);
    }

    @Override
    @Nullable
    public KaAnnotationValue evaluateAsAnnotationValue(@NotNull KtExpression $this$evaluateAsAnnotationValue) {
        KaAnnotationValue kaAnnotationValue;
        Intrinsics.checkNotNullParameter($this$evaluateAsAnnotationValue, "<this>");
        KaLifetimeOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        KaLifetimeOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KaLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        KaLifetimeToken $this$assertIsValid$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsValid = false;
        if (!$this$assertIsValid$iv$iv$iv$iv.isValid()) {
            throw new KaInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValid$iv$iv$iv$iv + ": " + $this$assertIsValid$iv$iv$iv$iv.getInvalidationReason());
        }
        KaLifetimeToken $this$assertIsAccessible$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsAccessible = false;
        if (!$this$assertIsAccessible$iv$iv$iv$iv.isAccessible()) {
            throw new KaInaccessibleLifetimeOwnerAccessException($this$assertIsAccessible$iv$iv$iv$iv + " is inaccessible: " + $this$assertIsAccessible$iv$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        FirElement firElement = LowLevelFirApiFacadeKt.getOrBuildFir($this$evaluateAsAnnotationValue, this.getFirResolveSession());
        FirExpression firExpression = firElement instanceof FirExpression ? (FirExpression)firElement : null;
        if (firExpression != null) {
            FirExpression it = firExpression;
            boolean bl2 = false;
            kaAnnotationValue = FirAnnotationValueConverter.INSTANCE.toConstantValue(it, ((KaFirSession)this.getAnalysisSession()).getFirSymbolBuilder$analysis_api_fir());
        } else {
            kaAnnotationValue = null;
        }
        return kaAnnotationValue;
    }

    private final KaConstantValue evaluateFir(FirElement fir, KtExpression sourcePsi) {
        KaConstantValue kaConstantValue;
        if (fir instanceof FirPropertyAccessExpression || fir instanceof FirExpression || fir instanceof FirNamedReference) {
            KaConstantValue kaConstantValue2;
            try {
                kaConstantValue2 = FirCompileTimeConstantEvaluator.INSTANCE.evaluateAsKtConstantValue(fir);
            }
            catch (ArithmeticException e) {
                String string2 = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue(string2, "getLocalizedMessage(...)");
                kaConstantValue2 = new KaErrorConstantValueImpl(string2, sourcePsi);
            }
            kaConstantValue = kaConstantValue2;
        } else {
            kaConstantValue = null;
        }
        return kaConstantValue;
    }
}

