/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaSimpleVariableAccessCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaSuccessCallInfo;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001b\u0010\u0007\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u001f\u0010\f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\f\u0010\r\u001a#\u0010\u0010\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u001b\u0010\u0014\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u001b\u0010\u0018\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019"}, d2={"Lcom/intellij/psi/PsiElement;", "lhs", "", "doesDoubleColonUseLHS", "(Lcom/intellij/psi/PsiElement;)Z", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "callee", "doesCallExpressionUseCallee", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lcom/intellij/psi/PsiElement;)Z", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "propertyAccessor", "body", "doesPropertyAccessorUseBody", "(Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;Lcom/intellij/psi/PsiElement;)Z", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "namedFunction", "doesNamedFunctionUseBody", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lcom/intellij/psi/PsiElement;)Z", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "reference", "isSimpleVariableAccessCall", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtReferenceExpression;)Z", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "returnsUnit", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z"})
public final class KaFirExpressionInformationProviderKt {
    private static final boolean doesDoubleColonUseLHS(PsiElement lhs) {
        Object object;
        PsiElement inner = PsiUtilsKt.unwrapParenthesesLabelsAndAnnotations(lhs);
        if (inner instanceof KtReferenceExpression) {
            object = ReferenceUtilsKt.getMainReference((KtReferenceExpression)inner);
        } else if (inner instanceof KtDotQualifiedExpression) {
            KtExpression ktExpression = ((KtDotQualifiedExpression)inner).getSelectorExpression();
            object = ktExpression instanceof KtReferenceExpression ? (KtReferenceExpression)ktExpression : null;
            if (object == null || (object = ReferenceUtilsKt.getMainReference((KtReferenceExpression)object)) == null) {
                return true;
            }
        } else {
            return true;
        }
        KtReference reference = object;
        PsiElement resolution = reference.resolve();
        return resolution != null && !(resolution instanceof KtClass);
    }

    private static final boolean doesCallExpressionUseCallee(KaSession $this$doesCallExpressionUseCallee, PsiElement callee) {
        return !(callee instanceof KtReferenceExpression) || KaFirExpressionInformationProviderKt.isSimpleVariableAccessCall($this$doesCallExpressionUseCallee, (KtReferenceExpression)callee);
    }

    private static final boolean doesPropertyAccessorUseBody(KtPropertyAccessor propertyAccessor, PsiElement body2) {
        return propertyAccessor.isSetter() || propertyAccessor.isGetter() && !(body2 instanceof KtBlockExpression);
    }

    private static final boolean doesNamedFunctionUseBody(KaSession $this$doesNamedFunctionUseBody, KtNamedFunction namedFunction, PsiElement body2) {
        boolean bl;
        if (Intrinsics.areEqual(namedFunction.getBodyBlockExpression(), body2)) {
            bl = false;
        } else if (!KaFirExpressionInformationProviderKt.returnsUnit($this$doesNamedFunctionUseBody, namedFunction)) {
            bl = true;
        } else if (Intrinsics.areEqual(namedFunction.getBodyExpression(), body2)) {
            Intrinsics.checkNotNull(body2, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            KaType kaType = $this$doesNamedFunctionUseBody.getExpressionType((KtExpression)body2);
            bl = kaType != null ? $this$doesNamedFunctionUseBody.isUnitType(kaType) : false;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean isSimpleVariableAccessCall(KaSession $this$isSimpleVariableAccessCall, KtReferenceExpression reference) {
        KaCallInfo resolution = $this$isSimpleVariableAccessCall.resolveToCall(reference);
        return resolution instanceof KaSuccessCallInfo ? ((KaSuccessCallInfo)resolution).getCall() instanceof KaSimpleVariableAccessCall : false;
    }

    private static final boolean returnsUnit(KaSession $this$returnsUnit, KtDeclaration declaration) {
        return $this$returnsUnit.isUnitType($this$returnsUnit.getReturnType(declaration));
    }

    public static final /* synthetic */ boolean access$doesPropertyAccessorUseBody(KtPropertyAccessor propertyAccessor, PsiElement body2) {
        return KaFirExpressionInformationProviderKt.doesPropertyAccessorUseBody(propertyAccessor, body2);
    }

    public static final /* synthetic */ boolean access$returnsUnit(KaSession $receiver, KtDeclaration declaration) {
        return KaFirExpressionInformationProviderKt.returnsUnit($receiver, declaration);
    }

    public static final /* synthetic */ boolean access$doesNamedFunctionUseBody(KaSession $receiver, KtNamedFunction namedFunction, PsiElement body2) {
        return KaFirExpressionInformationProviderKt.doesNamedFunctionUseBody($receiver, namedFunction, body2);
    }

    public static final /* synthetic */ boolean access$doesCallExpressionUseCallee(KaSession $receiver, PsiElement callee) {
        return KaFirExpressionInformationProviderKt.doesCallExpressionUseCallee($receiver, callee);
    }

    public static final /* synthetic */ boolean access$doesDoubleColonUseLHS(PsiElement lhs) {
        return KaFirExpressionInformationProviderKt.doesDoubleColonUseLHS(lhs);
    }
}

