/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.analysis.api.fir.FirUtilsKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedReferenceError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedSymbolError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedTypeQualifierError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\"\u001a\u0010\b\u001a\u0004\u0018\u00010\u0005*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u001a\u0010\b\u001a\u0004\u0018\u00010\u0005*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\n\"\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u0005*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u0005*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u0005*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u001e\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0018*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\"\u001a\u0010 \u001a\u0004\u0018\u00010\u001d*\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\"\u0018\u0010$\u001a\u00020!*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\"\u0018\u0010%\u001a\u00020!*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010#"}, d2={"Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getPossiblyQualifiedSimpleNameExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "Lorg/jetbrains/kotlin/fir/references/FirErrorNamedReference;", "Lorg/jetbrains/kotlin/name/Name;", "getUnresolvedName", "(Lorg/jetbrains/kotlin/fir/references/FirErrorNamedReference;)Lorg/jetbrains/kotlin/name/Name;", "unresolvedName", "Lorg/jetbrains/kotlin/fir/resolve/diagnostics/ConeUnresolvedError;", "(Lorg/jetbrains/kotlin/fir/resolve/diagnostics/ConeUnresolvedError;)Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "getCallableReferenceName", "(Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;)Lorg/jetbrains/kotlin/name/Name;", "callableReferenceName", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "getFunctionReferenceName", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Lorg/jetbrains/kotlin/name/Name;", "functionReferenceName", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "getPropertyReferenceName", "(Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;)Lorg/jetbrains/kotlin/name/Name;", "propertyReferenceName", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getReferencedCallableSymbol", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "referencedCallableSymbol", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/name/ClassId;", "getResolvedClassId", "(Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;)Lorg/jetbrains/kotlin/name/ClassId;", "resolvedClassId", "", "getDispatchedWithoutImport", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)Z", "dispatchedWithoutImport", "isQualifiedWithPackage"})
public final class KaFirImportOptimizerKt {
    private static final Name getUnresolvedName(FirErrorNamedReference $this$unresolvedName) {
        ConeDiagnostic diagnostic = $this$unresolvedName.getDiagnostic();
        return diagnostic instanceof ConeUnresolvedError ? KaFirImportOptimizerKt.getUnresolvedName((ConeUnresolvedError)diagnostic) : (diagnostic instanceof ConeAmbiguityError ? ((ConeAmbiguityError)diagnostic).getName() : null);
    }

    private static final Name getUnresolvedName(ConeUnresolvedError $this$unresolvedName) {
        Name name;
        ConeUnresolvedError coneUnresolvedError = $this$unresolvedName;
        if (coneUnresolvedError instanceof ConeUnresolvedNameError) {
            name = ((ConeUnresolvedNameError)$this$unresolvedName).getName();
        } else if (coneUnresolvedError instanceof ConeUnresolvedReferenceError) {
            name = ((ConeUnresolvedReferenceError)$this$unresolvedName).getName();
        } else if (coneUnresolvedError instanceof ConeUnresolvedSymbolError) {
            name = ((ConeUnresolvedSymbolError)$this$unresolvedName).getClassId().getShortClassName();
        } else if (coneUnresolvedError instanceof ConeUnresolvedTypeQualifierError) {
            FirQualifierPart firQualifierPart = CollectionsKt.firstOrNull(((ConeUnresolvedTypeQualifierError)$this$unresolvedName).getQualifiers());
            name = firQualifierPart != null ? firQualifierPart.getName() : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return name;
    }

    private static final Name getCallableReferenceName(FirCallableReferenceAccess $this$callableReferenceName) {
        FirResolvedNamedReference firResolvedNamedReference = ReferenceUtilsKt.toResolvedCallableReference($this$callableReferenceName);
        if (firResolvedNamedReference != null) {
            FirResolvedNamedReference it = firResolvedNamedReference;
            boolean bl = false;
            return it.getName();
        }
        PsiElement psiElement = UtilsKt.getRealPsi($this$callableReferenceName);
        KtCallableReferenceExpression wholeCallableReferenceExpression = psiElement instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)psiElement : null;
        KtExpression ktExpression = wholeCallableReferenceExpression;
        return ktExpression != null && (ktExpression = ((KtCallableReferenceExpression)ktExpression).getCallableReference()) != null ? ktExpression.getReferencedNameAsName() : null;
    }

    private static final Name getFunctionReferenceName(FirFunctionCall $this$functionReferenceName) {
        KtExpression wholeCallExpression;
        FirResolvedNamedReference firResolvedNamedReference = ReferenceUtilsKt.toResolvedCallableReference($this$functionReferenceName);
        if (firResolvedNamedReference != null) {
            FirResolvedNamedReference it = firResolvedNamedReference;
            boolean bl = false;
            return it.getName();
        }
        PsiElement psiElement = UtilsKt.getRealPsi($this$functionReferenceName);
        KtExpression ktExpression = wholeCallExpression = psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
        KtCallExpression callExpression = ktExpression != null ? KtPsiUtilKt.getPossiblyQualifiedCallExpression(ktExpression) : null;
        KtReferenceExpression ktReferenceExpression = callExpression;
        return ktReferenceExpression != null && (ktReferenceExpression = KtPsiUtilKt.getCallNameExpression((KtCallElement)((Object)ktReferenceExpression))) != null ? ktReferenceExpression.getReferencedNameAsName() : null;
    }

    private static final Name getPropertyReferenceName(FirPropertyAccessExpression $this$propertyReferenceName) {
        KtSimpleNameExpression propertyNameExpression;
        KtExpression wholePropertyAccessExpression;
        FirResolvedNamedReference firResolvedNamedReference = ReferenceUtilsKt.toResolvedCallableReference($this$propertyReferenceName);
        if (firResolvedNamedReference != null) {
            FirResolvedNamedReference it = firResolvedNamedReference;
            boolean bl = false;
            return it.getName();
        }
        PsiElement psiElement = UtilsKt.getRealPsi($this$propertyReferenceName);
        KtExpression ktExpression = wholePropertyAccessExpression = psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
        KtSimpleNameExpression ktSimpleNameExpression = propertyNameExpression = ktExpression != null ? KaFirImportOptimizerKt.getPossiblyQualifiedSimpleNameExpression(ktExpression) : null;
        return ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null;
    }

    private static final FirCallableSymbol<?> getReferencedCallableSymbol(FirQualifiedAccessExpression $this$referencedCallableSymbol) {
        return ReferenceUtilsKt.toResolvedCallableSymbol($this$referencedCallableSymbol);
    }

    private static final ClassId getResolvedClassId(FirResolvedTypeRef $this$resolvedClassId) {
        FirClassLikeSymbol singleClassSymbol;
        if (!($this$resolvedClassId instanceof FirErrorTypeRef)) {
            return ConeTypeUtilsKt.getClassId(ConeTypeUtilsKt.lowerBoundIfFlexible(AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf($this$resolvedClassId.getConeType())));
        }
        Collection<FirBasedSymbol<?>> candidateSymbols = FirUtilsKt.getCandidateSymbols(((FirErrorTypeRef)$this$resolvedClassId).getDiagnostic());
        Object t = CollectionsKt.singleOrNull((Iterable)candidateSymbols);
        FirClassLikeSymbol firClassLikeSymbol = singleClassSymbol = t instanceof FirClassLikeSymbol ? (FirClassLikeSymbol)t : null;
        return firClassLikeSymbol != null ? firClassLikeSymbol.getClassId() : null;
    }

    private static final boolean getDispatchedWithoutImport(FirQualifiedAccessExpression $this$dispatchedWithoutImport) {
        return KaFirImportOptimizerKt.isQualifiedWithPackage($this$dispatchedWithoutImport) ? true : ($this$dispatchedWithoutImport.getDispatchReceiver() instanceof FirThisReceiverExpression ? true : $this$dispatchedWithoutImport.getExplicitReceiver() != null && Intrinsics.areEqual($this$dispatchedWithoutImport.getDispatchReceiver(), $this$dispatchedWithoutImport.getExplicitReceiver()));
    }

    private static final boolean isQualifiedWithPackage(FirQualifiedAccessExpression $this$isQualifiedWithPackage) {
        FirExpression receiver = $this$isQualifiedWithPackage.getExplicitReceiver();
        return receiver instanceof FirResolvedQualifier && ((FirResolvedQualifier)receiver).getRelativeClassFqName() == null;
    }

    private static final KtSimpleNameExpression getPossiblyQualifiedSimpleNameExpression(KtExpression $this$getPossiblyQualifiedSimpleNameExpression) {
        KtExpression ktExpression;
        KtExpression ktExpression2 = $this$getPossiblyQualifiedSimpleNameExpression instanceof KtQualifiedExpression ? (KtQualifiedExpression)$this$getPossiblyQualifiedSimpleNameExpression : null;
        if (ktExpression2 == null || (ktExpression2 = ktExpression2.getSelectorExpression()) == null) {
            ktExpression2 = $this$getPossiblyQualifiedSimpleNameExpression;
        }
        return (ktExpression = ktExpression2) instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
    }

    public static final /* synthetic */ Name access$getUnresolvedName(FirErrorNamedReference $receiver) {
        return KaFirImportOptimizerKt.getUnresolvedName($receiver);
    }

    public static final /* synthetic */ Name access$getUnresolvedName(ConeUnresolvedError $receiver) {
        return KaFirImportOptimizerKt.getUnresolvedName($receiver);
    }

    public static final /* synthetic */ boolean access$getDispatchedWithoutImport(FirQualifiedAccessExpression $receiver) {
        return KaFirImportOptimizerKt.getDispatchedWithoutImport($receiver);
    }

    public static final /* synthetic */ Name access$getFunctionReferenceName(FirFunctionCall $receiver) {
        return KaFirImportOptimizerKt.getFunctionReferenceName($receiver);
    }

    public static final /* synthetic */ Name access$getPropertyReferenceName(FirPropertyAccessExpression $receiver) {
        return KaFirImportOptimizerKt.getPropertyReferenceName($receiver);
    }

    public static final /* synthetic */ Name access$getCallableReferenceName(FirCallableReferenceAccess $receiver) {
        return KaFirImportOptimizerKt.getCallableReferenceName($receiver);
    }

    public static final /* synthetic */ FirCallableSymbol access$getReferencedCallableSymbol(FirQualifiedAccessExpression $receiver) {
        return KaFirImportOptimizerKt.getReferencedCallableSymbol($receiver);
    }

    public static final /* synthetic */ ClassId access$getResolvedClassId(FirResolvedTypeRef $receiver) {
        return KaFirImportOptimizerKt.getResolvedClassId($receiver);
    }
}

