/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.evaluate;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.api.base.KaConstantValue;
import org.jetbrains.kotlin.analysis.api.impl.base.KaBooleanConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaByteConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaCharConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaDoubleConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaFloatConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaIntConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaLongConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaNullConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaShortConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaStringConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaUnsignedByteConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaUnsignedIntConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaUnsignedLongConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaUnsignedShortConstantValueImpl;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.OperationsMapGeneratedKt;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\t\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0082\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u0004\u0018\u00010\r*\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0011\u001a\u0004\u0018\u00010\r*\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0014J\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\r*\u00020\rH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0019\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0019\u0010 \u001a\u0004\u0018\u00010\r2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b \u0010!J\u001b\u0010$\u001a\u00020\r*\u00020\r2\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b$\u0010%J\u0013\u0010(\u001a\u00020'*\u00020&H\u0002\u00a2\u0006\u0004\b(\u0010)J%\u0010\u000e\u001a\u0004\u0018\u00010\r*\u00020\r2\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020+H\u0002\u00a2\u0006\u0004\b\u000e\u0010-J\u0015\u0010.\u001a\u0004\u0018\u00010\r*\u00020\rH\u0002\u00a2\u0006\u0004\b.\u0010\u0019J-\u0010\u000e\u001a\u0004\u0018\u00010\r*\u00020\r2\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020+2\u0006\u0010/\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u00100J\u0015\u00101\u001a\u0004\u0018\u00010&*\u00020\"H\u0002\u00a2\u0006\u0004\b1\u00102J\u0015\u00101\u001a\u0004\u0018\u00010&*\u000203H\u0002\u00a2\u0006\u0004\b1\u00104J\u0019\u00101\u001a\u00020&\"\u0004\b\u0000\u00105*\u00028\u0000H\u0002\u00a2\u0006\u0004\b1\u00106J\u001f\u00108\u001a\u0004\u0018\u00010\u0001*\u00020&2\b\u00107\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0004\b8\u00109J'\u0010\u0011\u001a\u00020\r*\u00020&2\b\u0010;\u001a\u0004\u0018\u00010:2\b\u00107\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0004\b\u0011\u0010<J\u0015\u0010>\u001a\u0004\u0018\u00010=*\u00020\u001eH\u0002\u00a2\u0006\u0004\b>\u0010?RT\u0010B\u001aB\u0012\u001c\u0012\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050A0A* \u0012\u001c\u0012\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050A0A0@0@8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0018\u0010F\u001a\u00020E*\u00020D8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR\u0018\u0010H\u001a\u00020E*\u00020D8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010GR\u0018\u0010I\u001a\u00020E*\u00020D8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010G"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/evaluate/FirCompileTimeConstantEvaluator;", "", "<init>", "()V", "R", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "variableSymbol", "Lkotlin/Function0;", "f", "withTrackingVariableEvaluation", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lorg/jetbrains/kotlin/fir/FirElement;", "fir", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "evaluate", "(Lorg/jetbrains/kotlin/fir/FirElement;)Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "toLiteralExpression", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFieldSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirFieldSymbol;)Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "Lorg/jetbrains/kotlin/analysis/api/base/KaConstantValue;", "evaluateAsKtConstantValue", "(Lorg/jetbrains/kotlin/fir/FirElement;)Lorg/jetbrains/kotlin/analysis/api/base/KaConstantValue;", "adaptToConstKind", "(Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;", "stringConcatenationCall", "evaluateStringConcatenationCall", "(Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;)Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "functionCall", "evaluateFunctionCall", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "expectedType", "adjustType", "(Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "toCompileTimeType", "(Lorg/jetbrains/kotlin/types/ConstantValueKind;)Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "firFunctionCall", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "function", "(Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "evaluateStringLength", "other", "(Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "toConstantValueKind", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/types/ConstantValueKind;", "", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/types/ConstantValueKind;", "T", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/types/ConstantValueKind;", "value", "convertToNumber", "(Lorg/jetbrains/kotlin/types/ConstantValueKind;Ljava/lang/Object;)Ljava/lang/Object;", "Lorg/jetbrains/kotlin/KtSourceElement;", "source", "(Lorg/jetbrains/kotlin/types/ConstantValueKind;Lorg/jetbrains/kotlin/KtSourceElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "getOriginalFunction", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Ljava/lang/ThreadLocal;", "", "variablesInProcessOfEvaluation", "Ljava/lang/ThreadLocal;", "Lorg/jetbrains/kotlin/name/CallableId;", "", "isStringLength", "(Lorg/jetbrains/kotlin/name/CallableId;)Z", "isStringEquals", "isStringPlus"})
public final class FirCompileTimeConstantEvaluator {
    @NotNull
    public static final FirCompileTimeConstantEvaluator INSTANCE = new FirCompileTimeConstantEvaluator();
    private static final ThreadLocal<Set<FirVariableSymbol<?>>> variablesInProcessOfEvaluation = ThreadLocal.withInitial(FirCompileTimeConstantEvaluator::variablesInProcessOfEvaluation$lambda$0);

    private FirCompileTimeConstantEvaluator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R withTrackingVariableEvaluation(FirVariableSymbol<?> variableSymbol, Function0<? extends R> f) {
        R r;
        boolean $i$f$withTrackingVariableEvaluation = false;
        if (!variablesInProcessOfEvaluation.get().add(variableSymbol)) {
            return null;
        }
        try {
            r = f.invoke();
        }
        finally {
            InlineMarker.finallyStart(1);
            variablesInProcessOfEvaluation.get().remove(variableSymbol);
            InlineMarker.finallyEnd(1);
        }
        return r;
    }

    @Nullable
    public final FirLiteralExpression evaluate(@Nullable FirElement fir) {
        FirLiteralExpression firLiteralExpression;
        FirElement firElement = fir;
        if (firElement instanceof FirPropertyAccessExpression) {
            FirVariableSymbol referredVariable = FirReferenceUtilsKt.toResolvedVariableSymbol$default(((FirPropertyAccessExpression)fir).getCalleeReference(), false, 1, null);
            if (referredVariable instanceof FirPropertySymbol) {
                if (this.isStringLength(((FirPropertySymbol)referredVariable).getCallableId())) {
                    FirLiteralExpression firLiteralExpression2 = this.evaluate(((FirPropertyAccessExpression)fir).getExplicitReceiver());
                    firLiteralExpression = firLiteralExpression2 != null ? this.evaluateStringLength(firLiteralExpression2) : null;
                } else {
                    firLiteralExpression = this.toLiteralExpression((FirPropertySymbol)referredVariable);
                }
            } else {
                firLiteralExpression = referredVariable instanceof FirFieldSymbol ? this.toLiteralExpression((FirFieldSymbol)referredVariable) : null;
            }
        } else if (firElement instanceof FirLiteralExpression) {
            firLiteralExpression = this.adaptToConstKind((FirLiteralExpression)fir);
        } else if (firElement instanceof FirFunctionCall) {
            firLiteralExpression = this.evaluateFunctionCall((FirFunctionCall)fir);
        } else if (firElement instanceof FirStringConcatenationCall) {
            firLiteralExpression = this.evaluateStringConcatenationCall((FirStringConcatenationCall)fir);
        } else if (firElement instanceof FirNamedReference) {
            FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)fir, false, 1, null);
            firLiteralExpression = firPropertySymbol != null ? this.toLiteralExpression(firPropertySymbol) : null;
        } else {
            firLiteralExpression = null;
        }
        return firLiteralExpression;
    }

    private final boolean isStringLength(CallableId $this$isStringLength) {
        return Intrinsics.areEqual($this$isStringLength.getClassId(), StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual($this$isStringLength.getCallableName().getIdentifierOrNullIfSpecial(), "length");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FirLiteralExpression toLiteralExpression(FirPropertySymbol $this$toLiteralExpression) {
        FirLiteralExpression firLiteralExpression;
        FirCallableSymbol $this$isConst$iv = $this$toLiteralExpression;
        boolean $i$f$isConst = false;
        if ($this$isConst$iv.getRawStatus().isConst() && $this$toLiteralExpression.isVal()) {
            FirCompileTimeConstantEvaluator this_$iv = this;
            boolean $i$f$withTrackingVariableEvaluation = false;
            if (!variablesInProcessOfEvaluation.get().add($this$toLiteralExpression)) {
                firLiteralExpression = null;
            } else {
                FirLiteralExpression firLiteralExpression2;
                try {
                    boolean bl = false;
                    firLiteralExpression2 = INSTANCE.evaluate($this$toLiteralExpression.getResolvedInitializer());
                }
                finally {
                    variablesInProcessOfEvaluation.get().remove($this$toLiteralExpression);
                }
                firLiteralExpression = firLiteralExpression2;
            }
        } else {
            firLiteralExpression = null;
        }
        return firLiteralExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FirLiteralExpression toLiteralExpression(FirFieldSymbol $this$toLiteralExpression) {
        FirLiteralExpression firLiteralExpression;
        FirCallableSymbol $this$isStatic$iv = $this$toLiteralExpression;
        boolean $i$f$isStatic = false;
        if ($this$isStatic$iv.getRawStatus().isStatic() && $this$toLiteralExpression.isVal()) {
            FirCompileTimeConstantEvaluator this_$iv = this;
            boolean $i$f$withTrackingVariableEvaluation = false;
            if (!variablesInProcessOfEvaluation.get().add($this$toLiteralExpression)) {
                firLiteralExpression = null;
            } else {
                FirLiteralExpression firLiteralExpression2;
                try {
                    boolean bl = false;
                    firLiteralExpression2 = INSTANCE.evaluate($this$toLiteralExpression.getResolvedInitializer());
                }
                finally {
                    variablesInProcessOfEvaluation.get().remove($this$toLiteralExpression);
                }
                firLiteralExpression = firLiteralExpression2;
            }
        } else {
            firLiteralExpression = null;
        }
        return firLiteralExpression;
    }

    @Nullable
    public final KaConstantValue evaluateAsKtConstantValue(@NotNull FirElement fir) {
        KaConstantValue kaConstantValue;
        Intrinsics.checkNotNullParameter(fir, "fir");
        FirLiteralExpression firLiteralExpression = this.evaluate(fir);
        if (firLiteralExpression == null) {
            return null;
        }
        FirLiteralExpression evaluated = firLiteralExpression;
        Object value2 = evaluated.getValue();
        Object object = UtilsKt.getPsi(evaluated);
        KtElement psi = object instanceof KtElement ? (KtElement)object : null;
        object = evaluated.getKind();
        if (Intrinsics.areEqual(object, ConstantValueKind.Byte.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Byte");
            kaConstantValue = new KaByteConstantValueImpl((Byte)value2, psi);
        } else if (Intrinsics.areEqual(object, ConstantValueKind.Int.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Int");
            kaConstantValue = new KaIntConstantValueImpl((Integer)value2, psi);
        } else if (Intrinsics.areEqual(object, ConstantValueKind.Long.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Long");
            kaConstantValue = new KaLongConstantValueImpl((Long)value2, psi);
        } else if (Intrinsics.areEqual(object, ConstantValueKind.Short.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Short");
            kaConstantValue = new KaShortConstantValueImpl((Short)value2, psi);
        } else if (Intrinsics.areEqual(object, ConstantValueKind.UnsignedByte.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.UByte");
            kaConstantValue = new KaUnsignedByteConstantValueImpl(((UByte)value2).unbox-impl(), psi, null);
        } else if (Intrinsics.areEqual(object, ConstantValueKind.UnsignedInt.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.UInt");
            kaConstantValue = new KaUnsignedIntConstantValueImpl(((UInt)value2).unbox-impl(), psi, null);
        } else if (Intrinsics.areEqual(object, ConstantValueKind.UnsignedLong.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.ULong");
            kaConstantValue = new KaUnsignedLongConstantValueImpl(((ULong)value2).unbox-impl(), psi, null);
        } else if (Intrinsics.areEqual(object, ConstantValueKind.UnsignedShort.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.UShort");
            kaConstantValue = new KaUnsignedShortConstantValueImpl(((UShort)value2).unbox-impl(), psi, null);
        } else if (Intrinsics.areEqual(object, ConstantValueKind.Double.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Double");
            kaConstantValue = new KaDoubleConstantValueImpl((Double)value2, psi);
        } else if (Intrinsics.areEqual(object, ConstantValueKind.Float.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Float");
            kaConstantValue = new KaFloatConstantValueImpl(((Float)value2).floatValue(), psi);
        } else if (Intrinsics.areEqual(object, ConstantValueKind.Boolean.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Boolean");
            kaConstantValue = new KaBooleanConstantValueImpl((Boolean)value2, psi);
        } else if (Intrinsics.areEqual(object, ConstantValueKind.Char.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Char");
            kaConstantValue = new KaCharConstantValueImpl(((Character)value2).charValue(), psi);
        } else if (Intrinsics.areEqual(object, ConstantValueKind.String.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.String");
            kaConstantValue = new KaStringConstantValueImpl((String)value2, psi);
        } else if (Intrinsics.areEqual(object, ConstantValueKind.Null.INSTANCE)) {
            kaConstantValue = new KaNullConstantValueImpl(psi);
        } else if (Intrinsics.areEqual(object, ConstantValueKind.IntegerLiteral.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Long");
            long l = (Long)value2;
            kaConstantValue = Integer.MIN_VALUE < l && l < Integer.MAX_VALUE ? (KaConstantValue)new KaIntConstantValueImpl((int)l, psi) : (KaConstantValue)new KaLongConstantValueImpl(l, psi);
        } else if (Intrinsics.areEqual(object, ConstantValueKind.UnsignedIntegerLiteral.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.ULong");
            long l = ((ULong)value2).unbox-impl();
            kaConstantValue = Long.compareUnsigned(ULong.constructor-impl(0L & 0xFFFFFFFFL), l) < 0 && Long.compareUnsigned(l, ULong.constructor-impl((long)-1 & 0xFFFFFFFFL)) < 0 ? (KaConstantValue)new KaUnsignedIntConstantValueImpl(UInt.constructor-impl((int)l), psi, null) : (KaConstantValue)new KaUnsignedLongConstantValueImpl(l, psi, null);
        } else {
            if (Intrinsics.areEqual(object, ConstantValueKind.Error.INSTANCE)) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("Should not be possible to get from FIR tree", null, fir, null, null, null, 58, null);
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
        return kaConstantValue;
    }

    private final FirLiteralExpression adaptToConstKind(FirLiteralExpression $this$adaptToConstKind) {
        ConstantValueKind constantValueKind = $this$adaptToConstKind.getKind();
        KtSourceElement ktSourceElement = $this$adaptToConstKind.getSource();
        Object object = this.convertToNumber($this$adaptToConstKind.getKind(), $this$adaptToConstKind.getValue());
        if (object == null) {
            object = $this$adaptToConstKind.getValue();
        }
        return this.toLiteralExpression(constantValueKind, ktSourceElement, object);
    }

    private final FirLiteralExpression evaluateStringConcatenationCall(FirStringConcatenationCall stringConcatenationCall) {
        StringBuilder stringBuilder;
        StringBuilder $this$evaluateStringConcatenationCall_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        FirCall $this$arguments$iv = stringConcatenationCall;
        boolean $i$f$getArguments = false;
        for (FirExpression arg : $this$arguments$iv.getArgumentList().getArguments()) {
            FirLiteralExpression evaluated;
            if (INSTANCE.evaluate(arg) == null) {
                return null;
            }
            $this$evaluateStringConcatenationCall_u24lambda_u243.append(String.valueOf(evaluated.getValue()));
        }
        String concatenated = stringBuilder.toString();
        return this.toLiteralExpression(ConstantValueKind.String.INSTANCE, stringConcatenationCall.getSource(), concatenated);
    }

    private final FirLiteralExpression evaluateFunctionCall(FirFunctionCall functionCall) {
        FirPureAbstractElement firPureAbstractElement = this.getOriginalFunction(functionCall);
        FirSimpleFunction firSimpleFunction = firPureAbstractElement instanceof FirSimpleFunction ? (FirSimpleFunction)firPureAbstractElement : null;
        if (firSimpleFunction == null) {
            return null;
        }
        FirSimpleFunction function2 = firSimpleFunction;
        FirLiteralExpression firLiteralExpression = this.evaluate(functionCall.getExplicitReceiver());
        if (firLiteralExpression == null) {
            return null;
        }
        FirLiteralExpression opr1 = firLiteralExpression;
        firPureAbstractElement = this.evaluate(opr1, functionCall, function2);
        if (firPureAbstractElement != null) {
            FirPureAbstractElement it = firPureAbstractElement;
            boolean bl = false;
            return INSTANCE.adjustType((FirLiteralExpression)it, FirTypeUtilsKt.getResolvedType(functionCall));
        }
        FirCall $this$arguments$iv = functionCall;
        boolean $i$f$getArguments = false;
        FirExpression firExpression = CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
        if (firExpression == null) {
            return null;
        }
        FirExpression argument = firExpression;
        FirLiteralExpression firLiteralExpression2 = this.evaluate(argument);
        if (firLiteralExpression2 == null) {
            return null;
        }
        FirLiteralExpression opr2 = firLiteralExpression2;
        FirLiteralExpression firLiteralExpression3 = this.evaluate(opr1, functionCall, function2, opr2);
        if (firLiteralExpression3 != null) {
            FirLiteralExpression it = firLiteralExpression3;
            boolean bl = false;
            return INSTANCE.adjustType(it, FirTypeUtilsKt.getResolvedType(functionCall));
        }
        return null;
    }

    private final FirLiteralExpression adjustType(FirLiteralExpression $this$adjustType, ConeKotlinType expectedType) {
        FirLiteralExpression expression;
        FirLiteralExpression firLiteralExpression;
        FirLiteralExpression firLiteralExpression2;
        ConstantValueKind expectedKind = this.toConstantValueKind(expectedType);
        if (expectedKind != null && !Intrinsics.areEqual(expectedKind, $this$adjustType.getKind()) && $this$adjustType.getValue() instanceof Number) {
            Object object = $this$adjustType.getValue();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Number");
            Object object2 = this.convertToNumber(expectedKind, (Number)object);
            Intrinsics.checkNotNull(object2);
            Object typeAdjustedValue = object2;
            firLiteralExpression2 = this.toLiteralExpression(expectedKind, $this$adjustType.getSource(), typeAdjustedValue);
        } else {
            firLiteralExpression2 = $this$adjustType;
        }
        FirLiteralExpression $this$adjustType_u24lambda_u246 = firLiteralExpression = (expression = firLiteralExpression2);
        boolean bl = false;
        $this$adjustType_u24lambda_u246.replaceConeTypeOrNull(expectedType);
        return firLiteralExpression;
    }

    private final CompileTimeType toCompileTimeType(ConstantValueKind $this$toCompileTimeType) {
        ConstantValueKind constantValueKind = $this$toCompileTimeType;
        return Intrinsics.areEqual(constantValueKind, ConstantValueKind.Byte.INSTANCE) ? CompileTimeType.BYTE : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Short.INSTANCE) ? CompileTimeType.SHORT : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Int.INSTANCE) ? CompileTimeType.INT : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Long.INSTANCE) ? CompileTimeType.LONG : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Double.INSTANCE) ? CompileTimeType.DOUBLE : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Float.INSTANCE) ? CompileTimeType.FLOAT : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Char.INSTANCE) ? CompileTimeType.CHAR : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Boolean.INSTANCE) ? CompileTimeType.BOOLEAN : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.String.INSTANCE) ? CompileTimeType.STRING : CompileTimeType.ANY))))))));
    }

    private final FirLiteralExpression evaluate(FirLiteralExpression $this$evaluate, FirFunctionCall firFunctionCall, FirSimpleFunction function2) {
        FirLiteralExpression firLiteralExpression;
        Object object;
        Object opr;
        if ($this$evaluate.getValue() == null) {
            return null;
        }
        Object object2 = $this$evaluate.getValue();
        String string2 = object2 instanceof String ? (String)object2 : null;
        if (string2 != null) {
            opr = string2;
            boolean bl = false;
            String string3 = function2.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
            object = OperationsMapGeneratedKt.evalUnaryOp(string3, INSTANCE.toCompileTimeType($this$evaluate.getKind()), opr);
            if (object != null) {
                Object it = object;
                boolean bl2 = false;
                return INSTANCE.toLiteralExpression(INSTANCE.toConstantValueKind(it), firFunctionCall.getSource(), it);
            }
        }
        Object object3 = this.convertToNumber($this$evaluate.getKind(), $this$evaluate.getValue());
        if (object3 != null) {
            opr = object3;
            boolean bl = false;
            String string4 = function2.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string4, "asString(...)");
            object = OperationsMapGeneratedKt.evalUnaryOp(string4, INSTANCE.toCompileTimeType($this$evaluate.getKind()), opr);
            if (object != null) {
                Object it = object;
                boolean bl3 = false;
                firLiteralExpression = INSTANCE.toLiteralExpression(INSTANCE.toConstantValueKind(it), firFunctionCall.getSource(), it);
            } else {
                firLiteralExpression = null;
            }
        } else {
            firLiteralExpression = null;
        }
        return firLiteralExpression;
    }

    private final FirLiteralExpression evaluateStringLength(FirLiteralExpression $this$evaluateStringLength) {
        FirLiteralExpression firLiteralExpression;
        Object object = $this$evaluateStringLength.getValue();
        String string2 = object instanceof String ? (String)object : null;
        if (string2 != null) {
            int it = string2.length();
            boolean bl = false;
            firLiteralExpression = INSTANCE.toLiteralExpression(INSTANCE.toConstantValueKind(it), $this$evaluateStringLength.getSource(), it);
        } else {
            firLiteralExpression = null;
        }
        return firLiteralExpression;
    }

    private final FirLiteralExpression evaluate(FirLiteralExpression $this$evaluate, FirFunctionCall firFunctionCall, FirSimpleFunction function2, FirLiteralExpression other) {
        FirLiteralExpression firLiteralExpression;
        Object object;
        Object opr2;
        Object opr1;
        if ($this$evaluate.getValue() == null || other.getValue() == null) {
            return null;
        }
        CompileTimeType rightType = this.isStringEquals(function2.getSymbol().getCallableId()) ? CompileTimeType.ANY : (this.isStringPlus(function2.getSymbol().getCallableId()) ? CompileTimeType.ANY : this.toCompileTimeType(other.getKind()));
        Object object2 = $this$evaluate.getValue();
        String string2 = object2 instanceof String ? (String)object2 : null;
        if (string2 != null) {
            opr1 = string2;
            boolean bl = false;
            Object object3 = other.getValue();
            if (object3 != null) {
                opr2 = object3;
                boolean bl2 = false;
                String string3 = function2.getName().asString();
                Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
                object = OperationsMapGeneratedKt.evalBinaryOp(string3, INSTANCE.toCompileTimeType($this$evaluate.getKind()), opr1, rightType, opr2);
                if (object != null) {
                    Object it = object;
                    boolean bl3 = false;
                    return INSTANCE.toLiteralExpression(INSTANCE.toConstantValueKind(it), firFunctionCall.getSource(), it);
                }
            }
        }
        Object object4 = this.convertToNumber($this$evaluate.getKind(), $this$evaluate.getValue());
        if (object4 != null) {
            opr1 = object4;
            boolean bl = false;
            Object object5 = INSTANCE.convertToNumber(other.getKind(), other.getValue());
            if (object5 != null) {
                opr2 = object5;
                boolean bl4 = false;
                String string4 = function2.getName().asString();
                Intrinsics.checkNotNullExpressionValue(string4, "asString(...)");
                object = OperationsMapGeneratedKt.evalBinaryOp(string4, INSTANCE.toCompileTimeType($this$evaluate.getKind()), opr1, INSTANCE.toCompileTimeType(other.getKind()), opr2);
                if (object != null) {
                    Object it = object;
                    boolean bl5 = false;
                    firLiteralExpression = INSTANCE.toLiteralExpression(INSTANCE.toConstantValueKind(it), firFunctionCall.getSource(), it);
                } else {
                    firLiteralExpression = null;
                }
            } else {
                firLiteralExpression = null;
            }
        } else {
            firLiteralExpression = null;
        }
        return firLiteralExpression;
    }

    private final boolean isStringEquals(CallableId $this$isStringEquals) {
        return Intrinsics.areEqual($this$isStringEquals.getClassId(), StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual($this$isStringEquals.getCallableName().getIdentifierOrNullIfSpecial(), "equals");
    }

    private final boolean isStringPlus(CallableId $this$isStringPlus) {
        return Intrinsics.areEqual($this$isStringPlus.getClassId(), StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual($this$isStringPlus.getCallableName().getIdentifierOrNullIfSpecial(), "plus");
    }

    private final ConstantValueKind toConstantValueKind(ConeKotlinType $this$toConstantValueKind) {
        Object object;
        ConeKotlinType coneKotlinType = $this$toConstantValueKind;
        if (coneKotlinType instanceof ConeErrorType) {
            object = null;
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            String string2 = ((ConeLookupTagBasedType)$this$toConstantValueKind).getLookupTag().getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            object = this.toConstantValueKind(string2);
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            object = this.toConstantValueKind(((ConeFlexibleType)$this$toConstantValueKind).getUpperBound());
        } else if (coneKotlinType instanceof ConeCapturedType) {
            object = ((ConeCapturedType)$this$toConstantValueKind).getLowerType();
            if (object == null || (object = this.toConstantValueKind((ConeKotlinType)object)) == null) {
                List<ConeKotlinType> list = ((ConeCapturedType)$this$toConstantValueKind).getConstructor().getSupertypes();
                Intrinsics.checkNotNull(list);
                object = this.toConstantValueKind(CollectionsKt.first(list));
            }
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            object = this.toConstantValueKind(((ConeDefinitelyNotNullType)$this$toConstantValueKind).getOriginal());
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            object = this.toConstantValueKind((ConeKotlinType)CollectionsKt.first((Iterable)((ConeIntersectionType)$this$toConstantValueKind).getIntersectedTypes()));
        } else if (coneKotlinType instanceof ConeStubType || coneKotlinType instanceof ConeIntegerLiteralType || coneKotlinType instanceof ConeTypeVariableType) {
            object = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final ConstantValueKind toConstantValueKind(String $this$toConstantValueKind) {
        ConstantValueKind constantValueKind;
        switch ($this$toConstantValueKind) {
            case "Byte": {
                constantValueKind = ConstantValueKind.Byte.INSTANCE;
                break;
            }
            case "Double": {
                constantValueKind = ConstantValueKind.Double.INSTANCE;
                break;
            }
            case "Float": {
                constantValueKind = ConstantValueKind.Float.INSTANCE;
                break;
            }
            case "Int": {
                constantValueKind = ConstantValueKind.Int.INSTANCE;
                break;
            }
            case "Long": {
                constantValueKind = ConstantValueKind.Long.INSTANCE;
                break;
            }
            case "Short": {
                constantValueKind = ConstantValueKind.Short.INSTANCE;
                break;
            }
            case "Char": {
                constantValueKind = ConstantValueKind.Char.INSTANCE;
                break;
            }
            case "String": {
                constantValueKind = ConstantValueKind.String.INSTANCE;
                break;
            }
            case "Boolean": {
                constantValueKind = ConstantValueKind.Boolean.INSTANCE;
                break;
            }
            default: {
                constantValueKind = null;
            }
        }
        return constantValueKind;
    }

    private final <T> ConstantValueKind toConstantValueKind(T $this$toConstantValueKind) {
        ConstantValueKind constantValueKind;
        T t = $this$toConstantValueKind;
        if (t instanceof Byte) {
            constantValueKind = ConstantValueKind.Byte.INSTANCE;
        } else if (t instanceof Double) {
            constantValueKind = ConstantValueKind.Double.INSTANCE;
        } else if (t instanceof Float) {
            constantValueKind = ConstantValueKind.Float.INSTANCE;
        } else if (t instanceof Integer) {
            constantValueKind = ConstantValueKind.Int.INSTANCE;
        } else if (t instanceof Long) {
            constantValueKind = ConstantValueKind.Long.INSTANCE;
        } else if (t instanceof Short) {
            constantValueKind = ConstantValueKind.Short.INSTANCE;
        } else if (t instanceof Character) {
            constantValueKind = ConstantValueKind.Char.INSTANCE;
        } else if (t instanceof String) {
            constantValueKind = ConstantValueKind.String.INSTANCE;
        } else if (t instanceof Boolean) {
            constantValueKind = ConstantValueKind.Boolean.INSTANCE;
        } else if (t == null) {
            constantValueKind = ConstantValueKind.Null.INSTANCE;
        } else {
            throw new IllegalStateException("Unknown constant value".toString());
        }
        return constantValueKind;
    }

    private final Object convertToNumber(ConstantValueKind $this$convertToNumber, Object value2) {
        Object object;
        if (value2 == null) {
            return null;
        }
        ConstantValueKind constantValueKind = $this$convertToNumber;
        return Intrinsics.areEqual(constantValueKind, ConstantValueKind.Boolean.INSTANCE) ? (Comparable<UInt>)((Boolean)value2) : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Char.INSTANCE) ? (Comparable)((Character)value2) : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.String.INSTANCE) ? (Comparable)((Object)((String)value2)) : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Byte.INSTANCE) ? (Comparable)Byte.valueOf(((Number)value2).byteValue()) : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Double.INSTANCE) ? (Comparable)Double.valueOf(((Number)value2).doubleValue()) : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Float.INSTANCE) ? (Comparable)Float.valueOf(((Number)value2).floatValue()) : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Int.INSTANCE) ? (Comparable)Integer.valueOf(((Number)value2).intValue()) : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Long.INSTANCE) ? (Comparable)Long.valueOf(((Number)value2).longValue()) : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Short.INSTANCE) ? (Comparable)Short.valueOf(((Number)value2).shortValue()) : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedByte.INSTANCE) ? UByte.box-impl(value2 instanceof UByte ? ((UByte)value2).unbox-impl() : UByte.constructor-impl((byte)((Number)value2).longValue())) : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedShort.INSTANCE) ? UShort.box-impl(value2 instanceof UShort ? ((UShort)value2).unbox-impl() : UShort.constructor-impl((short)((Number)value2).longValue())) : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedInt.INSTANCE) ? UInt.box-impl(value2 instanceof UInt ? ((UInt)value2).unbox-impl() : UInt.constructor-impl((int)((Number)value2).longValue())) : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedLong.INSTANCE) ? ULong.box-impl(value2 instanceof ULong ? ((ULong)value2).unbox-impl() : ULong.constructor-impl(((Number)value2).longValue())) : (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedIntegerLiteral.INSTANCE) ? ULong.box-impl((object = value2) instanceof UInt ? ULong.constructor-impl((long)((UInt)value2).unbox-impl() & 0xFFFFFFFFL) : (object instanceof ULong ? ((ULong)value2).unbox-impl() : ULong.constructor-impl(((Number)value2).longValue()))) : null)))))))))))));
    }

    private final FirLiteralExpression toLiteralExpression(ConstantValueKind $this$toLiteralExpression, KtSourceElement source, Object value2) {
        return FirConstExpressionBuilderKt.buildLiteralExpression$default(source, $this$toLiteralExpression, value2, null, false, null, 40, null);
    }

    private final FirCallableDeclaration getOriginalFunction(FirFunctionCall $this$getOriginalFunction) {
        FirBasedSymbol<?> symbol;
        FirNamedReference reference = $this$getOriginalFunction.getCalleeReference();
        FirBasedSymbol<?> firBasedSymbol = symbol = reference instanceof FirResolvedNamedReference ? ((FirResolvedNamedReference)reference).getResolvedSymbol() : null;
        Object obj = firBasedSymbol != null ? firBasedSymbol.getFir() : null;
        return obj instanceof FirCallableDeclaration ? (FirCallableDeclaration)obj : null;
    }

    private static final Set variablesInProcessOfEvaluation$lambda$0() {
        return new LinkedHashSet();
    }
}

