/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.references;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.references.FirReferenceResolveHelper;
import org.jetbrains.kotlin.analysis.api.fir.references.KaFirReference;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KaFirNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KaFirSyntheticJavaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.impl.base.references.KaBaseSimpleNameReference;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KaDeclarationContainerSymbol;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirLoopJump;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0019\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u0013H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\n2\u0006\u0010\u0016\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0017H\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001cJ\u0011\u0010\u001f\u001a\u0004\u0018\u00010\u000fH\u0017\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010!\u001a\u0004\b\u0006\u0010\"R\u0014\u0010#\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\""}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/references/KaFirSimpleNameReference;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/references/KaBaseSimpleNameReference;", "Lorg/jetbrains/kotlin/analysis/api/fir/references/KaFirReference;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "expression", "", "isRead", "<init>", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Z)V", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "resultsToFix", "fixUpAnnotationCallResolveToCtor", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Ljava/util/Collection;)Ljava/util/Collection;", "Lorg/jetbrains/kotlin/psi/KtImportAlias;", "alias", "isReferenceToImportAlias", "(Lorg/jetbrains/kotlin/psi/KtImportAlias;)Z", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "computeSymbols", "(Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;)Ljava/util/Collection;", "analysisSession", "Lcom/intellij/psi/PsiElement;", "getResolvedToPsi", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)Ljava/util/Collection;", "candidateTarget", "canBeReferenceTo", "(Lcom/intellij/psi/PsiElement;)Z", "element", "isReferenceToViaExtension", "getImportAlias", "()Lorg/jetbrains/kotlin/psi/KtImportAlias;", "Z", "()Z", "isAnnotationCall"})
public final class KaFirSimpleNameReference
extends KaBaseSimpleNameReference
implements KaFirReference {
    private final boolean isRead;

    public KaFirSimpleNameReference(@NotNull KtSimpleNameExpression expression, boolean isRead) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        super(expression);
        this.isRead = isRead;
    }

    public final boolean isRead() {
        return this.isRead;
    }

    private final boolean isAnnotationCall() {
        PsiElement psiElement = ((KtSimpleNameExpression)this.getExpression()).getParent();
        KtUserType ktUserType = psiElement instanceof KtUserType ? (KtUserType)psiElement : null;
        if (ktUserType == null) {
            return false;
        }
        KtUserType ktUserType2 = ktUserType;
        PsiElement psiElement2 = ktUserType2.getParent();
        KtTypeReference ktTypeReference = psiElement2 instanceof KtTypeReference ? (KtTypeReference)psiElement2 : null;
        if (ktTypeReference == null) {
            return false;
        }
        KtTypeReference ktTypeReference2 = ktTypeReference;
        PsiElement psiElement3 = ktTypeReference2.getParent();
        KtConstructorCalleeExpression ktConstructorCalleeExpression = psiElement3 instanceof KtConstructorCalleeExpression ? (KtConstructorCalleeExpression)psiElement3 : null;
        if (ktConstructorCalleeExpression == null) {
            return false;
        }
        KtConstructorCalleeExpression ktConstructorCalleeExpression2 = ktConstructorCalleeExpression;
        return ktConstructorCalleeExpression2.getParent() instanceof KtAnnotationEntry;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KaSymbol> fixUpAnnotationCallResolveToCtor(KaSession $this$fixUpAnnotationCallResolveToCtor, Collection<? extends KaSymbol> resultsToFix) {
        void $this$mapTo$iv$iv;
        if (resultsToFix.isEmpty() || !this.isAnnotationCall()) {
            return resultsToFix;
        }
        Iterable $this$map$iv = resultsToFix;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KaSymbol kaSymbol;
            void targetSymbol;
            KaSymbol kaSymbol2 = (KaSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (targetSymbol instanceof KaFirNamedClassSymbol && ((KaFirNamedClassSymbol)targetSymbol).getClassKind() == KaClassKind.ANNOTATION_CLASS) {
                KaConstructorSymbol kaConstructorSymbol = SequencesKt.firstOrNull($this$fixUpAnnotationCallResolveToCtor.getMemberScope((KaDeclarationContainerSymbol)targetSymbol).getConstructors());
                kaSymbol = (KaSymbol)(kaConstructorSymbol != null ? (KaLifetimeOwner)kaConstructorSymbol : (KaLifetimeOwner)targetSymbol);
            } else {
                kaSymbol = targetSymbol;
            }
            collection.add(kaSymbol);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean isReferenceToImportAlias(@NotNull KtImportAlias alias) {
        Intrinsics.checkNotNullParameter(alias, "alias");
        return KaFirReference.super.isReferenceToImportAlias(alias);
    }

    @Override
    @NotNull
    public Collection<KaSymbol> computeSymbols(@NotNull KaFirSession $this$computeSymbols) {
        Intrinsics.checkNotNullParameter($this$computeSymbols, "<this>");
        Collection<KaSymbol> results = FirReferenceResolveHelper.INSTANCE.resolveSimpleNameReference$analysis_api_fir(this, $this$computeSymbols);
        return this.fixUpAnnotationCallResolveToCtor($this$computeSymbols, results);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<PsiElement> getResolvedToPsi(@NotNull KaSession analysisSession) {
        void $this$flatMapTo$iv$iv;
        FirElement fir;
        Intrinsics.checkNotNullParameter(analysisSession, "analysisSession");
        KaSession $this$getResolvedToPsi_u24lambda_u242 = analysisSession;
        boolean bl = false;
        if (this.getExpression() instanceof KtLabelReferenceExpression && (fir = LowLevelFirApiFacadeKt.getOrBuildFir(this.getExpression(), ((KaFirSession)analysisSession).getFirResolveSession())) instanceof FirLoopJump) {
            return CollectionsKt.listOfNotNull(UtilsKt.getPsi(((FirLoopJump)fir).getTarget().getLabeledElement()));
        }
        Collection<KaSymbol> referenceTargetSymbols = this.resolveToSymbols($this$getResolvedToPsi_u24lambda_u242);
        Collection<PsiElement> psiOfReferenceTarget = KaFirReference.super.getResolvedToPsi(analysisSession, referenceTargetSymbols);
        if (!psiOfReferenceTarget.isEmpty()) {
            return psiOfReferenceTarget;
        }
        Iterable $this$flatMap$iv = referenceTargetSymbols;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<PsiElement> list;
            KaSymbol symbol = (KaSymbol)element$iv$iv;
            boolean bl2 = false;
            if (symbol instanceof KaFirSyntheticJavaPropertySymbol) {
                if (this.isRead) {
                    list = CollectionsKt.listOfNotNull(((KaFirSyntheticJavaPropertySymbol)symbol).getJavaGetterSymbol().getPsi());
                } else if (((KaFirSyntheticJavaPropertySymbol)symbol).getJavaSetterSymbol() == null) {
                    list = CollectionsKt.listOfNotNull(((KaFirSyntheticJavaPropertySymbol)symbol).getJavaGetterSymbol().getPsi());
                } else {
                    KaNamedFunctionSymbol kaNamedFunctionSymbol = ((KaFirSyntheticJavaPropertySymbol)symbol).getJavaSetterSymbol();
                    list = CollectionsKt.listOfNotNull(kaNamedFunctionSymbol != null ? kaNamedFunctionSymbol.getPsi() : null);
                }
            } else {
                list = CollectionsKt.listOfNotNull(symbol.getPsi());
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    protected boolean canBeReferenceTo(@NotNull PsiElement candidateTarget) {
        Intrinsics.checkNotNullParameter(candidateTarget, "candidateTarget");
        return true;
    }

    @Override
    public boolean isReferenceToViaExtension(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return false;
    }

    @Override
    @Nullable
    public KtImportAlias getImportAlias() {
        String name = ((KtSimpleNameExpression)this.getElement()).getReferencedName();
        KtFile ktFile = ((KtSimpleNameExpression)this.getElement()).getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue(ktFile, "getContainingKtFile(...)");
        KtFile file2 = ktFile;
        return this.getImportAlias(file2.findImportByAlias(name));
    }
}

