/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.scopes;

import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001b\u0010\b\u001a\u00020\u00072\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005H$\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0017\u00a2\u0006\u0004\b\f\u0010\rJ+\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J/\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000b2\u0016\u0010\u0012\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0015\u0012\u0004\u0012\u00020\u00110\u000fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0014J!\u0010\u001b\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H'\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010\u001dR!\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010\r"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/scopes/FirCallableFilteringScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "baseScope", "<init>", "(Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "callable", "", "isTargetCallable", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "", "Lorg/jetbrains/kotlin/name/Name;", "getCallableNames", "()Ljava/util/Set;", "name", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "", "processor", "processFunctionsByName", "(Lorg/jetbrains/kotlin/name/Name;Lkotlin/jvm/functions/Function1;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "processPropertiesByName", "Lorg/jetbrains/kotlin/fir/FirSession;", "newSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "newScopeSession", "withReplacedSessionOrNull", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)Lorg/jetbrains/kotlin/analysis/api/fir/scopes/FirCallableFilteringScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "cachedCallableNames$delegate", "Lkotlin/Lazy;", "getCachedCallableNames", "cachedCallableNames"})
public abstract class FirCallableFilteringScope
extends FirContainingNamesAwareScope {
    @NotNull
    private final FirContainingNamesAwareScope baseScope;
    @NotNull
    private final Lazy cachedCallableNames$delegate;

    public FirCallableFilteringScope(@NotNull FirContainingNamesAwareScope baseScope) {
        Intrinsics.checkNotNullParameter(baseScope, "baseScope");
        this.baseScope = baseScope;
        this.cachedCallableNames$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> FirCallableFilteringScope.cachedCallableNames_delegate$lambda$2(this));
    }

    protected abstract boolean isTargetCallable(@NotNull FirCallableSymbol<?> var1);

    private final Set<Name> getCachedCallableNames() {
        Lazy lazy = this.cachedCallableNames$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public Set<Name> getCallableNames() {
        return this.getCachedCallableNames();
    }

    @Override
    public void processFunctionsByName(@NotNull Name name, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        if (!this.getCachedCallableNames().contains(name)) {
            return;
        }
        this.baseScope.processFunctionsByName(name, arg_0 -> FirCallableFilteringScope.processFunctionsByName$lambda$3(this, processor, arg_0));
    }

    @Override
    public void processPropertiesByName(@NotNull Name name, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        if (!this.getCachedCallableNames().contains(name)) {
            return;
        }
        this.baseScope.processPropertiesByName(name, arg_0 -> FirCallableFilteringScope.processPropertiesByName$lambda$4(this, processor, arg_0));
    }

    @Override
    @Nullable
    public abstract FirCallableFilteringScope withReplacedSessionOrNull(@NotNull FirSession var1, @NotNull ScopeSession var2);

    private static final Unit cachedCallableNames_delegate$lambda$2$lambda$1$lambda$0(FirCallableFilteringScope this$0, Set $this_buildSet, FirCallableSymbol callable) {
        Intrinsics.checkNotNullParameter(callable, "callable");
        if (this$0.isTargetCallable(callable)) {
            $this_buildSet.add(callable.getName());
        }
        return Unit.INSTANCE;
    }

    private static final Set cachedCallableNames_delegate$lambda$2(FirCallableFilteringScope this$0) {
        Set set;
        Set $this$cachedCallableNames_delegate_u24lambda_u242_u24lambda_u241 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        FirContainingNamesAwareScopeKt.processAllCallables(this$0.baseScope, arg_0 -> FirCallableFilteringScope.cachedCallableNames_delegate$lambda$2$lambda$1$lambda$0(this$0, $this$cachedCallableNames_delegate_u24lambda_u242_u24lambda_u241, arg_0));
        return SetsKt.build(set);
    }

    private static final Unit processFunctionsByName$lambda$3(FirCallableFilteringScope this$0, Function1 $processor, FirNamedFunctionSymbol function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        if (this$0.isTargetCallable(function2)) {
            $processor.invoke(function2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit processPropertiesByName$lambda$4(FirCallableFilteringScope this$0, Function1 $processor, FirVariableSymbol property) {
        Intrinsics.checkNotNullParameter(property, "property");
        if (this$0.isTargetCallable(property)) {
            $processor.invoke(property);
        }
        return Unit.INSTANCE;
    }
}

