/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.packages.KotlinPackageProviderFactoryKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0000H\u0017\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/symbols/KtPackage;", "Lcom/intellij/psi/impl/file/PsiPackageImpl;", "Lcom/intellij/psi/PsiManager;", "manager", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "Lcom/intellij/psi/search/GlobalSearchScope;", "scope", "<init>", "(Lcom/intellij/psi/PsiManager;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/search/GlobalSearchScope;)V", "copy", "()Lorg/jetbrains/kotlin/analysis/api/fir/symbols/KtPackage;", "", "isValid", "()Z", "Lorg/jetbrains/kotlin/name/FqName;", "Lcom/intellij/psi/search/GlobalSearchScope;"})
final class KtPackage
extends PsiPackageImpl {
    @NotNull
    private final FqName fqName;
    @NotNull
    private final GlobalSearchScope scope;

    public KtPackage(@NotNull PsiManager manager, @NotNull FqName fqName2, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(manager, "manager");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        super(manager, StringsKt.replace$default(fqName2.asString(), '/', '.', false, 4, null));
        this.fqName = fqName2;
        this.scope = scope2;
    }

    @Override
    @NotNull
    public KtPackage copy() {
        PsiManager psiManager = this.getManager();
        Intrinsics.checkNotNullExpressionValue(psiManager, "getManager(...)");
        return new KtPackage(psiManager, this.fqName, this.scope);
    }

    @Override
    public boolean isValid() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
        return KotlinPackageProviderFactoryKt.createPackageProvider(project, this.scope).doesKotlinOnlyPackageExist(this.fqName);
    }
}

