/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.symbols.pointers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.impl.base.symbols.pointers.KaBaseCachedSymbolPointer;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.pointers.KaSymbolPointer;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B'\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\u000bH\u0015\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0013\u001a\u00020\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0015R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/KaFirClassLikeSymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol;", "T", "Lorg/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBaseCachedSymbolPointer;", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lkotlin/reflect/KClass;", "expectedClass", "originalSymbol", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;Lkotlin/reflect/KClass;Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol;)V", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "analysisSession", "restoreIfNotCached", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol;", "Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "other", "", "pointsToTheSameSymbolAs", "(Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer;)Z", "Lorg/jetbrains/kotlin/name/ClassId;", "Lkotlin/reflect/KClass;"})
public final class KaFirClassLikeSymbolPointer<T extends KaClassLikeSymbol>
extends KaBaseCachedSymbolPointer<T> {
    @NotNull
    private final ClassId classId;
    @NotNull
    private final KClass<T> expectedClass;

    public KaFirClassLikeSymbolPointer(@NotNull ClassId classId, @NotNull KClass<T> expectedClass, @Nullable T originalSymbol) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(expectedClass, "expectedClass");
        super((KaSymbol)originalSymbol);
        this.classId = classId;
        this.expectedClass = expectedClass;
    }

    @Override
    @Nullable
    protected T restoreIfNotCached(@NotNull KaSession analysisSession) {
        Intrinsics.checkNotNullParameter(analysisSession, "analysisSession");
        if (!(analysisSession instanceof KaFirSession)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        KaClassLikeSymbol kaClassLikeSymbol = ((KaFirSession)analysisSession).getFirSymbolBuilder$analysis_api_fir().getClassifierBuilder().buildClassLikeSymbolByClassId(this.classId);
        if (kaClassLikeSymbol == null) {
            return null;
        }
        KaClassLikeSymbol classLikeSymbol = kaClassLikeSymbol;
        if (!this.expectedClass.isInstance(classLikeSymbol)) {
            return null;
        }
        return (T)classLikeSymbol;
    }

    @Override
    public boolean pointsToTheSameSymbolAs(@NotNull KaSymbolPointer<? extends KaSymbol> other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return other == this || other instanceof KaFirClassLikeSymbolPointer && Intrinsics.areEqual(((KaFirClassLikeSymbolPointer)other).classId, this.classId) && Intrinsics.areEqual(((KaFirClassLikeSymbolPointer)other).expectedClass, this.expectedClass);
    }
}

