/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.symbols.pointers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.symbols.pointers.KaFirTopLevelCallableSymbolPointerKt;
import org.jetbrains.kotlin.analysis.api.impl.base.symbols.pointers.KaBaseCachedSymbolPointer;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.pointers.KaSymbolPointer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.name.CallableId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b \u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0019\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\tH\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0013\u001a\u0004\u0018\u00018\u0000*\u00020\r2\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\u0011H%\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0019\u001a\u00020\u00182\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H&\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001b\u0010\u001b\u001a\u00020\u00182\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0004\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/KaTopLevelCallableSymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "S", "Lorg/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBaseCachedSymbolPointer;", "Lorg/jetbrains/kotlin/name/CallableId;", "callableId", "originalSymbol", "<init>", "(Lorg/jetbrains/kotlin/name/CallableId;Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;)V", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "analysisSession", "restoreIfNotCached", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "candidates", "Lorg/jetbrains/kotlin/fir/FirSession;", "firSession", "chooseCandidateAndCreateSymbol", "(Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;Ljava/util/Collection;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "other", "", "pointsToTheSameSymbolAs", "(Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer;)Z", "hasTheSameOwner", "(Lorg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/KaTopLevelCallableSymbolPointer;)Z", "Lorg/jetbrains/kotlin/name/CallableId;"})
public abstract class KaTopLevelCallableSymbolPointer<S extends KaCallableSymbol>
extends KaBaseCachedSymbolPointer<S> {
    @NotNull
    private final CallableId callableId;

    public KaTopLevelCallableSymbolPointer(@NotNull CallableId callableId, @Nullable S originalSymbol) {
        Intrinsics.checkNotNullParameter(callableId, "callableId");
        super((KaSymbol)originalSymbol);
        this.callableId = callableId;
    }

    @Override
    @Nullable
    protected final S restoreIfNotCached(@NotNull KaSession analysisSession) {
        Intrinsics.checkNotNullParameter(analysisSession, "analysisSession");
        if (!(analysisSession instanceof KaFirSession)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        List candidates = KaFirTopLevelCallableSymbolPointerKt.access$getCallableSymbols((KaFirSession)analysisSession, this.callableId);
        if (candidates.isEmpty()) {
            return null;
        }
        FirSession session = ((FirCallableDeclaration)((FirCallableSymbol)CollectionsKt.first(candidates)).getFir()).getModuleData().getSession();
        return this.chooseCandidateAndCreateSymbol((KaFirSession)analysisSession, candidates, session);
    }

    @Nullable
    protected abstract S chooseCandidateAndCreateSymbol(@NotNull KaFirSession var1, @NotNull Collection<? extends FirCallableSymbol<?>> var2, @NotNull FirSession var3);

    @Override
    public abstract boolean pointsToTheSameSymbolAs(@NotNull KaSymbolPointer<? extends KaSymbol> var1);

    protected final boolean hasTheSameOwner(@NotNull KaTopLevelCallableSymbolPointer<?> other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Intrinsics.areEqual(other.callableId, this.callableId);
    }
}

