/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.KaSymbolByFirBuilder;
import org.jetbrains.kotlin.analysis.api.fir.types.KaFirClassErrorType;
import org.jetbrains.kotlin.analysis.api.fir.utils.ConeDiagnosticPointer;
import org.jetbrains.kotlin.analysis.api.fir.utils.ConeTypePointer;
import org.jetbrains.kotlin.analysis.api.fir.utils.ConeTypePointerKt;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInaccessibleLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInvalidLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaClassErrorType;
import org.jetbrains.kotlin.analysis.api.types.KaTypePointer;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedSymbolError;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0017\u00a2\u0006\u0004\b\r\u0010\u000eR\u0018\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u00128\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/types/KaFirClassErrorTypePointer;", "Lorg/jetbrains/kotlin/analysis/api/types/KaTypePointer;", "Lorg/jetbrains/kotlin/analysis/api/types/KaClassErrorType;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "coneType", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "coneDiagnostic", "Lorg/jetbrains/kotlin/analysis/api/fir/KaSymbolByFirBuilder;", "builder", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;Lorg/jetbrains/kotlin/analysis/api/fir/KaSymbolByFirBuilder;)V", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "session", "restore", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)Lorg/jetbrains/kotlin/analysis/api/types/KaClassErrorType;", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypePointer;", "coneTypePointer", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypePointer;", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeDiagnosticPointer;", "coneDiagnosticPointer", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeDiagnosticPointer;", "getConeDiagnosticPointer", "()Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeDiagnosticPointer;"})
final class KaFirClassErrorTypePointer
implements KaTypePointer<KaClassErrorType> {
    @NotNull
    private final ConeTypePointer<?> coneTypePointer;
    @NotNull
    private final ConeDiagnosticPointer coneDiagnosticPointer;

    public KaFirClassErrorTypePointer(@NotNull ConeClassLikeType coneType, @NotNull ConeDiagnostic coneDiagnostic, @NotNull KaSymbolByFirBuilder builder2) {
        ConeTypePointer<ConeKotlinType> coneTypePointer;
        Intrinsics.checkNotNullParameter(coneType, "coneType");
        Intrinsics.checkNotNullParameter(coneDiagnostic, "coneDiagnostic");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        if (!(coneType instanceof ConeErrorType)) {
            KaClassLikeSymbol classSymbol = builder2.getClassifierBuilder().buildClassLikeSymbolByLookupTag(coneType.getLookupTag());
            if (classSymbol != null) {
                coneTypePointer = ConeTypePointerKt.createPointer((ConeKotlinType)coneType, builder2);
            } else {
                ConeErrorType coneErrorType = new ConeErrorType(new ConeUnresolvedSymbolError(coneType.getLookupTag().getClassId()), false, null, coneType.getTypeArguments(), coneType.getAttributes());
                coneTypePointer = ConeTypePointerKt.createPointer((ConeKotlinType)coneErrorType, builder2);
            }
        } else {
            coneTypePointer = ConeTypePointerKt.createPointer((ConeKotlinType)coneType, builder2);
        }
        this.coneTypePointer = coneTypePointer;
        this.coneDiagnosticPointer = ConeDiagnosticPointer.Companion.create(coneDiagnostic, builder2);
    }

    @NotNull
    public final ConeDiagnosticPointer getConeDiagnosticPointer() {
        return this.coneDiagnosticPointer;
    }

    @Override
    @Nullable
    public KaClassErrorType restore(@NotNull KaSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        KaLifetimeOwner $this$withValidityAssertion$iv = session;
        boolean $i$f$withValidityAssertion = false;
        KaLifetimeOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KaLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        KaLifetimeToken $this$assertIsValid$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsValid = false;
        if (!$this$assertIsValid$iv$iv$iv$iv.isValid()) {
            throw new KaInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValid$iv$iv$iv$iv + ": " + $this$assertIsValid$iv$iv$iv$iv.getInvalidationReason());
        }
        KaLifetimeToken $this$assertIsAccessible$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsAccessible = false;
        if (!$this$assertIsAccessible$iv$iv$iv$iv.isAccessible()) {
            throw new KaInaccessibleLifetimeOwnerAccessException($this$assertIsAccessible$iv$iv$iv$iv + " is inaccessible: " + $this$assertIsAccessible$iv$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        boolean $i$f$requireIsInstance = false;
        if (!(session instanceof KaFirSession)) {
            boolean $i$a$-require-ChecksKt$requireIsInstance$1$iv22 = false;
            String $i$a$-require-ChecksKt$requireIsInstance$1$iv22 = "Expected " + Reflection.getOrCreateKotlinClass(KaFirSession.class) + " instead of " + Reflection.getOrCreateKotlinClass(session.getClass()) + " for " + session;
            throw new IllegalArgumentException($i$a$-require-ChecksKt$requireIsInstance$1$iv22.toString());
        }
        Object obj = this.coneTypePointer.restore((KaFirSession)session);
        ConeClassLikeType coneClassLikeType = obj instanceof ConeClassLikeType ? (ConeClassLikeType)obj : null;
        if (coneClassLikeType == null) {
            return null;
        }
        ConeClassLikeType coneType = coneClassLikeType;
        ConeDiagnostic coneDiagnostic = this.coneDiagnosticPointer.restore((KaFirSession)session);
        if (coneDiagnostic == null) {
            return null;
        }
        ConeDiagnostic coneDiagnostic2 = coneDiagnostic;
        return new KaFirClassErrorType(coneType, coneDiagnostic2, ((KaFirSession)session).getFirSymbolBuilder$analysis_api_fir());
    }
}

