/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeApproximator;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/types/PublicTypeApproximator;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "", "approximateLocalTypes", "approximateTypeToPublicDenotable", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/FirSession;Z)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "PublicApproximatorConfiguration"})
public final class PublicTypeApproximator {
    @NotNull
    public static final PublicTypeApproximator INSTANCE = new PublicTypeApproximator();

    private PublicTypeApproximator() {
    }

    @Nullable
    public final ConeKotlinType approximateTypeToPublicDenotable(@NotNull ConeKotlinType type2, @NotNull FirSession session, boolean approximateLocalTypes) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(session, "session");
        ConeTypeApproximator approximator = TypeComponentsKt.getTypeApproximator(session);
        return approximator.approximateToSuperType(type2, (TypeApproximatorConfiguration)new PublicApproximatorConfiguration(approximateLocalTypes));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u0014\u0010\f\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0014\u0010\u000e\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\bR\u0014\u0010\u0010\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0014\u0010\u0012\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u0014\u0010\u0014\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/types/PublicTypeApproximator$PublicApproximatorConfiguration;", "Lorg/jetbrains/kotlin/types/TypeApproximatorConfiguration$AllFlexibleSameValue;", "", "approximateLocalTypes", "<init>", "(Z)V", "Z", "getApproximateLocalTypes", "()Z", "getApproximateAllFlexible", "approximateAllFlexible", "getApproximateErrorTypes", "approximateErrorTypes", "getApproximateDefinitelyNotNullTypes", "approximateDefinitelyNotNullTypes", "getApproximateIntegerLiteralConstantTypes", "approximateIntegerLiteralConstantTypes", "getApproximateIntersectionTypesInContravariantPositions", "approximateIntersectionTypesInContravariantPositions", "getApproximateAnonymous", "approximateAnonymous"})
    public static final class PublicApproximatorConfiguration
    extends TypeApproximatorConfiguration.AllFlexibleSameValue {
        private final boolean approximateLocalTypes;

        public PublicApproximatorConfiguration(boolean approximateLocalTypes) {
            this.approximateLocalTypes = approximateLocalTypes;
        }

        @Override
        public boolean getApproximateLocalTypes() {
            return this.approximateLocalTypes;
        }

        @Override
        public boolean getApproximateAllFlexible() {
            return true;
        }

        @Override
        public boolean getApproximateErrorTypes() {
            return false;
        }

        @Override
        public boolean getApproximateDefinitelyNotNullTypes() {
            return true;
        }

        @Override
        public boolean getApproximateIntegerLiteralConstantTypes() {
            return true;
        }

        @Override
        public boolean getApproximateIntersectionTypesInContravariantPositions() {
            return true;
        }

        @Override
        public boolean getApproximateAnonymous() {
            return true;
        }
    }
}

