/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.KaSymbolByFirBuilder;
import org.jetbrains.kotlin.analysis.api.fir.utils.ConeTypePointer;
import org.jetbrains.kotlin.analysis.api.fir.utils.ConeTypePointerKt;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\"\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH'\u00a2\u0006\u0004\b\u000b\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/utils/AbstractConeFlexibleTypePointer;", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "T", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypePointer;", "coneType", "Lorg/jetbrains/kotlin/analysis/api/fir/KaSymbolByFirBuilder;", "builder", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;Lorg/jetbrains/kotlin/analysis/api/fir/KaSymbolByFirBuilder;)V", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "session", "restore", "(Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;)Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "Lorg/jetbrains/kotlin/fir/types/ConeRigidType;", "lowerBound", "upperBound", "(Lorg/jetbrains/kotlin/fir/types/ConeRigidType;Lorg/jetbrains/kotlin/fir/types/ConeRigidType;)Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "lowerBoundPointer", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypePointer;", "upperBoundPointer"})
abstract class AbstractConeFlexibleTypePointer<T extends ConeFlexibleType>
implements ConeTypePointer<T> {
    @NotNull
    private final ConeTypePointer<ConeRigidType> lowerBoundPointer;
    @NotNull
    private final ConeTypePointer<ConeRigidType> upperBoundPointer;

    public AbstractConeFlexibleTypePointer(@NotNull ConeFlexibleType coneType, @NotNull KaSymbolByFirBuilder builder2) {
        Intrinsics.checkNotNullParameter(coneType, "coneType");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        this.lowerBoundPointer = ConeTypePointerKt.createPointer((ConeKotlinType)coneType.getLowerBound(), builder2);
        this.upperBoundPointer = ConeTypePointerKt.createPointer((ConeKotlinType)coneType.getUpperBound(), builder2);
    }

    @Override
    @Nullable
    public T restore(@NotNull KaFirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        ConeRigidType coneRigidType = this.lowerBoundPointer.restore(session);
        if (coneRigidType == null) {
            return null;
        }
        ConeRigidType lowerBound = coneRigidType;
        ConeRigidType coneRigidType2 = this.upperBoundPointer.restore(session);
        if (coneRigidType2 == null) {
            return null;
        }
        ConeRigidType upperBound = coneRigidType2;
        return this.restore(lowerBound, upperBound);
    }

    @NotNull
    public abstract T restore(@NotNull ConeRigidType var1, @NotNull ConeRigidType var2);
}

