/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.utils;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaConstantInitializerValue;
import org.jetbrains.kotlin.analysis.api.KaConstantValueForAnnotation;
import org.jetbrains.kotlin.analysis.api.KaInitializerValue;
import org.jetbrains.kotlin.analysis.api.KaNonConstantInitializerValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotationValue;
import org.jetbrains.kotlin.analysis.api.base.KaConstantValue;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.KaSymbolByFirBuilder;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirAnnotationValueConverter;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirCompileTimeConstantEvaluator;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0013\u0010\u0001\u001a\u00020\u0000*\u00020\u0000H\u0001\u00a2\u0006\u0004\b\u0001\u0010\u0002\u001a\u0013\u0010\u0001\u001a\u00020\u0003*\u00020\u0003H\u0001\u00a2\u0006\u0004\b\u0001\u0010\u0004\u001a\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\u0005H\u0001\u00a2\u0006\u0004\b\u0007\u0010\b\u001a#\u0010\u000f\u001a\u00020\u000e*\u00020\t2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a7\u0010\u001a\u001a\u00020\u0018*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b"}, d2={"Lcom/intellij/psi/PsiElement;", "unwrap", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/name/FqName;", "computeImportableName", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/analysis/api/fir/KaSymbolByFirBuilder;", "builder", "", "forAnnotationDefaultValue", "Lorg/jetbrains/kotlin/analysis/api/KaInitializerValue;", "asKaInitializerValue", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/analysis/api/fir/KaSymbolByFirBuilder;Z)Lorg/jetbrains/kotlin/analysis/api/KaInitializerValue;", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "analysisSession", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "", "processor", "processEqualsFunctions", "(Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;Lkotlin/jvm/functions/Function1;)V"})
public final class FirUtilsKt {
    @NotNull
    public static final PsiElement unwrap(@NotNull PsiElement $this$unwrap) {
        Intrinsics.checkNotNullParameter($this$unwrap, "<this>");
        return $this$unwrap instanceof KtExpression ? (PsiElement)FirUtilsKt.unwrap((KtExpression)$this$unwrap) : $this$unwrap;
    }

    @NotNull
    public static final KtExpression unwrap(@NotNull KtExpression $this$unwrap) {
        KtExpression ktExpression;
        KtExpression ktExpression2;
        Intrinsics.checkNotNullParameter($this$unwrap, "<this>");
        KtExpression ktExpression3 = $this$unwrap;
        if (ktExpression3 instanceof KtLabeledExpression) {
            KtExpression ktExpression4 = ((KtLabeledExpression)$this$unwrap).getBaseExpression();
            ktExpression2 = ktExpression4 != null ? FirUtilsKt.unwrap(ktExpression4) : null;
        } else if (ktExpression3 instanceof KtAnnotatedExpression) {
            KtExpression ktExpression5 = ((KtAnnotatedExpression)$this$unwrap).getBaseExpression();
            ktExpression2 = ktExpression5 != null ? FirUtilsKt.unwrap(ktExpression5) : null;
        } else if (ktExpression3 instanceof KtFunctionLiteral) {
            PsiElement psiElement = ((KtFunctionLiteral)$this$unwrap).getParent();
            KtLambdaExpression ktLambdaExpression = psiElement instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement : null;
            ktExpression2 = ktLambdaExpression != null ? FirUtilsKt.unwrap(ktLambdaExpression) : null;
        } else {
            ktExpression2 = ktExpression = $this$unwrap;
        }
        if (ktExpression2 == null) {
            ktExpression = $this$unwrap;
        }
        return ktExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final FqName computeImportableName(@NotNull FirCallableSymbol<?> $this$computeImportableName) {
        block9: {
            FirClassLikeSymbol<?> containingClass;
            block10: {
                boolean $i$f$isStatic;
                FirCallableSymbol<?> $this$isStatic$iv;
                block8: {
                    Intrinsics.checkNotNullParameter($this$computeImportableName, "<this>");
                    if ($this$computeImportableName.getCallableId().isLocal()) {
                        return null;
                    }
                    if ($this$computeImportableName.getOrigin() instanceof FirDeclarationOrigin.SamConstructor) {
                        return $this$computeImportableName.getCallableId().asSingleFqName();
                    }
                    ClassId classId = $this$computeImportableName.getCallableId().getClassId();
                    if (classId == null) {
                        return $this$computeImportableName.getCallableId().asSingleFqName();
                    }
                    ClassId containingClassId = classId;
                    FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)$this$computeImportableName);
                    if (firClassLikeSymbol == null) {
                        return null;
                    }
                    containingClass = firClassLikeSymbol;
                    if ($this$computeImportableName instanceof FirConstructorSymbol) {
                        FirClassLikeSymbol<?> $this$isInner$iv = containingClass;
                        boolean $i$f$isInner = false;
                        if ($this$isInner$iv.getRawStatus().isInner()) return null;
                        FqName fqName2 = containingClassId.asSingleFqName();
                        return fqName2;
                    }
                    if (!(containingClass.getOrigin() instanceof FirDeclarationOrigin.Java)) break block8;
                    $this$isStatic$iv = $this$computeImportableName;
                    $i$f$isStatic = false;
                    if ($this$isStatic$iv.getRawStatus().isStatic()) break block9;
                }
                if (FirHelpersKt.getClassKind(containingClass) != ClassKind.ENUM_CLASS) break block10;
                $this$isStatic$iv = $this$computeImportableName;
                $i$f$isStatic = false;
                if ($this$isStatic$iv.getRawStatus().isStatic()) break block9;
            }
            if (FirHelpersKt.getClassKind(containingClass) != ClassKind.OBJECT) return null;
        }
        boolean bl = true;
        boolean canBeImported = bl;
        if (!canBeImported) return null;
        FqName fqName3 = $this$computeImportableName.getCallableId().asSingleFqName();
        return fqName3;
    }

    @NotNull
    public static final KaInitializerValue asKaInitializerValue(@NotNull FirExpression $this$asKaInitializerValue, @NotNull KaSymbolByFirBuilder builder2, boolean forAnnotationDefaultValue) {
        KaAnnotationValue annotationConstantValue;
        Intrinsics.checkNotNullParameter($this$asKaInitializerValue, "<this>");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        PsiElement psiElement = UtilsKt.getPsi($this$asKaInitializerValue);
        KtExpression ktExpression = psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
        KaConstantValue evaluated = FirCompileTimeConstantEvaluator.INSTANCE.evaluateAsKtConstantValue($this$asKaInitializerValue);
        KaInitializerValue kaInitializerValue = evaluated == null ? (forAnnotationDefaultValue ? ((annotationConstantValue = FirAnnotationValueConverter.INSTANCE.toConstantValue($this$asKaInitializerValue, builder2)) != null ? (KaInitializerValue)new KaConstantValueForAnnotation(annotationConstantValue, ktExpression) : (KaInitializerValue)new KaNonConstantInitializerValue(ktExpression)) : (KaInitializerValue)new KaNonConstantInitializerValue(ktExpression)) : (KaInitializerValue)new KaConstantInitializerValue(evaluated, ktExpression);
        return kaInitializerValue;
    }

    public static final void processEqualsFunctions(@NotNull FirEqualityOperatorCall $this$processEqualsFunctions, @NotNull FirSession session, @NotNull KaFirSession analysisSession, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor) {
        Intrinsics.checkNotNullParameter($this$processEqualsFunctions, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(analysisSession, "analysisSession");
        Intrinsics.checkNotNullParameter(processor, "processor");
        FirCall $this$arguments$iv = $this$processEqualsFunctions;
        boolean $i$f$getArguments = false;
        FirExpression firExpression = CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
        if (firExpression == null) {
            return;
        }
        FirExpression lhs = firExpression;
        FirTypeScope firTypeScope = ScopeUtilsKt.scope(FirTypeUtilsKt.getResolvedType(lhs), session, analysisSession.getScopeSessionFor(analysisSession.getFirSession$analysis_api_fir()), CallableCopyTypeCalculator.DoNothing.INSTANCE, FirResolvePhase.STATUS);
        if (firTypeScope == null) {
            return;
        }
        FirTypeScope scope2 = firTypeScope;
        scope2.processFunctionsByName(OperatorNameConventions.EQUALS, arg_0 -> FirUtilsKt.processEqualsFunctions$lambda$0(processor, arg_0));
    }

    private static final Unit processEqualsFunctions$lambda$0(Function1 $processor, FirNamedFunctionSymbol functionSymbol) {
        Intrinsics.checkNotNullParameter(functionSymbol, "functionSymbol");
        FirValueParameterSymbol parameterSymbol = CollectionsKt.singleOrNull(functionSymbol.getValueParameterSymbols());
        if (parameterSymbol != null && ConeBuiltinTypeUtilsKt.isNullableAny(parameterSymbol.getResolvedReturnType())) {
            $processor.invoke(functionSymbol);
        }
        return Unit.INSTANCE;
    }
}

