/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.fir.utils.KaFirCacheCleaner;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionInvalidationService;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.LLStatisticsService;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.domains.LLAnalysisSessionStatistics;
import org.jetbrains.kotlin.utils.exceptions.PlatformExceptionUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\n\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\bJ\u000f\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\bJ\u000f\u0010\f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\f\u0010\bJ\u000f\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000eR#\u0010\u0015\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\u0014\u0010\b\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R,\u0010\u001a\u001a\u001a\u0012\b\u0012\u0006*\u00020\u00160\u0016*\f\u0012\b\u0012\u0006*\u00020\u00160\u00160\u00190\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001c8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0016\u0010 \u001a\u00020\u001f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010%\u001a\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010&\u001a\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010$"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/utils/KaFirStopWorldCacheCleaner;", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/KaFirCacheCleaner;", "Lcom/intellij/openapi/project/Project;", "project", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "", "enterAnalysis", "()V", "exitAnalysis", "incAnalysisDepth", "decAnalysisDepth", "scheduleCleanup", "performCleanup", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLAnalysisSessionStatistics;", "analysisSessionStatistics$delegate", "Lkotlin/Lazy;", "getAnalysisSessionStatistics", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLAnalysisSessionStatistics;", "getAnalysisSessionStatistics$annotations", "analysisSessionStatistics", "", "analyzerCount", "I", "Ljava/lang/ThreadLocal;", "analyzerDepth", "Ljava/lang/ThreadLocal;", "Ljava/util/concurrent/CountDownLatch;", "cleanupLatch", "Ljava/util/concurrent/CountDownLatch;", "", "cleanupScheduleMs", "J", "", "getHasOngoingAnalysis", "()Z", "hasOngoingAnalysis", "isAnalysisAllowed", "Companion"})
public final class KaFirStopWorldCacheCleaner
implements KaFirCacheCleaner {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy analysisSessionStatistics$delegate;
    private volatile int analyzerCount;
    private final ThreadLocal<Integer> analyzerDepth;
    @Nullable
    private volatile CountDownLatch cleanupLatch;
    private volatile long cleanupScheduleMs;
    @NotNull
    private static final Logger LOG;
    private static final long CACHE_CLEANER_LOCK_TIMEOUT_MS = 50L;

    public KaFirStopWorldCacheCleaner(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.project = project;
        this.analysisSessionStatistics$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, () -> KaFirStopWorldCacheCleaner.analysisSessionStatistics_delegate$lambda$0(this));
        this.analyzerDepth = ThreadLocal.withInitial(KaFirStopWorldCacheCleaner::analyzerDepth$lambda$1);
    }

    private final LLAnalysisSessionStatistics getAnalysisSessionStatistics() {
        Lazy lazy = this.analysisSessionStatistics$delegate;
        return (LLAnalysisSessionStatistics)lazy.getValue();
    }

    private static /* synthetic */ void getAnalysisSessionStatistics$annotations() {
    }

    private final boolean getHasOngoingAnalysis() {
        return ((Number)this.analyzerDepth.get()).intValue() > 0;
    }

    private final boolean isAnalysisAllowed() {
        return ApplicationManager.getApplication().isReadAccessAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enterAnalysis() {
        if (this.getHasOngoingAnalysis()) {
            this.incAnalysisDepth();
            return;
        }
        CountDownLatch existingLatch = this.cleanupLatch;
        if (existingLatch != null) {
            while (!existingLatch.await(50L, TimeUnit.MILLISECONDS)) {
                ProgressManager.checkCanceled();
            }
        }
        if (!this.isAnalysisAllowed()) {
            this.incAnalysisDepth();
            return;
        }
        KaFirStopWorldCacheCleaner kaFirStopWorldCacheCleaner = this;
        synchronized (kaFirStopWorldCacheCleaner) {
            boolean bl = false;
            ++this.analyzerCount;
            Unit unit = Unit.INSTANCE;
        }
        this.incAnalysisDepth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitAnalysis() {
        this.decAnalysisDepth();
        if (!this.isAnalysisAllowed() || this.getHasOngoingAnalysis()) {
            return;
        }
        KaFirStopWorldCacheCleaner kaFirStopWorldCacheCleaner = this;
        synchronized (kaFirStopWorldCacheCleaner) {
            CountDownLatch existingLatch;
            boolean bl = false;
            --this.analyzerCount;
            if (!(this.analyzerCount >= 0)) {
                boolean $i$a$-require-KaFirStopWorldCacheCleaner$exitAnalysis$1$22 = false;
                String $i$a$-require-KaFirStopWorldCacheCleaner$exitAnalysis$1$22 = "Inconsistency in analyzer block counter";
                throw new IllegalArgumentException($i$a$-require-KaFirStopWorldCacheCleaner$exitAnalysis$1$22.toString());
            }
            if (this.cleanupLatch != null) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl2 = false;
                    logger.debug("Analysis complete in " + Thread.currentThread() + ", " + this.analyzerCount + " left before the K2 cache cleanup", e$iv);
                }
            }
            if (this.analyzerCount == 0 && (existingLatch = this.cleanupLatch) != null) {
                this.performCleanup();
                existingLatch.countDown();
                this.cleanupLatch = null;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void incAnalysisDepth() {
        this.analyzerDepth.set(((Number)this.analyzerDepth.get()).intValue() + 1);
    }

    private final void decAnalysisDepth() {
        boolean bl;
        Integer oldValue = this.analyzerDepth.get();
        boolean bl2 = bl = oldValue > 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Inconsistency in analysis depth counter";
            throw new AssertionError((Object)string2);
        }
        this.analyzerDepth.set(oldValue - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleCleanup() {
        KaFirStopWorldCacheCleaner kaFirStopWorldCacheCleaner = this;
        synchronized (kaFirStopWorldCacheCleaner) {
            boolean bl = false;
            CountDownLatch existingLatch = this.cleanupLatch;
            if (this.analyzerCount == 0) {
                this.cleanupScheduleMs = System.currentTimeMillis();
                this.performCleanup();
                if (existingLatch != null) {
                    existingLatch.countDown();
                    this.cleanupLatch = null;
                    LOG.error("K2 cache cleanup was expected to happen right after the last analysis block completion");
                }
            } else if (existingLatch == null) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl2 = false;
                    logger.debug("K2 cache cleanup scheduled from " + Thread.currentThread() + ", " + this.analyzerCount + " analyses left", e$iv);
                }
                this.cleanupScheduleMs = System.currentTimeMillis();
                this.cleanupLatch = new CountDownLatch(1);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void performCleanup() {
        try {
            LLAnalysisSessionStatistics lLAnalysisSessionStatistics = this.getAnalysisSessionStatistics();
            if (lLAnalysisSessionStatistics != null && (lLAnalysisSessionStatistics = lLAnalysisSessionStatistics.getLowMemoryCacheCleanupInvocationCounter()) != null) {
                lLAnalysisSessionStatistics.add(1L);
            }
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            LLFirSessionInvalidationService invalidationService = LLFirSessionInvalidationService.Companion.getInstance(this.project);
            invalidationService.invalidateAll(true);
            long cleanupMs = System.currentTimeMillis() - start$iv;
            long totalMs = System.currentTimeMillis() - this.cleanupScheduleMs;
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger.debug("K2 cache cleanup complete from " + Thread.currentThread() + " in " + cleanupMs + " ms (" + totalMs + " ms after the request)", e$iv);
            }
        }
        catch (Throwable e) {
            PlatformExceptionUtilsKt.rethrowIntellijPlatformExceptionIfNeeded(e);
            LOG.error("Could not clean up K2 caches", e);
        }
    }

    private static final LLAnalysisSessionStatistics analysisSessionStatistics_delegate$lambda$0(KaFirStopWorldCacheCleaner this$0) {
        LLStatisticsService lLStatisticsService = LLStatisticsService.Companion.getInstance(this$0.project);
        return lLStatisticsService != null ? lLStatisticsService.getAnalysisSessions() : null;
    }

    private static final Integer analyzerDepth$lambda$1() {
        return 0;
    }

    static {
        Logger logger = Logger.getInstance(KaFirStopWorldCacheCleaner.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\t\u0010\n"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/utils/KaFirStopWorldCacheCleaner$Companion;", "", "<init>", "()V", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "", "CACHE_CLEANER_LOCK_TIMEOUT_MS", "J"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

