/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.components;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.KaSessionKt;
import org.jetbrains.kotlin.analysis.api.components.KaAnalysisScopeProvider;
import org.jetbrains.kotlin.analysis.api.impl.base.components.KaBaseSessionComponent;
import org.jetbrains.kotlin.analysis.api.impl.base.sessions.KaGlobalSearchScope;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInaccessibleLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInvalidLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.projectStructure.DanglingFilesKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001d\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\f\u001a\u00020\u000b*\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u000b*\u00020\nH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rR \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00048\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u00138WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseAnalysisScopeProviderImpl;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseSessionComponent;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "Lorg/jetbrains/kotlin/analysis/api/components/KaAnalysisScopeProvider;", "Lkotlin/Function0;", "analysisSessionProvider", "Lorg/jetbrains/kotlin/analysis/api/impl/base/sessions/KaGlobalSearchScope;", "useSiteScope", "<init>", "(Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/analysis/api/impl/base/sessions/KaGlobalSearchScope;)V", "Lcom/intellij/psi/PsiElement;", "", "canBeAnalysed", "(Lcom/intellij/psi/PsiElement;)Z", "isFromGeneratedModule", "Lkotlin/jvm/functions/Function0;", "getAnalysisSessionProvider", "()Lkotlin/jvm/functions/Function0;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/sessions/KaGlobalSearchScope;", "Lcom/intellij/psi/search/GlobalSearchScope;", "getAnalysisScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "analysisScope"})
public final class KaBaseAnalysisScopeProviderImpl
extends KaBaseSessionComponent<KaSession>
implements KaAnalysisScopeProvider {
    @NotNull
    private final Function0<KaSession> analysisSessionProvider;
    @NotNull
    private final KaGlobalSearchScope useSiteScope;

    public KaBaseAnalysisScopeProviderImpl(@NotNull Function0<? extends KaSession> analysisSessionProvider, @NotNull KaGlobalSearchScope useSiteScope) {
        Intrinsics.checkNotNullParameter(analysisSessionProvider, "analysisSessionProvider");
        Intrinsics.checkNotNullParameter(useSiteScope, "useSiteScope");
        this.analysisSessionProvider = analysisSessionProvider;
        this.useSiteScope = useSiteScope;
    }

    @Override
    @NotNull
    public Function0<KaSession> getAnalysisSessionProvider() {
        return this.analysisSessionProvider;
    }

    @Override
    @NotNull
    public GlobalSearchScope getAnalysisScope() {
        KaLifetimeOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        KaLifetimeOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KaLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        KaLifetimeToken $this$assertIsValid$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsValid = false;
        if (!$this$assertIsValid$iv$iv$iv$iv.isValid()) {
            throw new KaInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValid$iv$iv$iv$iv + ": " + $this$assertIsValid$iv$iv$iv$iv.getInvalidationReason());
        }
        KaLifetimeToken $this$assertIsAccessible$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsAccessible = false;
        if (!$this$assertIsAccessible$iv$iv$iv$iv.isAccessible()) {
            throw new KaInaccessibleLifetimeOwnerAccessException($this$assertIsAccessible$iv$iv$iv$iv + " is inaccessible: " + $this$assertIsAccessible$iv$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        return this.useSiteScope;
    }

    @Override
    public boolean canBeAnalysed(@NotNull PsiElement $this$canBeAnalysed) {
        Intrinsics.checkNotNullParameter($this$canBeAnalysed, "<this>");
        KaLifetimeOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        KaLifetimeOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KaLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        KaLifetimeToken $this$assertIsValid$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsValid = false;
        if (!$this$assertIsValid$iv$iv$iv$iv.isValid()) {
            throw new KaInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValid$iv$iv$iv$iv + ": " + $this$assertIsValid$iv$iv$iv$iv.getInvalidationReason());
        }
        KaLifetimeToken $this$assertIsAccessible$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsAccessible = false;
        if (!$this$assertIsAccessible$iv$iv$iv$iv.isAccessible()) {
            throw new KaInaccessibleLifetimeOwnerAccessException($this$assertIsAccessible$iv$iv$iv$iv + " is inaccessible: " + $this$assertIsAccessible$iv$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        return PsiUtilsKt.contains(this.useSiteScope.getBaseScope(), $this$canBeAnalysed) && !PsiUtilsKt.contains(this.useSiteScope.getShadowedScope(), $this$canBeAnalysed) || this.isFromGeneratedModule($this$canBeAnalysed);
    }

    private final boolean isFromGeneratedModule(PsiElement $this$isFromGeneratedModule) {
        PsiFile psiFile = $this$isFromGeneratedModule.getContainingFile();
        KtFile ktFile = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile == null) {
            return false;
        }
        KtFile ktFile2 = ktFile;
        if (DanglingFilesKt.isDangling(ktFile2)) {
            KaModule module2 = KaSessionKt.getModule(this.getAnalysisSession(), ktFile2);
            return this.useSiteScope.isFromGeneratedModule(module2);
        }
        VirtualFile virtualFile = ktFile2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        return this.useSiteScope.isFromGeneratedModule(virtualFile2);
    }
}

