/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.lifetime;

import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.platform.lifetime.KaLifetimeTracker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bRD\u0010\r\u001a2\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f*\b\u0012\u0004\u0012\u00020\f0\u000b0\u000b*\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f*\b\u0012\u0004\u0012\u00020\f0\u000b0\u000b0\n0\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0016\u0010\u0011\u001a\u0004\u0018\u00010\f8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/lifetime/KaBaseLifetimeTracker;", "Lorg/jetbrains/kotlin/analysis/api/platform/lifetime/KaLifetimeTracker;", "<init>", "()V", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "session", "", "beforeEnteringAnalysis", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)V", "afterLeavingAnalysis", "Ljava/lang/ThreadLocal;", "Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "lifetimeOwnersStack", "Ljava/lang/ThreadLocal;", "getCurrentToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "currentToken", "Companion"})
public final class KaBaseLifetimeTracker
implements KaLifetimeTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final ThreadLocal<PersistentList<KaLifetimeToken>> lifetimeOwnersStack = ThreadLocal.withInitial(KaBaseLifetimeTracker::lifetimeOwnersStack$lambda$0);

    @Override
    @Nullable
    public KaLifetimeToken getCurrentToken() {
        PersistentList<KaLifetimeToken> persistentList = this.lifetimeOwnersStack.get();
        Intrinsics.checkNotNullExpressionValue(persistentList, "get(...)");
        return (KaLifetimeToken)CollectionsKt.lastOrNull((List)persistentList);
    }

    public final void beforeEnteringAnalysis(@NotNull KaSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this.lifetimeOwnersStack.set(this.lifetimeOwnersStack.get().add(session.getToken()));
    }

    public final void afterLeavingAnalysis(@NotNull KaSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        PersistentList<KaLifetimeToken> stack = this.lifetimeOwnersStack.get();
        Intrinsics.checkNotNull(stack);
        KaLifetimeToken last2 = (KaLifetimeToken)CollectionsKt.last((List)stack);
        if (!Intrinsics.areEqual(last2, session.getToken())) {
            throw new IllegalStateException("Check failed.");
        }
        this.lifetimeOwnersStack.set(stack.removeAt(CollectionsKt.getLastIndex((List)stack)));
    }

    private static final PersistentList lifetimeOwnersStack$lambda$0() {
        return ExtensionsKt.persistentListOf();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/lifetime/KaBaseLifetimeTracker$Companion;", "", "<init>", "()V", "Lcom/intellij/openapi/project/Project;", "project", "Lorg/jetbrains/kotlin/analysis/api/impl/base/lifetime/KaBaseLifetimeTracker;", "getInstance", "(Lcom/intellij/openapi/project/Project;)Lorg/jetbrains/kotlin/analysis/api/impl/base/lifetime/KaBaseLifetimeTracker;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KaBaseLifetimeTracker getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter(project, "project");
            KaLifetimeTracker kaLifetimeTracker = KaLifetimeTracker.Companion.getInstance(project);
            KaBaseLifetimeTracker kaBaseLifetimeTracker = kaLifetimeTracker instanceof KaBaseLifetimeTracker ? (KaBaseLifetimeTracker)kaLifetimeTracker : null;
            if (kaBaseLifetimeTracker == null) {
                throw new IllegalStateException(("Expected " + Reflection.getOrCreateKotlinClass(KaBaseLifetimeTracker.class).getSimpleName() + " to be registered for " + Reflection.getOrCreateKotlinClass(KaLifetimeTracker.class).getSimpleName() + '.').toString());
            }
            return kaBaseLifetimeTracker;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

