/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.references;

import com.intellij.openapi.project.Project;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.references.KotlinPsiReferenceProvider;
import org.jetbrains.kotlin.idea.references.KotlinPsiReferenceRegistrar;
import org.jetbrains.kotlin.idea.references.KotlinReferenceProviderContributor;
import org.jetbrains.kotlin.psi.KotlinReferenceProvidersService;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\r\u0010\u000bR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R(\u0010\u0014\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0012\u0012\u0004\u0012\u00020\u00130\u00118\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R.\u0010\u0018\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00170\u00168\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/references/HLApiReferenceProviderService;", "Lorg/jetbrains/kotlin/psi/KotlinReferenceProvidersService;", "Lcom/intellij/openapi/project/Project;", "project", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "Lcom/intellij/psi/PsiElement;", "context", "", "Lcom/intellij/psi/PsiReference;", "doGetKotlinReferencesFromProviders", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "psiElement", "getReferences", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "Lcom/intellij/util/containers/MultiMap;", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/idea/references/KotlinPsiReferenceProvider;", "originalProvidersBinding", "Lcom/intellij/util/containers/MultiMap;", "", "", "providersBindingCache", "Ljava/util/Map;"})
public final class HLApiReferenceProviderService
extends KotlinReferenceProvidersService {
    @NotNull
    private final Project project;
    @NotNull
    private final MultiMap<Class<? extends PsiElement>, KotlinPsiReferenceProvider> originalProvidersBinding;
    @NotNull
    private final Map<Class<? extends PsiElement>, List<KotlinPsiReferenceProvider>> providersBindingCache;

    public HLApiReferenceProviderService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.project = project;
        KotlinPsiReferenceRegistrar registrar2 = new KotlinPsiReferenceRegistrar();
        KotlinReferenceProviderContributor.Companion.getInstance(this.project).registerReferenceProviders(registrar2);
        this.originalProvidersBinding = registrar2.getProviders();
        ConcurrentMap<Object, List> concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> HLApiReferenceProviderService._init_$lambda$1(arg_0 -> HLApiReferenceProviderService._init_$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "createMap(...)");
        this.providersBindingCache = concurrentMap;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final PsiReference[] doGetKotlinReferencesFromProviders(PsiElement context) {
        List<KotlinPsiReferenceProvider> providers = this.providersBindingCache.get(context.getClass());
        Collection collection = providers;
        if (collection == null || collection.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue(PsiReference.EMPTY_ARRAY, "EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList result2 = new SmartList();
        for (KotlinPsiReferenceProvider provider2 : providers) {
            CollectionsKt.addAll((Collection)result2, provider2.getReferencesByElement(context));
        }
        if (result2.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue(PsiReference.EMPTY_ARRAY, "EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiReference[0]);
    }

    @Override
    @NotNull
    public PsiReference[] getReferences(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter(psiElement, "psiElement");
        if (psiElement instanceof ContributedReferenceHost) {
            PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders(psiElement, PsiReferenceService.Hints.NO_HINTS);
            Intrinsics.checkNotNullExpressionValue(psiReferenceArray, "getReferencesFromProviders(...)");
            return psiReferenceArray;
        }
        Object t = CachedValuesManager.getCachedValue(psiElement, () -> HLApiReferenceProviderService.getReferences$lambda$2(this, psiElement));
        Intrinsics.checkNotNullExpressionValue(t, "getCachedValue(...)");
        return (PsiReference[])t;
    }

    private static final List _init_$lambda$0(HLApiReferenceProviderService this$0, Class klass) {
        SmartList<KotlinPsiReferenceProvider> result2 = new SmartList<KotlinPsiReferenceProvider>();
        for (Class<? extends PsiElement> bindingClass : this$0.originalProvidersBinding.keySet()) {
            if (!bindingClass.isAssignableFrom(klass)) continue;
            result2.addAll(this$0.originalProvidersBinding.get(bindingClass));
        }
        return result2;
    }

    private static final List _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final CachedValueProvider.Result getReferences$lambda$2(HLApiReferenceProviderService this$0, PsiElement $psiElement) {
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create(this$0.doGetKotlinReferencesFromProviders($psiElement), objectArray);
    }
}

