/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.sessions;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.impl.base.lifetime.KaBaseLifetimeTracker;
import org.jetbrains.kotlin.analysis.api.impl.base.permissions.KaBaseWriteActionStartedChecker;
import org.jetbrains.kotlin.analysis.api.impl.base.sessions.ProhibitedAnalysisException;
import org.jetbrains.kotlin.analysis.api.platform.lifetime.KotlinLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.platform.permissions.KaAnalysisPermissionChecker;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0010J\u001f\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\fJ\u001f\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010R!\u0010\u0019\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u001f\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u0014\u0012\u0004\b\u001e\u0010\u0018\u001a\u0004\b\u001c\u0010\u001dR!\u0010%\u001a\u00020 8EX\u0084\u0084\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u0014\u0012\u0004\b$\u0010\u0018\u001a\u0004\b\"\u0010#R\u0014\u0010'\u001a\u00020&8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010("}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/sessions/KaBaseSessionProvider;", "Lorg/jetbrains/kotlin/analysis/api/session/KaSessionProvider;", "Lcom/intellij/openapi/project/Project;", "project", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "session", "Lorg/jetbrains/kotlin/psi/KtElement;", "useSiteElement", "", "beforeEnteringAnalysis", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtElement;)V", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "useSiteModule", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)V", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)V", "afterLeavingAnalysis", "Lorg/jetbrains/kotlin/analysis/api/platform/permissions/KaAnalysisPermissionChecker;", "permissionChecker$delegate", "Lkotlin/Lazy;", "getPermissionChecker", "()Lorg/jetbrains/kotlin/analysis/api/platform/permissions/KaAnalysisPermissionChecker;", "getPermissionChecker$annotations", "()V", "permissionChecker", "Lorg/jetbrains/kotlin/analysis/api/impl/base/lifetime/KaBaseLifetimeTracker;", "lifetimeTracker$delegate", "getLifetimeTracker", "()Lorg/jetbrains/kotlin/analysis/api/impl/base/lifetime/KaBaseLifetimeTracker;", "getLifetimeTracker$annotations", "lifetimeTracker", "Lorg/jetbrains/kotlin/analysis/api/platform/lifetime/KotlinLifetimeTokenFactory;", "tokenFactory$delegate", "getTokenFactory", "()Lorg/jetbrains/kotlin/analysis/api/platform/lifetime/KotlinLifetimeTokenFactory;", "getTokenFactory$annotations", "tokenFactory", "Lorg/jetbrains/kotlin/analysis/api/impl/base/permissions/KaBaseWriteActionStartedChecker;", "writeActionStartedChecker", "Lorg/jetbrains/kotlin/analysis/api/impl/base/permissions/KaBaseWriteActionStartedChecker;"})
public abstract class KaBaseSessionProvider
extends KaSessionProvider {
    @NotNull
    private final Lazy permissionChecker$delegate;
    @NotNull
    private final Lazy lifetimeTracker$delegate;
    @NotNull
    private final Lazy tokenFactory$delegate;
    @NotNull
    private final KaBaseWriteActionStartedChecker writeActionStartedChecker;

    public KaBaseSessionProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        super(project);
        this.permissionChecker$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, () -> KaBaseSessionProvider.permissionChecker_delegate$lambda$0(project));
        this.lifetimeTracker$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, () -> KaBaseSessionProvider.lifetimeTracker_delegate$lambda$1(project));
        this.tokenFactory$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, () -> KaBaseSessionProvider.tokenFactory_delegate$lambda$2(project));
        this.writeActionStartedChecker = new KaBaseWriteActionStartedChecker(this);
    }

    private final KaAnalysisPermissionChecker getPermissionChecker() {
        Lazy lazy = this.permissionChecker$delegate;
        return (KaAnalysisPermissionChecker)lazy.getValue();
    }

    private static /* synthetic */ void getPermissionChecker$annotations() {
    }

    private final KaBaseLifetimeTracker getLifetimeTracker() {
        Lazy lazy = this.lifetimeTracker$delegate;
        return (KaBaseLifetimeTracker)lazy.getValue();
    }

    private static /* synthetic */ void getLifetimeTracker$annotations() {
    }

    @NotNull
    protected final KotlinLifetimeTokenFactory getTokenFactory() {
        Lazy lazy = this.tokenFactory$delegate;
        return (KotlinLifetimeTokenFactory)lazy.getValue();
    }

    protected static /* synthetic */ void getTokenFactory$annotations() {
    }

    @Override
    public void beforeEnteringAnalysis(@NotNull KaSession session, @NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(useSiteElement, "useSiteElement");
        PsiUtilCore.ensureValid(useSiteElement);
        this.beforeEnteringAnalysis(session);
    }

    @Override
    public void beforeEnteringAnalysis(@NotNull KaSession session, @NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(useSiteModule, "useSiteModule");
        this.beforeEnteringAnalysis(session);
    }

    private final void beforeEnteringAnalysis(KaSession session) {
        if (!this.getPermissionChecker().isAnalysisAllowed()) {
            throw new ProhibitedAnalysisException("Analysis is not allowed: " + this.getPermissionChecker().getRejectionReason());
        }
        ProgressManager.checkCanceled();
        if (DumbService.Companion.isDumb(this.getProject())) {
            throw IndexNotReadyException.create();
        }
        this.getLifetimeTracker().beforeEnteringAnalysis(session);
        this.writeActionStartedChecker.beforeEnteringAnalysis();
    }

    @Override
    public void afterLeavingAnalysis(@NotNull KaSession session, @NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(useSiteElement, "useSiteElement");
        this.afterLeavingAnalysis(session);
    }

    @Override
    public void afterLeavingAnalysis(@NotNull KaSession session, @NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(useSiteModule, "useSiteModule");
        this.afterLeavingAnalysis(session);
    }

    private final void afterLeavingAnalysis(KaSession session) {
        this.writeActionStartedChecker.afterLeavingAnalysis();
        this.getLifetimeTracker().afterLeavingAnalysis(session);
    }

    private static final KaAnalysisPermissionChecker permissionChecker_delegate$lambda$0(Project $project) {
        return KaAnalysisPermissionChecker.Companion.getInstance($project);
    }

    private static final KaBaseLifetimeTracker lifetimeTracker_delegate$lambda$1(Project $project) {
        return KaBaseLifetimeTracker.Companion.getInstance($project);
    }

    private static final KotlinLifetimeTokenFactory tokenFactory_delegate$lambda$2(Project $project) {
        return KotlinLifetimeTokenFactory.Companion.getInstance($project);
    }
}

