/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.sessions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinResolutionScopeEnlarger;
import org.jetbrains.kotlin.analysis.api.projectStructure.ContextModuleKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.DependenciesKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0017\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0018\u0010\u0014J\u0015\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0018\u0010\u001aR\u001a\u0010\u0002\u001a\u00020\u00018\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0002\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u00018\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001b\u001a\u0004\b \u0010\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/sessions/KaGlobalSearchScope;", "Lcom/intellij/psi/search/GlobalSearchScope;", "shadowedScope", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "useSiteModule", "<init>", "(Lcom/intellij/psi/search/GlobalSearchScope;Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)V", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/module/Module;", "aModule", "", "isSearchInModuleContent", "(Lcom/intellij/openapi/module/Module;)Z", "isSearchInLibraries", "()Z", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "contains", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "", "toString", "()Ljava/lang/String;", "isFromGeneratedModule", "analysisContextModule", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)Z", "Lcom/intellij/psi/search/GlobalSearchScope;", "getShadowedScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "baseScope", "getBaseScope"})
public final class KaGlobalSearchScope
extends GlobalSearchScope {
    @NotNull
    private final GlobalSearchScope shadowedScope;
    @NotNull
    private final KaModule useSiteModule;
    @NotNull
    private final GlobalSearchScope baseScope;

    public KaGlobalSearchScope(@NotNull GlobalSearchScope shadowedScope, @NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter(shadowedScope, "shadowedScope");
        Intrinsics.checkNotNullParameter(useSiteModule, "useSiteModule");
        this.shadowedScope = shadowedScope;
        this.useSiteModule = useSiteModule;
        this.baseScope = KotlinResolutionScopeEnlarger.Companion.getEnlargedResolutionScope$default(KotlinResolutionScopeEnlarger.Companion, this.useSiteModule, null, 2, null);
    }

    @NotNull
    public final GlobalSearchScope getShadowedScope() {
        return this.shadowedScope;
    }

    @NotNull
    public final GlobalSearchScope getBaseScope() {
        return this.baseScope;
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.baseScope.getProject();
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        Intrinsics.checkNotNullParameter(aModule, "aModule");
        return this.baseScope.isSearchInModuleContent(aModule);
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.baseScope.isSearchInLibraries();
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return this.baseScope.contains(file2) && !this.shadowedScope.contains(file2) || this.isFromGeneratedModule(file2);
    }

    @NotNull
    public String toString() {
        return "Analysis scope for " + this.useSiteModule + " (base: " + this.baseScope + ", shadowed: " + this.shadowedScope + ')';
    }

    public final boolean isFromGeneratedModule(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        KaModule kaModule = ContextModuleKt.getAnalysisContextModule(file2);
        if (kaModule == null) {
            return false;
        }
        KaModule analysisContextModule = kaModule;
        return this.isFromGeneratedModule(analysisContextModule);
    }

    public final boolean isFromGeneratedModule(@NotNull KaModule analysisContextModule) {
        Intrinsics.checkNotNullParameter(analysisContextModule, "analysisContextModule");
        return Intrinsics.areEqual(analysisContextModule, this.useSiteModule) || SequencesKt.contains(DependenciesKt.allDirectDependencies(this.useSiteModule), analysisContextModule);
    }
}

