/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.symbols.pointers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import java.lang.ref.SoftReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\t\u001a\u0004\u0018\u00018\u0000H\u0017\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0011\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0011\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0011\u0010\u0016\u001a\u0004\u0018\u00010\u0013H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0015R\u0019\u0010\u0018\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00178\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001b\u001a\f\u0012\b\u0012\u0006*\u00028\u00008\u00000\u001a8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\f\u0012\b\u0012\u0006*\u00020\u00050\u00050\u001a8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001c"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/SoftSmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "T", "Lcom/intellij/psi/SmartPsiElementPointer;", "element", "Lcom/intellij/psi/PsiFile;", "containingFile", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiFile;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getContainingFile", "()Lcom/intellij/psi/PsiFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/util/Segment;", "getPsiRange", "()Lcom/intellij/openapi/util/Segment;", "getRange", "Lorg/jetbrains/annotations/NotNull;", "project", "Lcom/intellij/openapi/project/Project;", "Ljava/lang/ref/SoftReference;", "elementRef", "Ljava/lang/ref/SoftReference;", "containingFileRef"})
final class SoftSmartPsiElementPointer<T extends PsiElement>
implements SmartPsiElementPointer<T> {
    @NotNull
    private final Project project;
    @NotNull
    private final SoftReference<T> elementRef;
    @NotNull
    private final SoftReference<PsiFile> containingFileRef;

    public SoftSmartPsiElementPointer(@NotNull T element, @NotNull PsiFile containingFile) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(containingFile, "containingFile");
        Project project = containingFile.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
        this.project = project;
        this.elementRef = new SoftReference<T>(element);
        this.containingFileRef = new SoftReference<PsiFile>(containingFile);
    }

    @Override
    @Nullable
    public T getElement() {
        return (T)((PsiElement)this.elementRef.get());
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return this.containingFileRef.get();
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        PsiFile psiFile = this.getContainingFile();
        return psiFile != null ? psiFile.getVirtualFile() : null;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public Segment getPsiRange() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    @Nullable
    public Segment getRange() {
        throw new UnsupportedOperationException("Not supported");
    }
}

