/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.util;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.impl.base.util.KaSessionCreationContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u00032\b\u0012\u0004\u0012\u00028\u00000\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00028\u0000H\u0097\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u0004\u0018\u00018\u00008\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/util/KaSessionCreationContextImpl;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "T", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/util/KaSessionCreationContext;", "<init>", "()V", "session", "", "initialize", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)V", "invoke", "()Lorg/jetbrains/kotlin/analysis/api/KaSession;", "cachedSession", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "getAnalysisSessionProvider", "()Lkotlin/jvm/functions/Function0;", "analysisSessionProvider"})
final class KaSessionCreationContextImpl<T extends KaSession>
implements Function0<T>,
KaSessionCreationContext<T> {
    @Nullable
    private T cachedSession;

    public final void initialize(@NotNull T session) {
        Intrinsics.checkNotNullParameter(session, "session");
        if (!(this.cachedSession == null)) {
            boolean bl = false;
            String string2 = "The session is already initialized";
            throw new IllegalArgumentException(string2.toString());
        }
        this.cachedSession = session;
    }

    @Override
    @NotNull
    public Function0<T> getAnalysisSessionProvider() {
        return this;
    }

    @Override
    @NotNull
    public T invoke() {
        T t = this.cachedSession;
        if (t == null) {
            throw new IllegalStateException("Session is not yet initialized. If you are inside a session component, perhaps you will need to wrap your computation in 'lazy {}'".toString());
        }
        return t;
    }
}

