/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.io.URLUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.impl.base.util.JdkClassFinder;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ9\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0014\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ%\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ'\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b \u0010!"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/util/LibraryUtils;", "", "<init>", "()V", "Ljava/nio/file/Path;", "jar", "Lcom/intellij/openapi/vfs/impl/jar/CoreJarFileSystem;", "jarFileSystem", "", "includeRoot", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAllVirtualFilesFromJar", "(Ljava/nio/file/Path;Lcom/intellij/openapi/vfs/impl/jar/CoreJarFileSystem;Z)Ljava/util/Collection;", "Lcom/intellij/openapi/project/Project;", "project", "", "Lcom/intellij/psi/PsiFile;", "getAllPsiFilesFromJar", "(Ljava/nio/file/Path;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/impl/jar/CoreJarFileSystem;Z)Ljava/util/List;", "dir", "getAllVirtualFilesFromDirectory", "(Ljava/nio/file/Path;Z)Ljava/util/Collection;", "getAllPsiFilesFromDirectory", "(Ljava/nio/file/Path;Lcom/intellij/openapi/project/Project;Z)Ljava/util/List;", "root", "getAllVirtualFilesFromRoot", "(Lcom/intellij/openapi/vfs/VirtualFile;Z)Ljava/util/Collection;", "jdkHome", "isJre", "findClassesFromJdkHome", "(Ljava/nio/file/Path;Z)Ljava/util/List;", "mapToPsiFiles", "(Ljava/util/Collection;Lcom/intellij/openapi/project/Project;)Ljava/util/List;"})
public final class LibraryUtils {
    @NotNull
    public static final LibraryUtils INSTANCE = new LibraryUtils();

    private LibraryUtils() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Collection<VirtualFile> getAllVirtualFilesFromJar(@NotNull Path jar, @NotNull CoreJarFileSystem jarFileSystem, boolean includeRoot) {
        Collection<VirtualFile> collection;
        Intrinsics.checkNotNullParameter(jar, "jar");
        Intrinsics.checkNotNullParameter(jarFileSystem, "jarFileSystem");
        VirtualFile virtualFile = jarFileSystem.refreshAndFindFileByPath(jar + "!/");
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            Collection<VirtualFile> collection2 = INSTANCE.getAllVirtualFilesFromRoot(it, includeRoot);
            if (collection2 != null) {
                collection = collection2;
                return collection;
            }
        }
        collection = SetsKt.emptySet();
        return collection;
    }

    public static /* synthetic */ Collection getAllVirtualFilesFromJar$default(LibraryUtils libraryUtils, Path path, CoreJarFileSystem coreJarFileSystem, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            coreJarFileSystem = new CoreJarFileSystem();
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return libraryUtils.getAllVirtualFilesFromJar(path, coreJarFileSystem, bl);
    }

    @NotNull
    public final List<PsiFile> getAllPsiFilesFromJar(@NotNull Path jar, @NotNull Project project, @NotNull CoreJarFileSystem jarFileSystem, boolean includeRoot) {
        Intrinsics.checkNotNullParameter(jar, "jar");
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(jarFileSystem, "jarFileSystem");
        Collection<VirtualFile> virtualFiles = this.getAllVirtualFilesFromJar(jar, jarFileSystem, includeRoot);
        return this.mapToPsiFiles(virtualFiles, project);
    }

    public static /* synthetic */ List getAllPsiFilesFromJar$default(LibraryUtils libraryUtils, Path path, Project project, CoreJarFileSystem coreJarFileSystem, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            coreJarFileSystem = new CoreJarFileSystem();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return libraryUtils.getAllPsiFilesFromJar(path, project, coreJarFileSystem, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Collection<VirtualFile> getAllVirtualFilesFromDirectory(@NotNull Path dir2, boolean includeRoot) {
        Collection<VirtualFile> collection;
        Intrinsics.checkNotNullParameter(dir2, "dir");
        VirtualFileSystem fs = StandardFileSystems.local();
        VirtualFile virtualFile = fs.findFileByPath(((Object)dir2).toString());
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            Collection<VirtualFile> collection2 = INSTANCE.getAllVirtualFilesFromRoot(it, includeRoot);
            if (collection2 != null) {
                collection = collection2;
                return collection;
            }
        }
        collection = SetsKt.emptySet();
        return collection;
    }

    public static /* synthetic */ Collection getAllVirtualFilesFromDirectory$default(LibraryUtils libraryUtils, Path path, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return libraryUtils.getAllVirtualFilesFromDirectory(path, bl);
    }

    @NotNull
    public final List<PsiFile> getAllPsiFilesFromDirectory(@NotNull Path dir2, @NotNull Project project, boolean includeRoot) {
        Intrinsics.checkNotNullParameter(dir2, "dir");
        Intrinsics.checkNotNullParameter(project, "project");
        return this.mapToPsiFiles(this.getAllVirtualFilesFromDirectory(dir2, includeRoot), project);
    }

    public static /* synthetic */ List getAllPsiFilesFromDirectory$default(LibraryUtils libraryUtils, Path path, Project project, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return libraryUtils.getAllPsiFilesFromDirectory(path, project, bl);
    }

    @NotNull
    public final Collection<VirtualFile> getAllVirtualFilesFromRoot(@NotNull VirtualFile root, boolean includeRoot) {
        Intrinsics.checkNotNullParameter(root, "root");
        Set files2 = new LinkedHashSet();
        if (includeRoot) {
            files2.add(root);
        }
        VfsUtilCore.iterateChildrenRecursively(root, LibraryUtils::getAllVirtualFilesFromRoot$lambda$2, arg_0 -> LibraryUtils.getAllVirtualFilesFromRoot$lambda$3(files2, arg_0));
        return files2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Path> findClassesFromJdkHome(@NotNull Path jdkHome, boolean isJre) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(jdkHome, "jdkHome");
        List<String> list = JdkClassFinder.findClasses(jdkHome, isJre);
        Intrinsics.checkNotNullExpressionValue(list, "findClasses(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void rawPath;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string3 = URLUtil.extractPath((String)rawPath);
            Intrinsics.checkNotNullExpressionValue(string3, "extractPath(...)");
            String path = StringsKt.removeSuffix(StringsKt.removeSuffix(string3, (CharSequence)"/"), (CharSequence)"!");
            collection.add(Paths.get(path, new String[0]));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiFile> mapToPsiFiles(Collection<? extends VirtualFile> $this$mapToPsiFiles, Project project) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = $this$mapToPsiFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            VirtualFile virtualFile = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (PsiManager.getInstance(project).findFile(virtualFile) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean getAllVirtualFilesFromRoot$lambda$2(VirtualFile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    private static final boolean getAllVirtualFilesFromRoot$lambda$3(Set $files, VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter(virtualFile, "virtualFile");
        if (!virtualFile.isDirectory()) {
            $files.add(virtualFile);
        }
        return true;
    }
}

