/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.platform.lifetime;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationTrackerFactoryKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\f\u0010\bJ\u000f\u0010\r\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\r\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/api/platform/lifetime/KotlinAlwaysAccessibleLifetimeToken;", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "Lcom/intellij/openapi/project/Project;", "project", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "", "isValid", "()Z", "", "getInvalidationReason", "()Ljava/lang/String;", "isAccessible", "getInaccessibilityReason", "Lcom/intellij/openapi/util/ModificationTracker;", "modificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "", "onCreatedTimeStamp", "J"})
public final class KotlinAlwaysAccessibleLifetimeToken
extends KaLifetimeToken {
    @NotNull
    private final ModificationTracker modificationTracker;
    private final long onCreatedTimeStamp;

    public KotlinAlwaysAccessibleLifetimeToken(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.modificationTracker = KotlinModificationTrackerFactoryKt.createProjectWideOutOfBlockModificationTracker(project);
        this.onCreatedTimeStamp = this.modificationTracker.getModificationCount();
    }

    @Override
    public boolean isValid() {
        return this.onCreatedTimeStamp == this.modificationTracker.getModificationCount();
    }

    @Override
    @NotNull
    public String getInvalidationReason() {
        if (this.onCreatedTimeStamp != this.modificationTracker.getModificationCount()) {
            return "PSI has changed since creation";
        }
        throw new IllegalStateException("Getting invalidation reason for valid validity token".toString());
    }

    @Override
    public boolean isAccessible() {
        return true;
    }

    @Override
    @NotNull
    public String getInaccessibilityReason() {
        throw new IllegalStateException("Getting inaccessibility reason for validity token when it is accessible".toString());
    }
}

