/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.platform.lifetime;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.platform.lifetime.KaLifetimeTracker;
import org.jetbrains.kotlin.analysis.api.platform.lifetime.ModificationTrackerWithInvalidationReason;
import org.jetbrains.kotlin.analysis.api.platform.permissions.KaAnalysisPermissionChecker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0017\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\nJ\u000f\u0010\u000f\u001a\u00020\u000bH\u0017\u00a2\u0006\u0004\b\u000f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u0012\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u0012\u0004\b\u001c\u0010\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/api/platform/lifetime/KotlinReadActionConfinementLifetimeToken;", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "Lcom/intellij/openapi/project/Project;", "project", "Lcom/intellij/openapi/util/ModificationTracker;", "modificationTracker", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/util/ModificationTracker;)V", "", "isValid", "()Z", "", "getInvalidationReason", "()Ljava/lang/String;", "isAccessible", "getInaccessibilityReason", "Lcom/intellij/openapi/util/ModificationTracker;", "", "onCreatedTimeStamp", "J", "Lorg/jetbrains/kotlin/analysis/api/platform/permissions/KaAnalysisPermissionChecker;", "permissionChecker", "Lorg/jetbrains/kotlin/analysis/api/platform/permissions/KaAnalysisPermissionChecker;", "getPermissionChecker$annotations", "()V", "Lorg/jetbrains/kotlin/analysis/api/platform/lifetime/KaLifetimeTracker;", "lifetimeTracker", "Lorg/jetbrains/kotlin/analysis/api/platform/lifetime/KaLifetimeTracker;", "getLifetimeTracker$annotations"})
public final class KotlinReadActionConfinementLifetimeToken
extends KaLifetimeToken {
    @NotNull
    private final ModificationTracker modificationTracker;
    private final long onCreatedTimeStamp;
    @NotNull
    private final KaAnalysisPermissionChecker permissionChecker;
    @NotNull
    private final KaLifetimeTracker lifetimeTracker;

    public KotlinReadActionConfinementLifetimeToken(@NotNull Project project, @NotNull ModificationTracker modificationTracker) {
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(modificationTracker, "modificationTracker");
        this.modificationTracker = modificationTracker;
        this.onCreatedTimeStamp = this.modificationTracker.getModificationCount();
        this.permissionChecker = KaAnalysisPermissionChecker.Companion.getInstance(project);
        this.lifetimeTracker = KaLifetimeTracker.Companion.getInstance(project);
    }

    private static /* synthetic */ void getPermissionChecker$annotations() {
    }

    private static /* synthetic */ void getLifetimeTracker$annotations() {
    }

    @Override
    public boolean isValid() {
        return this.onCreatedTimeStamp == this.modificationTracker.getModificationCount();
    }

    @Override
    @NotNull
    public String getInvalidationReason() {
        if (this.onCreatedTimeStamp != this.modificationTracker.getModificationCount()) {
            String string2;
            if (this.modificationTracker instanceof ModificationTrackerWithInvalidationReason) {
                String string3 = ((ModificationTrackerWithInvalidationReason)this.modificationTracker).getInvalidationReason();
                if (string3 == null) {
                    throw new IllegalStateException(("Cannot get an invalidation reason for a " + Reflection.getOrCreateKotlinClass(ModificationTrackerWithInvalidationReason.class).getSimpleName() + " that's valid'").toString());
                }
                String trackerInvalidationReason = string3;
                string2 = "Session is invalidated: " + trackerInvalidationReason;
            } else {
                string2 = "Session is invalidated";
            }
            return string2;
        }
        throw new IllegalStateException("Cannot get an invalidation reason for a valid lifetime token.".toString());
    }

    @Override
    public boolean isAccessible() {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return false;
        }
        if (!this.permissionChecker.isAnalysisAllowed()) {
            return false;
        }
        return Intrinsics.areEqual(this.lifetimeTracker.getCurrentToken(), this);
    }

    @Override
    @NotNull
    public String getInaccessibilityReason() {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return "Called outside a read action.";
        }
        if (!this.permissionChecker.isAnalysisAllowed()) {
            return this.permissionChecker.getRejectionReason();
        }
        KaLifetimeToken currentToken = this.lifetimeTracker.getCurrentToken();
        if (currentToken == null) {
            return "Called outside an `analyze` context.";
        }
        if (!Intrinsics.areEqual(currentToken, this)) {
            return "Using a lifetime owner from an old `analyze` context.";
        }
        throw new IllegalStateException("Cannot get an inaccessibility reason for a lifetime token when it's accessible.".toString());
    }
}

