/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.platform.modification;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.KotlinMessageBusProviderKt;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalModificationService;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationTopics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H$\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\r\u0010\fJ\u000f\u0010\u000e\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/api/platform/modification/KotlinGlobalModificationServiceBase;", "Lorg/jetbrains/kotlin/analysis/api/platform/modification/KotlinGlobalModificationService;", "Lcom/intellij/openapi/project/Project;", "project", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "", "includeBinaryTrackers", "", "incrementModificationTrackers", "(Z)V", "publishGlobalModuleStateModification", "()V", "publishGlobalSourceModuleStateModification", "publishGlobalSourceOutOfBlockModification", "Lcom/intellij/openapi/project/Project;"})
public abstract class KotlinGlobalModificationServiceBase
implements KotlinGlobalModificationService {
    @NotNull
    private final Project project;

    public KotlinGlobalModificationServiceBase(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.project = project;
    }

    protected abstract void incrementModificationTrackers(boolean var1);

    @Override
    public void publishGlobalModuleStateModification() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.incrementModificationTrackers(true);
        KotlinMessageBusProviderKt.getAnalysisMessageBus(this.project).syncPublisher(KotlinModificationTopics.INSTANCE.getGLOBAL_MODULE_STATE_MODIFICATION()).onModification();
    }

    @Override
    public void publishGlobalSourceModuleStateModification() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.incrementModificationTrackers(false);
        KotlinMessageBusProviderKt.getAnalysisMessageBus(this.project).syncPublisher(KotlinModificationTopics.INSTANCE.getGLOBAL_SOURCE_MODULE_STATE_MODIFICATION()).onModification();
    }

    @Override
    public void publishGlobalSourceOutOfBlockModification() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.incrementModificationTrackers(false);
        KotlinMessageBusProviderKt.getAnalysisMessageBus(this.project).syncPublisher(KotlinModificationTopics.INSTANCE.getGLOBAL_SOURCE_OUT_OF_BLOCK_MODIFICATION()).onModification();
    }
}

