/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.platform.packages;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.packages.KotlinPackageProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ9\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\f0\u0010H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015J9\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\f0\u0010H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0015R\u001a\u0010\u0003\u001a\u00020\u00028\u0005X\u0085\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c"}, d2={"Lorg/jetbrains/kotlin/analysis/api/platform/packages/KotlinPackageProviderBase;", "Lorg/jetbrains/kotlin/analysis/api/platform/packages/KotlinPackageProvider;", "Lcom/intellij/openapi/project/Project;", "project", "Lcom/intellij/psi/search/GlobalSearchScope;", "searchScope", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)V", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "platform", "", "doesPackageExist", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/platform/TargetPlatform;)Z", "doesPlatformSpecificPackageExist", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "nameFilter", "", "getSubPackageFqNames", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/platform/TargetPlatform;Lkotlin/jvm/functions/Function1;)Ljava/util/Set;", "getPlatformSpecificSubPackagesFqNames", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "Lcom/intellij/psi/search/GlobalSearchScope;", "getSearchScope", "()Lcom/intellij/psi/search/GlobalSearchScope;"})
public abstract class KotlinPackageProviderBase
implements KotlinPackageProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope searchScope;

    public KotlinPackageProviderBase(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(searchScope, "searchScope");
        this.project = project;
        this.searchScope = searchScope;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GlobalSearchScope getSearchScope() {
        return this.searchScope;
    }

    @Override
    public boolean doesPackageExist(@NotNull FqName packageFqName, @NotNull TargetPlatform platform) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(platform, "platform");
        return this.doesPlatformSpecificPackageExist(packageFqName, platform) || this.doesKotlinOnlyPackageExist(packageFqName);
    }

    @Override
    public boolean doesPlatformSpecificPackageExist(@NotNull FqName packageFqName, @NotNull TargetPlatform platform) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(platform, "platform");
        if (JvmPlatformKt.isJvm(platform)) {
            String fqNameString = packageFqName.asString();
            Project project$iv = this.project;
            boolean $i$f$forEachNonKotlinPsiElementFinder = false;
            for (PsiElementFinder finder$iv : PsiElementFinder.EP.getPoint(project$iv).getExtensionList()) {
                if (Intrinsics.areEqual(finder$iv.getClass().getName(), "org.jetbrains.kotlin.asJava.finder.JavaElementFinder")) continue;
                Intrinsics.checkNotNull(finder$iv);
                PsiElementFinder finder = finder$iv;
                boolean bl = false;
                PsiPackage psiPackage = finder.findPackage(fqNameString);
                if (psiPackage == null) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    @NotNull
    public Set<Name> getSubPackageFqNames(@NotNull FqName packageFqName, @NotNull TargetPlatform platform, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Set set;
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(platform, "platform");
        Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
        Set $this$getSubPackageFqNames_u24lambda_u241 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$getSubPackageFqNames_u24lambda_u241.addAll(this.getKotlinOnlySubPackagesFqNames(packageFqName, nameFilter));
        $this$getSubPackageFqNames_u24lambda_u241.addAll(this.getPlatformSpecificSubPackagesFqNames(packageFqName, platform, nameFilter));
        return SetsKt.build(set);
    }

    @Override
    @NotNull
    public Set<Name> getPlatformSpecificSubPackagesFqNames(@NotNull FqName packageFqName, @NotNull TargetPlatform platform, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Set<Name> set;
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(platform, "platform");
        Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
        if (JvmPlatformKt.isJvm(platform)) {
            Set<Object> set2;
            String fqNameString = packageFqName.asString();
            Set<Object> $this$getPlatformSpecificSubPackagesFqNames_u24lambda_u243 = set2 = SetsKt.createSetBuilder();
            boolean bl = false;
            Project project$iv = this.project;
            boolean $i$f$forEachNonKotlinPsiElementFinder = false;
            for (PsiElementFinder finder$iv : PsiElementFinder.EP.getPoint(project$iv).getExtensionList()) {
                PsiPackage psiPackage;
                if (Intrinsics.areEqual(finder$iv.getClass().getName(), "org.jetbrains.kotlin.asJava.finder.JavaElementFinder")) continue;
                Intrinsics.checkNotNull(finder$iv);
                PsiElementFinder finder = finder$iv;
                boolean bl2 = false;
                if (finder.findPackage(fqNameString) == null) continue;
                for (PsiPackage subPackage : finder.getSubPackages(psiPackage, this.searchScope)) {
                    Object name;
                    Object object = subPackage.getName();
                    if (object == null) continue;
                    String p0 = object;
                    boolean bl3 = false;
                    Name name2 = Name.identifierIfValid(p0);
                    object = name2;
                    if (name2 == null || !nameFilter.invoke((Name)(name = object)).booleanValue()) continue;
                    $this$getPlatformSpecificSubPackagesFqNames_u24lambda_u243.add(name);
                }
            }
            set = SetsKt.build(set2);
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }
}

