/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.platform.projectStructure;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileResolutionMode;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0017\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0005\u001a\u00020\u00048\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0007\u001a\u00020\u00068\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\f8\u0016X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001b\u0010\u001dR \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u0012\u0004\b!\u0010\"R\u0014\u0010\u0003\u001a\u00020\u00028WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010(\u001a\u00020%8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010,\u001a\u00020)8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u00100\u001a\u00020-8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u001a\u00104\u001a\b\u0012\u0004\u0012\u00020\u0004018WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u0004018WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00103R\u001a\u00108\u001a\b\u0012\u0004\u0012\u00020\u0004018WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00103R\u001a\u0010:\u001a\b\u0012\u0004\u0012\u00020\u0004018WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u00103R\u0016\u0010<\u001a\u0004\u0018\u00010\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010$"}, d2={"Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KaDanglingFileModuleImpl;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileModule;", "Lorg/jetbrains/kotlin/psi/KtFile;", "file", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "contextModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileResolutionMode;", "resolutionMode", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileResolutionMode;)V", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "getContextModule", "()Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileResolutionMode;", "getResolutionMode", "()Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileResolutionMode;", "isCodeFragment", "Z", "()Z", "Lcom/intellij/psi/SmartPsiElementPointer;", "fileRef", "Lcom/intellij/psi/SmartPsiElementPointer;", "getFileRef$annotations", "()V", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "project", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "targetPlatform", "Lcom/intellij/psi/search/GlobalSearchScope;", "getContentScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "contentScope", "", "getDirectRegularDependencies", "()Ljava/util/List;", "directRegularDependencies", "getDirectDependsOnDependencies", "directDependsOnDependencies", "getDirectFriendDependencies", "directFriendDependencies", "getTransitiveDependsOnDependencies", "transitiveDependsOnDependencies", "getValidFileOrNull", "validFileOrNull"})
public final class KaDanglingFileModuleImpl
implements KaDanglingFileModule {
    @NotNull
    private final KaModule contextModule;
    @NotNull
    private final KaDanglingFileResolutionMode resolutionMode;
    private final boolean isCodeFragment;
    @NotNull
    private final SmartPsiElementPointer<KtFile> fileRef;

    public KaDanglingFileModuleImpl(@NotNull KtFile file2, @NotNull KaModule contextModule, @NotNull KaDanglingFileResolutionMode resolutionMode) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(contextModule, "contextModule");
        Intrinsics.checkNotNullParameter((Object)resolutionMode, "resolutionMode");
        this.contextModule = contextModule;
        this.resolutionMode = resolutionMode;
        this.isCodeFragment = file2 instanceof KtCodeFragment;
        this.fileRef = PsiUtilsKt.createSmartPointer((PsiElement)file2);
        if (!(!Intrinsics.areEqual(this.getContextModule(), this))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (this.getContextModule() instanceof KaDanglingFileModule && !(file2 instanceof KtCodeFragment)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
    }

    @Override
    @NotNull
    public KaModule getContextModule() {
        return this.contextModule;
    }

    @Override
    @NotNull
    public KaDanglingFileResolutionMode getResolutionMode() {
        return this.resolutionMode;
    }

    @Override
    public boolean isCodeFragment() {
        return this.isCodeFragment;
    }

    private static /* synthetic */ void getFileRef$annotations() {
    }

    @Override
    @NotNull
    public KtFile getFile() {
        KtFile ktFile = this.getValidFileOrNull();
        if (ktFile == null) {
            throw new IllegalStateException("Dangling file module is invalid".toString());
        }
        return ktFile;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.getContextModule().getProject();
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return this.getContextModule().getTargetPlatform();
    }

    @Override
    @NotNull
    public GlobalSearchScope getContentScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope(this.getFile());
        Intrinsics.checkNotNullExpressionValue(globalSearchScope, "fileScope(...)");
        return globalSearchScope;
    }

    @Override
    @NotNull
    public List<KaModule> getDirectRegularDependencies() {
        return this.getContextModule().getDirectRegularDependencies();
    }

    @Override
    @NotNull
    public List<KaModule> getDirectDependsOnDependencies() {
        return this.getContextModule().getDirectDependsOnDependencies();
    }

    @Override
    @NotNull
    public List<KaModule> getDirectFriendDependencies() {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf(this.getContextModule()), (Iterable)this.getContextModule().getDirectFriendDependencies());
    }

    @Override
    @NotNull
    public List<KaModule> getTransitiveDependsOnDependencies() {
        return this.getContextModule().getTransitiveDependsOnDependencies();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof KaDanglingFileModuleImpl) {
            KtFile selfFile = this.fileRef.getElement();
            KtFile otherFile = ((KaDanglingFileModuleImpl)other).fileRef.getElement();
            return selfFile != null && Intrinsics.areEqual(selfFile, otherFile) && Intrinsics.areEqual(this.getContextModule(), ((KaDanglingFileModuleImpl)other).getContextModule()) && this.getResolutionMode() == ((KaDanglingFileModuleImpl)other).getResolutionMode();
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.fileRef.getElement(), this.getContextModule()};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        Object object = this.getValidFileOrNull();
        if (object == null || (object = ((PsiFileImpl)object).getName()) == null) {
            object = "Invalid dangling file module";
        }
        return object;
    }

    private final KtFile getValidFileOrNull() {
        KtFile ktFile;
        KtFile ktFile2 = this.fileRef.getElement();
        if (ktFile2 != null) {
            KtFile ktFile3;
            KtFile it = ktFile3 = ktFile2;
            boolean bl = false;
            ktFile = it.isValid() ? ktFile3 : null;
        } else {
            ktFile = null;
        }
        return ktFile;
    }
}

