/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.platform.projectStructure;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KaDanglingFileModuleImpl;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProvider;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProviderBaseKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.ContextModuleKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.DanglingFilesKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileResolutionMode;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaNotUnderContentRootModule;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H%\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\tH\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinProjectStructureProviderBase;", "Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinProjectStructureProvider;", "<init>", "()V", "Lcom/intellij/openapi/project/Project;", "project", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaNotUnderContentRootModule;", "getNotUnderContentRootModule", "(Lcom/intellij/openapi/project/Project;)Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaNotUnderContentRootModule;", "Lcom/intellij/psi/PsiFile;", "file", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "computeSpecialModule", "(Lcom/intellij/psi/PsiFile;)Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileResolutionMode;", "computeDefaultDanglingFileResolutionMode", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileResolutionMode;", "computeContextModule", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;"})
public abstract class KotlinProjectStructureProviderBase
implements KotlinProjectStructureProvider {
    @NotNull
    protected abstract KaNotUnderContentRootModule getNotUnderContentRootModule(@NotNull Project var1);

    @Nullable
    protected final KaModule computeSpecialModule(@NotNull PsiFile file2) {
        KaModule contextModule;
        KaDanglingFileModule kaDanglingFileModule;
        KtCodeFragment ktCodeFragment;
        Intrinsics.checkNotNullParameter(file2, "file");
        KtCodeFragment ktCodeFragment2 = ktCodeFragment = file2 instanceof KtCodeFragment ? (KtCodeFragment)file2 : null;
        if (ktCodeFragment != null && (kaDanglingFileModule = KotlinProjectStructureProviderBaseKt.getForcedSpecialModule(ktCodeFragment)) != null) {
            KaDanglingFileModule it = kaDanglingFileModule;
            boolean bl = false;
            return it;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null && (contextModule = ContextModuleKt.getAnalysisContextModule(virtualFile)) != null) {
            return contextModule;
        }
        if (file2 instanceof KtFile && DanglingFilesKt.isDangling((KtFile)file2)) {
            contextModule = this.computeContextModule((KtFile)file2);
            KaDanglingFileResolutionMode kaDanglingFileResolutionMode = DanglingFilesKt.getDanglingFileResolutionMode((KtFile)file2);
            if (kaDanglingFileResolutionMode == null) {
                kaDanglingFileResolutionMode = this.computeDefaultDanglingFileResolutionMode((KtFile)file2);
            }
            KaDanglingFileResolutionMode resolutionMode = kaDanglingFileResolutionMode;
            return new KaDanglingFileModuleImpl((KtFile)file2, contextModule, resolutionMode);
        }
        return null;
    }

    private final KaDanglingFileResolutionMode computeDefaultDanglingFileResolutionMode(KtFile file2) {
        if (!(file2.isPhysical() || file2.getViewProvider().isEventSystemEnabled() || Intrinsics.areEqual(file2.getOriginalFile(), file2))) {
            return KaDanglingFileResolutionMode.IGNORE_SELF;
        }
        return KaDanglingFileResolutionMode.PREFER_SELF;
    }

    private final KaModule computeContextModule(KtFile file2) {
        PsiElement contextElement;
        KaModule kaModule;
        PsiFile originalFile;
        Object object = file2.getOriginalFile();
        PsiFile it = object;
        boolean bl = false;
        PsiFile psiFile = originalFile = it != file2 ? object : null;
        if (originalFile != null && (object = originalFile.getVirtualFile()) != null && (kaModule = ContextModuleKt.getAnalysisContextModule((VirtualFile)object)) != null) {
            KaModule it2 = kaModule;
            boolean bl2 = false;
            return it2;
        }
        object = DanglingFilesKt.getContextModule(file2);
        if (object != null) {
            Object it3 = object;
            boolean bl3 = false;
            return it3;
        }
        PsiElement psiElement = file2.getContext();
        if (psiElement == null && (psiElement = KtPsiFactoryKt.getAnalysisContext(file2)) == null) {
            psiElement = originalFile;
        }
        if ((contextElement = psiElement) != null) {
            return this.getModule(contextElement, null);
        }
        Project project = file2.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
        return this.getNotUnderContentRootModule(project);
    }
}

