/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.standalone.base.declarations;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinAnnotationsResolver;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDeclarationProvider;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDeclarationProviderFactoryKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\f\u001a\u00020\u000bH\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u0011\u001a\u00020\u000eH\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\u0004\u0018\u00010\u0014*\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u001b\u0010\u001d\u001a\u00020\u00188BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R!\u0010%\u001a\b\u0012\u0004\u0012\u00020!0\u001e8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u001a\u001a\u0004\b#\u0010$"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneAnnotationsResolver;", "Lorg/jetbrains/kotlin/analysis/api/platform/declarations/KotlinAnnotationsResolver;", "Lcom/intellij/openapi/project/Project;", "project", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "ktFiles", "Lcom/intellij/psi/search/GlobalSearchScope;", "scope", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Lcom/intellij/psi/search/GlobalSearchScope;)V", "Lorg/jetbrains/kotlin/name/ClassId;", "annotationClassId", "", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "declarationsByAnnotation", "(Lorg/jetbrains/kotlin/name/ClassId;)Ljava/util/Set;", "declaration", "annotationsOnDeclaration", "(Lorg/jetbrains/kotlin/psi/KtAnnotated;)Ljava/util/Set;", "Lorg/jetbrains/kotlin/psi/KtClass;", "resolveToAnnotation", "(Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/psi/KtClass;", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/kotlin/analysis/api/platform/declarations/KotlinDeclarationProvider;", "declarationProvider$delegate", "Lkotlin/Lazy;", "getDeclarationProvider", "()Lorg/jetbrains/kotlin/analysis/api/platform/declarations/KotlinDeclarationProvider;", "declarationProvider", "", "filesInScope", "Ljava/util/List;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "allDeclarations$delegate", "getAllDeclarations", "()Ljava/util/List;", "allDeclarations"})
final class KotlinStandaloneAnnotationsResolver
implements KotlinAnnotationsResolver {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy declarationProvider$delegate;
    @NotNull
    private final List<KtFile> filesInScope;
    @NotNull
    private final Lazy allDeclarations$delegate;

    /*
     * WARNING - void declaration
     */
    public KotlinStandaloneAnnotationsResolver(@NotNull Project project, @NotNull Collection<? extends KtFile> ktFiles, @NotNull GlobalSearchScope scope2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(ktFiles, "ktFiles");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        this.project = project;
        this.declarationProvider$delegate = LazyKt.lazy(() -> KotlinStandaloneAnnotationsResolver.declarationProvider_delegate$lambda$0(this, scope2));
        Iterable iterable = ktFiles;
        KotlinStandaloneAnnotationsResolver kotlinStandaloneAnnotationsResolver = this;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!scope2.contains(it.getVirtualFile())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        kotlinStandaloneAnnotationsResolver.filesInScope = (List)destination$iv$iv;
        this.allDeclarations$delegate = LazyKt.lazy(() -> KotlinStandaloneAnnotationsResolver.allDeclarations_delegate$lambda$4(this));
    }

    private final KotlinDeclarationProvider getDeclarationProvider() {
        Lazy lazy = this.declarationProvider$delegate;
        return (KotlinDeclarationProvider)lazy.getValue();
    }

    private final List<KtDeclaration> getAllDeclarations() {
        Lazy lazy = this.allDeclarations$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public Set<KtAnnotated> declarationsByAnnotation(@NotNull ClassId annotationClassId) {
        Intrinsics.checkNotNullParameter(annotationClassId, "annotationClassId");
        return SequencesKt.toSet(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.getAllDeclarations()), arg_0 -> KotlinStandaloneAnnotationsResolver.declarationsByAnnotation$lambda$5(this, annotationClassId, arg_0)));
    }

    @Override
    @NotNull
    public Set<ClassId> annotationsOnDeclaration(@NotNull KtAnnotated declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        List<KtAnnotationEntry> list = declaration.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue(list, "getAnnotationEntries(...)");
        return SequencesKt.toSet(SequencesKt.filter(SequencesKt.map(SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)list), KotlinStandaloneAnnotationsResolver::annotationsOnDeclaration$lambda$6), KotlinStandaloneAnnotationsResolver::annotationsOnDeclaration$lambda$7), arg_0 -> KotlinStandaloneAnnotationsResolver.annotationsOnDeclaration$lambda$8(this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final KtClass resolveToAnnotation(ClassId $this$resolveToAnnotation) {
        List list;
        Collection<KtClassOrObject> classes2;
        Collection<KtClassOrObject> $this$filterIsInstanceAnd$iv = classes2 = this.getDeclarationProvider().getAllClassesByClassId($this$resolveToAnnotation);
        boolean $i$f$filterIsInstanceAnd = false;
        if ($this$filterIsInstanceAnd$iv.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$filterIsInstanceAndTo$iv$iv;
            Iterable iterable = $this$filterIsInstanceAnd$iv;
            Collection destination$iv$iv = new SmartList();
            boolean $i$f$filterIsInstanceAndTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceAndTo$iv$iv) {
                if (!(element$iv$iv instanceof KtClass)) continue;
                KtClass it = (KtClass)element$iv$iv;
                boolean bl = false;
                if (!it.isAnnotation()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List annotations2 = list;
        return (KtClass)CollectionsKt.singleOrNull(annotations2);
    }

    private static final KotlinDeclarationProvider declarationProvider_delegate$lambda$0(KotlinStandaloneAnnotationsResolver this$0, GlobalSearchScope $scope) {
        return KotlinDeclarationProviderFactoryKt.createDeclarationProvider(this$0.project, $scope, null);
    }

    private static final Unit allDeclarations_delegate$lambda$4$lambda$2(List $result, KtDeclaration it) {
        boolean bl;
        Intrinsics.checkNotNullParameter(it, "it");
        KtDeclaration ktDeclaration = it;
        if (ktDeclaration instanceof KtClassOrObject) {
            bl = ((KtClassOrObject)it).isLocal();
        } else if (ktDeclaration instanceof KtFunction) {
            bl = ((KtFunction)it).isLocal();
        } else if (ktDeclaration instanceof KtProperty) {
            bl = ((KtProperty)it).isLocal();
        } else {
            return Unit.INSTANCE;
        }
        boolean isLocal = bl;
        if (!isLocal) {
            ((Collection)$result).add(it);
        }
        return Unit.INSTANCE;
    }

    private static final List allDeclarations_delegate$lambda$4(KotlinStandaloneAnnotationsResolver this$0) {
        List result2 = new ArrayList();
        KtTreeVisitorVoid visitor2 = VisitorWrappersKt.declarationRecursiveVisitor(arg_0 -> KotlinStandaloneAnnotationsResolver.allDeclarations_delegate$lambda$4$lambda$2(result2, arg_0));
        Iterable $this$forEach$iv = this$0.filesInScope;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtFile it = (KtFile)element$iv;
            boolean bl = false;
            it.accept(visitor2);
        }
        return result2;
    }

    private static final boolean declarationsByAnnotation$lambda$5(KotlinStandaloneAnnotationsResolver this$0, ClassId $annotationClassId, KtDeclaration it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.annotationsOnDeclaration(it).contains($annotationClassId);
    }

    private static final String annotationsOnDeclaration$lambda$6(KtAnnotationEntry it) {
        KtTypeReference ktTypeReference = it.getTypeReference();
        return ktTypeReference != null ? ktTypeReference.getText() : null;
    }

    private static final ClassId annotationsOnDeclaration$lambda$7(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ClassId.Companion.topLevel(new FqName(it));
    }

    private static final boolean annotationsOnDeclaration$lambda$8(KotlinStandaloneAnnotationsResolver this$0, ClassId it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.resolveToAnnotation(it) != null;
    }
}

