/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.standalone.base.declarations;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.utils.TypeUtilsKt;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDeclarationProviderFactory;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDirectInheritorsProvider;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProvider;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.standalone.base.declarations.KotlinStandaloneDeclarationProviderFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCache;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ)\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010 *\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010#R\u001b\u0010)\u001a\u00020$8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010("}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneFirDirectInheritorsProvider;", "Lorg/jetbrains/kotlin/analysis/api/platform/declarations/KotlinDirectInheritorsProvider;", "Lcom/intellij/openapi/project/Project;", "project", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "Lorg/jetbrains/kotlin/psi/KtClass;", "ktClass", "Lcom/intellij/psi/search/GlobalSearchScope;", "scope", "", "includeLocalInheritors", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getDirectKotlinInheritors", "(Lorg/jetbrains/kotlin/psi/KtClass;Lcom/intellij/psi/search/GlobalSearchScope;Z)Ljava/lang/Iterable;", "Lorg/jetbrains/kotlin/name/Name;", "aliasedName", "", "aliases", "", "calculateAliases", "(Lorg/jetbrains/kotlin/name/Name;Ljava/util/Set;)V", "candidate", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "baseFirClass", "isValidInheritor", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lcom/intellij/psi/search/GlobalSearchScope;Z)Z", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "ktModule", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "toFirSymbol", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory;", "standaloneDeclarationProviderFactory$delegate", "Lkotlin/Lazy;", "getStandaloneDeclarationProviderFactory", "()Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory;", "standaloneDeclarationProviderFactory"})
public final class KotlinStandaloneFirDirectInheritorsProvider
implements KotlinDirectInheritorsProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy standaloneDeclarationProviderFactory$delegate;

    public KotlinStandaloneFirDirectInheritorsProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.project = project;
        this.standaloneDeclarationProviderFactory$delegate = LazyKt.lazy(() -> KotlinStandaloneFirDirectInheritorsProvider.standaloneDeclarationProviderFactory_delegate$lambda$0(this));
    }

    private final KotlinStandaloneDeclarationProviderFactory getStandaloneDeclarationProviderFactory() {
        Lazy lazy = this.standaloneDeclarationProviderFactory$delegate;
        return (KotlinStandaloneDeclarationProviderFactory)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<KtClassOrObject> getDirectKotlinInheritors(@NotNull KtClass ktClass, @NotNull GlobalSearchScope scope2, boolean includeLocalInheritors) {
        void $this$filterTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ktClass, "ktClass");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        ClassId classId = ktClass.getClassId();
        if (classId == null) {
            return CollectionsKt.emptyList();
        }
        ClassId classId2 = classId;
        Name[] nameArray = new Name[]{classId2.getShortClassName()};
        Set<Name> aliases = SetsKt.mutableSetOf(nameArray);
        this.calculateAliases(classId2.getShortClassName(), aliases);
        Iterable $this$flatMap$iv = aliases;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Name it = (Name)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getStandaloneDeclarationProviderFactory().getDirectInheritorCandidates(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List possibleInheritors = (List)destination$iv$iv;
        if (possibleInheritors.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        KaModule ktModule = KotlinProjectStructureProvider.Companion.getModule(this.project, ktClass, null);
        KaModule baseKtModule = ktModule instanceof KaDanglingFileModule ? ((KaDanglingFileModule)ktModule).getContextModule() : ktModule;
        FirClassLikeSymbol<?> firClassLikeSymbol = this.toFirSymbol(ktClass, classId2, baseKtModule);
        destination$iv$iv = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        FirClass firClass = destination$iv$iv instanceof FirClass ? (FirClass)destination$iv$iv : null;
        if (firClass == null) {
            return CollectionsKt.emptyList();
        }
        FirClass baseFirClass = firClass;
        Iterable $this$filter$iv = possibleInheritors;
        boolean $i$f$filter = false;
        Iterable $i$f$flatMapTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtClassOrObject it = (KtClassOrObject)element$iv$iv;
            boolean bl = false;
            if (!this.isValidInheritor(it, baseFirClass, scope2, includeLocalInheritors)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private final void calculateAliases(Name aliasedName, Set<Name> aliases) {
        Iterable $this$forEach$iv = this.getStandaloneDeclarationProviderFactory().getInheritableTypeAliases(aliasedName);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Name aliasName;
            KtTypeAlias alias = (KtTypeAlias)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(alias.getNameAsSafeName(), "getNameAsSafeName(...)");
            boolean isNewAliasName = aliases.add(aliasName);
            if (!isNewAliasName) continue;
            this.calculateAliases(aliasName, aliases);
        }
    }

    private final boolean isValidInheritor(KtClassOrObject candidate, FirClass baseFirClass, GlobalSearchScope scope2, boolean includeLocalInheritors) {
        if (!includeLocalInheritors && candidate.isLocal()) {
            return false;
        }
        if (!PsiUtilsKt.contains(scope2, candidate)) {
            return false;
        }
        ClassId classId = candidate.getClassId();
        if (classId == null) {
            return false;
        }
        ClassId candidateClassId = classId;
        KaModule candidateKtModule = KotlinProjectStructureProvider.Companion.getModule(this.project, candidate, null);
        FirClassLikeSymbol<?> firClassLikeSymbol = this.toFirSymbol(candidate, candidateClassId, candidateKtModule);
        if (firClassLikeSymbol == null) {
            return false;
        }
        FirClassLikeSymbol<?> candidateFirSymbol = firClassLikeSymbol;
        Object e = candidateFirSymbol.getFir();
        FirClass firClass = e instanceof FirClass ? (FirClass)e : null;
        if (firClass == null) {
            return false;
        }
        FirClass candidateFirClass = firClass;
        return TypeUtilsKt.isSubclassOf(candidateFirClass, baseFirClass, candidateFirClass.getModuleData().getSession(), false);
    }

    private final FirClassLikeSymbol<?> toFirSymbol(KtClassOrObject $this$toFirSymbol, ClassId classId, KaModule ktModule) {
        Project project = $this$toFirSymbol.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
        LLFirSession session = LLFirSessionCache.Companion.getInstance(project).getSession(ktModule, true);
        return FirSymbolProviderKt.getSymbolProvider(session).getClassLikeSymbolByClassId(classId);
    }

    private static final KotlinStandaloneDeclarationProviderFactory standaloneDeclarationProviderFactory_delegate$lambda$0(KotlinStandaloneFirDirectInheritorsProvider this$0) {
        KotlinDeclarationProviderFactory kotlinDeclarationProviderFactory = KotlinDeclarationProviderFactory.Companion.getInstance(this$0.project);
        KotlinStandaloneDeclarationProviderFactory kotlinStandaloneDeclarationProviderFactory = kotlinDeclarationProviderFactory instanceof KotlinStandaloneDeclarationProviderFactory ? (KotlinStandaloneDeclarationProviderFactory)kotlinDeclarationProviderFactory : null;
        if (kotlinStandaloneDeclarationProviderFactory == null) {
            throw new IllegalStateException(('`' + Reflection.getOrCreateKotlinClass(KotlinStandaloneFirDirectInheritorsProvider.class).getSimpleName() + "` expects the following declaration provider factory to be registered: `" + Reflection.getOrCreateKotlinClass(KotlinStandaloneDeclarationProviderFactory.class).getSimpleName() + '`').toString());
        }
        return kotlinStandaloneDeclarationProviderFactory;
    }
}

