/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiled.light.classes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiled.light.classes.ClsJavaStubByVirtualFileCache;
import org.jetbrains.kotlin.analysis.decompiled.light.classes.KtLightClassForDecompiledDeclaration;
import org.jetbrains.kotlin.analysis.decompiled.light.classes.KtLightClassForDecompiledFacade;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtClsFile;
import org.jetbrains.kotlin.asJava.builder.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014JI\u0010\u0013\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00112 \u0010\u0018\u001a\u001c\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00028\u00000\u0016H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0019J/\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u000e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J3\u0010&\u001a\u0004\u0018\u00010%2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b&\u0010'R\u0014\u0010+\u001a\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/DecompiledLightClassesFactory;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "decompiledClassOrObject", "Lcom/intellij/openapi/project/Project;", "project", "Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/KtLightClassForDecompiledDeclaration;", "getLightClassForDecompiledClassOrObject", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lcom/intellij/openapi/project/Project;)Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/KtLightClassForDecompiledDeclaration;", "rootLightClassForDecompiledFile", "findCorrespondingLightClass", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/KtLightClassForDecompiledDeclaration;)Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/KtLightClassForDecompiledDeclaration;", "Lorg/jetbrains/kotlin/name/FqName;", "getClassRelativeName", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;)Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/file/KtClsFile;", "file", "createLightClassForDecompiledKotlinFile", "(Lorg/jetbrains/kotlin/analysis/decompiler/psi/file/KtClsFile;Lcom/intellij/openapi/project/Project;)Lorg/jetbrains/kotlin/analysis/decompiled/light/classes/KtLightClassForDecompiledDeclaration;", "T", "Lkotlin/Function3;", "Lcom/intellij/psi/PsiClass;", "builder", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/analysis/decompiler/psi/file/KtClsFile;Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "facadeClassFqName", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "files", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClassForFacade;", "createLightFacadeForDecompiledKotlinFile", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/name/FqName;Ljava/util/List;)Lorg/jetbrains/kotlin/asJava/classes/KtLightClassForFacade;", "mirrorFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "classFile", "correspondingClassOrObject", "Lcom/intellij/psi/impl/compiled/ClsClassImpl;", "createClsJavaClassFromVirtualFile", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lcom/intellij/openapi/project/Project;)Lcom/intellij/psi/impl/compiled/ClsClassImpl;", "", "getCheckInconsistency", "()Z", "checkInconsistency"})
public final class DecompiledLightClassesFactory {
    @NotNull
    public static final DecompiledLightClassesFactory INSTANCE = new DecompiledLightClassesFactory();

    private DecompiledLightClassesFactory() {
    }

    private final boolean getCheckInconsistency() {
        return Registry.is("kotlin.decompiled.light.classes.check.inconsistency", false);
    }

    @Nullable
    public final KtLightClassForDecompiledDeclaration getLightClassForDecompiledClassOrObject(@NotNull KtClassOrObject decompiledClassOrObject, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(decompiledClassOrObject, "decompiledClassOrObject");
        Intrinsics.checkNotNullParameter(project, "project");
        if (decompiledClassOrObject instanceof KtEnumEntry) {
            return null;
        }
        PsiFile psiFile = decompiledClassOrObject.getContainingFile();
        KtClsFile ktClsFile = psiFile instanceof KtClsFile ? (KtClsFile)psiFile : null;
        if (ktClsFile == null) {
            return null;
        }
        KtClsFile containingKtFile = ktClsFile;
        KtLightClassForDecompiledDeclaration ktLightClassForDecompiledDeclaration = this.createLightClassForDecompiledKotlinFile(containingKtFile, project);
        if (ktLightClassForDecompiledDeclaration == null) {
            return null;
        }
        KtLightClassForDecompiledDeclaration rootLightClassForDecompiledFile = ktLightClassForDecompiledDeclaration;
        return this.findCorrespondingLightClass(decompiledClassOrObject, rootLightClassForDecompiledFile);
    }

    /*
     * WARNING - void declaration
     */
    private final KtLightClassForDecompiledDeclaration findCorrespondingLightClass(KtClassOrObject decompiledClassOrObject, KtLightClassForDecompiledDeclaration rootLightClassForDecompiledFile) {
        FqName fqName2 = this.getClassRelativeName(decompiledClassOrObject);
        if (fqName2 == null) {
            return null;
        }
        FqName relativeFqName = fqName2;
        Iterator<Name> iterator2 = relativeFqName.pathSegments().iterator();
        Name base = iterator2.next();
        if (!Intrinsics.areEqual(rootLightClassForDecompiledFile.getName(), base.asString())) {
            return null;
        }
        KtLightClassForDecompiledDeclaration current = rootLightClassForDecompiledFile;
        while (iterator2.hasNext()) {
            Name name = iterator2.next();
            String string2 = name.asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            PsiClass innerClass = current.findInnerClassByName(string2, false);
            PsiClass psiClass = innerClass;
            if (psiClass == null) {
                if (this.getCheckInconsistency()) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    PsiClass[] psiClassArray = current.getInnerClasses();
                    String string3 = "innerClasses.txt";
                    KotlinExceptionWithAttachments kotlinExceptionWithAttachments = new KotlinExceptionWithAttachments("Could not find corresponding inner/nested class").withAttachment("relativeFqName.txt", relativeFqName).withAttachment("decompiledClassOrObjectFqName.txt", decompiledClassOrObject.getFqName()).withAttachment("decompiledFileName.txt", decompiledClassOrObject.getContainingKtFile().getVirtualFile().getName()).withPsiAttachment("decompiledClassOrObject.txt", decompiledClassOrObject).withAttachment("fileClass.txt", Reflection.getOrCreateKotlinClass(decompiledClassOrObject.getContainingFile().getClass())).withPsiAttachment("file.txt", decompiledClassOrObject.getContainingFile()).withPsiAttachment("root.txt", rootLightClassForDecompiledFile).withAttachment("currentName.txt", current.getName()).withPsiAttachment("current.txt", current);
                    boolean $i$f$map = false;
                    void var11_13 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void psiClass2;
                        void item$iv$iv;
                        void var17_19 = item$iv$iv = $this$mapTo$iv$iv[i];
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(psiClass2.getName());
                    }
                    collection = (List)destination$iv$iv;
                    throw kotlinExceptionWithAttachments.withAttachment(string3, collection).withAttachment("innerName.txt", name.asString());
                }
                return null;
            }
            current = (KtLightClassForDecompiledDeclaration)psiClass;
        }
        return current;
    }

    private final FqName getClassRelativeName(KtClassOrObject decompiledClassOrObject) {
        Name name = decompiledClassOrObject.getNameAsName();
        if (name == null) {
            return null;
        }
        Name name2 = name;
        KtClassOrObject parent2 = PsiTreeUtil.getParentOfType((PsiElement)decompiledClassOrObject, KtClassOrObject.class, true);
        if (parent2 == null) {
            boolean bl = decompiledClassOrObject.isTopLevel();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return FqName.Companion.topLevel(name2);
        }
        FqName fqName2 = this.getClassRelativeName(parent2);
        return fqName2 != null ? fqName2.child(name2) : null;
    }

    @Nullable
    public final KtLightClassForDecompiledDeclaration createLightClassForDecompiledKotlinFile(@NotNull KtClsFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(project, "project");
        return this.createLightClassForDecompiledKotlinFile(project, file2, DecompiledLightClassesFactory::createLightClassForDecompiledKotlinFile$lambda$1);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T createLightClassForDecompiledKotlinFile(Project project, KtClsFile file2, Function3<? super KtClsFile, ? super PsiClass, ? super KtClassOrObject, ? extends T> builder2) {
        void $this$filterIsInstanceTo$iv$iv;
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Iterable $this$filterIsInstance$iv = file2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtClassOrObject)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        KtClassOrObject classOrObject = (KtClassOrObject)CollectionsKt.singleOrNull((List)destination$iv$iv);
        ClsClassImpl clsClassImpl = this.createClsJavaClassFromVirtualFile(file2, virtualFile2, classOrObject, project);
        if (clsClassImpl == null) {
            return null;
        }
        ClsClassImpl javaClsClass = clsClassImpl;
        return builder2.invoke(file2, javaClsClass, classOrObject);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KtLightClassForFacade createLightFacadeForDecompiledKotlinFile(@NotNull Project project, @NotNull FqName facadeClassFqName, @NotNull List<? extends KtFile> files2) {
        Object v1;
        block8: {
            boolean $this$all$iv2;
            block7: {
                boolean bl;
                Intrinsics.checkNotNullParameter(project, "project");
                Intrinsics.checkNotNullParameter(facadeClassFqName, "facadeClassFqName");
                Intrinsics.checkNotNullParameter(files2, "files");
                Iterable $this$all$iv2 = files2;
                boolean $i$f$all = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        KtFile p0 = (KtFile)element$iv;
                        boolean bl2 = false;
                        if (p0.isCompiled()) continue;
                        bl = false;
                        break block7;
                    }
                    bl = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            Iterable $this$firstOrNull$iv = files2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtFile it = (KtFile)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(JvmFileClassUtilKt.getJavaFileFacadeFqName(it), facadeClassFqName)) continue;
                v1 = element$iv;
                break block8;
            }
            v1 = null;
        }
        Object object = v1;
        KtClsFile ktClsFile = object instanceof KtClsFile ? (KtClsFile)object : null;
        if (ktClsFile == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            object = files2;
            StringBuilder stringBuilder = new StringBuilder().append("Can't find the representative decompiled file for ").append(facadeClassFqName).append(" in ");
            boolean $i$f$map = false;
            void $i$f$firstOrNull = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtFile ktFile = (KtFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            object = stringBuilder.append((List)destination$iv$iv).toString();
            throw new IllegalStateException(object.toString());
        }
        KtClsFile file2 = ktClsFile;
        return this.createLightClassForDecompiledKotlinFile(project, file2, (arg_0, arg_1, arg_2) -> DecompiledLightClassesFactory.createLightFacadeForDecompiledKotlinFile$lambda$4(files2, arg_0, arg_1, arg_2));
    }

    @Nullable
    public final ClsClassImpl createClsJavaClassFromVirtualFile(@NotNull KtFile mirrorFile, @NotNull VirtualFile classFile, @Nullable KtClassOrObject correspondingClassOrObject, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(mirrorFile, "mirrorFile");
        Intrinsics.checkNotNullParameter(classFile, "classFile");
        Intrinsics.checkNotNullParameter(project, "project");
        PsiJavaFileStubImpl psiJavaFileStubImpl = ClsJavaStubByVirtualFileCache.Companion.getInstance(project).get(classFile);
        if (psiJavaFileStubImpl == null) {
            return null;
        }
        PsiJavaFileStubImpl javaFileStub = psiJavaFileStubImpl;
        javaFileStub.setPsiFactory(ClsWrapperStubPsiFactory.INSTANCE);
        PsiManager psiManager = PsiManager.getInstance(mirrorFile.getProject());
        Intrinsics.checkNotNullExpressionValue(psiManager, "getInstance(...)");
        PsiManager manager = psiManager;
        ClassFileViewProvider classFileViewProvider = new ClassFileViewProvider(manager, classFile);
        ClsFileImpl fakeFile2 = new ClsFileImpl(correspondingClassOrObject, javaFileStub, mirrorFile, classFileViewProvider){
            final /* synthetic */ KtClassOrObject $correspondingClassOrObject;
            final /* synthetic */ PsiJavaFileStubImpl $javaFileStub;
            final /* synthetic */ KtFile $mirrorFile;
            {
                this.$correspondingClassOrObject = $correspondingClassOrObject;
                this.$javaFileStub = $javaFileStub;
                this.$mirrorFile = $mirrorFile;
                super($super_call_param$1);
            }

            public PsiElement getNavigationElement() {
                if (this.$correspondingClassOrObject != null) {
                    PsiFile psiFile = this.$correspondingClassOrObject.getNavigationElement().getContainingFile();
                    Intrinsics.checkNotNullExpressionValue(psiFile, "getContainingFile(...)");
                    return psiFile;
                }
                PsiElement psiElement = super.getNavigationElement();
                Intrinsics.checkNotNullExpressionValue(psiElement, "getNavigationElement(...)");
                return psiElement;
            }

            public PsiJavaFileStubImpl getStub() {
                return this.$javaFileStub;
            }

            public KtFile getMirror() {
                return this.$mirrorFile;
            }

            public boolean isPhysical() {
                return false;
            }
        };
        javaFileStub.setPsi((PsiFile)fakeFile2);
        PsiClass[] psiClassArray = fakeFile2.getClasses();
        Intrinsics.checkNotNullExpressionValue(psiClassArray, "getClasses(...)");
        Object object = ArraysKt.single((Object[])psiClassArray);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type com.intellij.psi.impl.compiled.ClsClassImpl");
        return (ClsClassImpl)object;
    }

    private static final KtLightClassForDecompiledDeclaration createLightClassForDecompiledKotlinFile$lambda$1(KtClsFile kotlinClsFile, PsiClass javaClsClass, KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter(kotlinClsFile, "kotlinClsFile");
        Intrinsics.checkNotNullParameter(javaClsClass, "javaClsClass");
        PsiElement psiElement = javaClsClass.getParent();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getParent(...)");
        return new KtLightClassForDecompiledDeclaration(javaClsClass, psiElement, kotlinClsFile, classOrObject);
    }

    private static final KtLightClassForDecompiledFacade createLightFacadeForDecompiledKotlinFile$lambda$4(List $files, KtClsFile kotlinClsFile, PsiClass javaClsClass, KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter(kotlinClsFile, "kotlinClsFile");
        Intrinsics.checkNotNullParameter(javaClsClass, "javaClsClass");
        PsiElement psiElement = javaClsClass.getParent();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getParent(...)");
        return new KtLightClassForDecompiledFacade(javaClsClass, psiElement, kotlinClsFile, classOrObject, $files);
    }
}

