/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.konan;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibLoadingMetadataCache;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.library.metadata.KlibMetadataVersion;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.deserialization.ClassDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b6\u0018\u0000 \u00042\u00020\u0001:\u0003\u0005\u0006\u0004B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0007\b"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata;", "", "<init>", "()V", "Companion", "Incompatible", "Compatible", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata$Compatible;", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata$Incompatible;"})
public abstract class FileWithMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private FileWithMetadata() {
    }

    public /* synthetic */ FileWithMetadata(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata$Companion;", "", "<init>", "()V", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageFragment", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata;", "forPackageFragment", "(Lcom/intellij/openapi/vfs/VirtualFile;)Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata;"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final FileWithMetadata forPackageFragment(@NotNull VirtualFile packageFragment) {
            Intrinsics.checkNotNullParameter(packageFragment, "packageFragment");
            KlibLoadingMetadataCache klibMetadataLoadingCache = KlibLoadingMetadataCache.Companion.getInstance();
            Pair<ProtoBuf.PackageFragment, KlibMetadataVersion> pair = klibMetadataLoadingCache.getCachedPackageFragmentWithVersion(packageFragment);
            ProtoBuf.PackageFragment fragment = pair.component1();
            KlibMetadataVersion version = pair.component2();
            if (fragment == null || version == null) {
                return null;
            }
            return new Compatible(fragment, version);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u00020\u000e8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0014\u001a\u00020\u00138\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata$Compatible;", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "proto", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "version", "<init>", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;)V", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "getProto", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "getNameResolver", "()Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "classesToDecompile", "Ljava/util/List;", "getClassesToDecompile", "()Ljava/util/List;"})
    public static class Compatible
    extends FileWithMetadata {
        @NotNull
        private final ProtoBuf.PackageFragment proto;
        @NotNull
        private final BinaryVersion version;
        @NotNull
        private final NameResolverImpl nameResolver;
        @NotNull
        private final FqName packageFqName;
        @NotNull
        private final List<ProtoBuf.Class> classesToDecompile;

        /*
         * WARNING - void declaration
         */
        public Compatible(@NotNull ProtoBuf.PackageFragment proto, @NotNull BinaryVersion version) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter(proto, "proto");
            Intrinsics.checkNotNullParameter(version, "version");
            super(null);
            this.proto = proto;
            this.version = version;
            ProtoBuf.StringTable stringTable = this.proto.getStrings();
            Intrinsics.checkNotNullExpressionValue(stringTable, "getStrings(...)");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = this.proto.getQualifiedNames();
            Intrinsics.checkNotNullExpressionValue(qualifiedNameTable, "getQualifiedNames(...)");
            this.nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
            String string2 = this.proto.getExtension(KlibMetadataProtoBuf.fqName);
            Intrinsics.checkNotNullExpressionValue(string2, "getExtension(...)");
            this.packageFqName = new FqName(string2);
            List<ProtoBuf.Class> list = this.proto.getClass_List();
            Intrinsics.checkNotNullExpressionValue(list, "getClass_List(...)");
            Iterable iterable = list;
            Compatible compatible = this;
            boolean $i$f$filter = false;
            void var5_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProtoBuf.Class proto2 = (ProtoBuf.Class)element$iv$iv;
                boolean bl = false;
                ClassId classId = NameResolverUtilKt.getClassId(this.nameResolver, proto2.getFqName());
                if (!(!classId.isNestedClass() && !ClassDeserializer.Companion.getBLACK_LIST().contains(classId))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            compatible.classesToDecompile = (List)destination$iv$iv;
        }

        @NotNull
        public final ProtoBuf.PackageFragment getProto() {
            return this.proto;
        }

        @NotNull
        public final BinaryVersion getVersion() {
            return this.version;
        }

        @NotNull
        public final NameResolverImpl getNameResolver() {
            return this.nameResolver;
        }

        @NotNull
        public final FqName getPackageFqName() {
            return this.packageFqName;
        }

        @NotNull
        public List<ProtoBuf.Class> getClassesToDecompile() {
            return this.classesToDecompile;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata$Incompatible;", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata;", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "version", "<init>", "(Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;)V", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;"})
    public static final class Incompatible
    extends FileWithMetadata {
        @NotNull
        private final BinaryVersion version;

        public Incompatible(@NotNull BinaryVersion version) {
            Intrinsics.checkNotNullParameter(version, "version");
            super(null);
            this.version = version;
        }

        @NotNull
        public final BinaryVersion getVersion() {
            return this.version;
        }
    }
}

