/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.konan;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.indexing.FileContent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.konan.FileWithMetadata;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibMetadataStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.konan.NearFileClassDataFinder;
import org.jetbrains.kotlin.analysis.decompiler.stub.CallableClsStubBuilderKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClassClsStubBuilderKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderComponents;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.AnnotationLoaderForStubBuilderImpl;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.AnnotationLoader;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoBasedClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J#\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0018R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0019"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/konan/K2KlibMetadataStubBuilder;", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataStubBuilder;", "", "version", "Lcom/intellij/openapi/fileTypes/FileType;", "fileType", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "serializerProtocol", "Lkotlin/Function1;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata;", "readFile", "<init>", "(ILcom/intellij/openapi/fileTypes/FileType;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "getStubVersion", "()I", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata$Compatible;", "fileWithMetadata", "Lcom/intellij/util/indexing/FileContent;", "fileContent", "Lcom/intellij/psi/stubs/PsiFileStub;", "buildMetadataFileStub", "(Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata$Compatible;Lcom/intellij/util/indexing/FileContent;)Lcom/intellij/psi/stubs/PsiFileStub;", "I", "Lkotlin/jvm/functions/Function0;"})
public final class K2KlibMetadataStubBuilder
extends KlibMetadataStubBuilder {
    private final int version;
    @NotNull
    private final Function0<SerializerExtensionProtocol> serializerProtocol;

    public K2KlibMetadataStubBuilder(int version, @NotNull FileType fileType, @NotNull Function0<? extends SerializerExtensionProtocol> serializerProtocol, @NotNull Function1<? super VirtualFile, ? extends FileWithMetadata> readFile) {
        Intrinsics.checkNotNullParameter(fileType, "fileType");
        Intrinsics.checkNotNullParameter(serializerProtocol, "serializerProtocol");
        Intrinsics.checkNotNullParameter(readFile, "readFile");
        super(version, fileType, readFile);
        this.version = version;
        this.serializerProtocol = serializerProtocol;
    }

    @Override
    public int getStubVersion() {
        return this.version;
    }

    @Override
    @NotNull
    protected PsiFileStub<?> buildMetadataFileStub(@NotNull FileWithMetadata.Compatible fileWithMetadata, @NotNull FileContent fileContent) {
        Intrinsics.checkNotNullParameter(fileWithMetadata, "fileWithMetadata");
        Intrinsics.checkNotNullParameter(fileContent, "fileContent");
        ProtoBuf.Package packageProto = fileWithMetadata.getProto().getPackage();
        FqName packageFqName = fileWithMetadata.getPackageFqName();
        NameResolverImpl nameResolver = fileWithMetadata.getNameResolver();
        ProtoBasedClassDataFinder mainClassDataFinder = new ProtoBasedClassDataFinder(fileWithMetadata.getProto(), nameResolver, fileWithMetadata.getVersion(), null, 8, null);
        SerializerExtensionProtocol protocol = this.serializerProtocol.invoke();
        ClassDataFinder classDataFinder2 = mainClassDataFinder;
        VirtualFile virtualFile = fileContent.getFile();
        Intrinsics.checkNotNullExpressionValue(virtualFile, "getFile(...)");
        ClassDataFinder classDataFinder3 = NearFileClassDataFinder.Companion.wrapIfNeeded(classDataFinder2, virtualFile, this.getReadFile());
        AnnotationLoader annotationLoader = new AnnotationLoaderForStubBuilderImpl(protocol);
        VirtualFile virtualFile2 = fileContent.getFile();
        Intrinsics.checkNotNullExpressionValue(virtualFile2, "getFile(...)");
        ClsStubBuilderComponents components = new ClsStubBuilderComponents(classDataFinder3, annotationLoader, virtualFile2, protocol, null, null, 48, null);
        NameResolver nameResolver2 = nameResolver;
        ProtoBuf.TypeTable typeTable = packageProto.getTypeTable();
        Intrinsics.checkNotNullExpressionValue(typeTable, "getTypeTable(...)");
        ClsStubBuilderContext context = components.createContext(nameResolver2, packageFqName, new TypeTable(typeTable));
        KotlinFileStubImpl fileStub = ClsStubBuildingKt.createFileStub(packageFqName, false);
        StubElement stubElement = fileStub;
        ProtoContainer.Package package_ = new ProtoContainer.Package(packageFqName, context.getNameResolver(), context.getTypeTable(), null);
        Intrinsics.checkNotNull(packageProto);
        CallableClsStubBuilderKt.createPackageDeclarationsStubs(stubElement, context, package_, packageProto);
        for (ProtoBuf.Class classProto2 : fileWithMetadata.getClassesToDecompile()) {
            ClassClsStubBuilderKt.createClassStub(fileStub, classProto2, nameResolver, NameResolverUtilKt.getClassId(nameResolver, classProto2.getFqName()), null, context);
        }
        return fileStub;
    }
}

