/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.konan;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClassFileDecompilers;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.konan.FileWithMetadata;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibDecompiledFile;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibMetadataStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinDecompiledFileViewProvider;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtDecompiledFile;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledText;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.IncompatibleAbiVersionKt;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000*\n\b\u0000\u0010\u0002 \u0001*\u00020\u00012\u00020\u0003BA\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0010\u001a\u00020\u000fH%\u00a2\u0006\u0004\b\u0012\u0010\u0013J/\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH%\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0017\u00a2\u0006\u0004\b\u001e\u0010\u001fJ'\u0010$\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u001aH\u0017\u00a2\u0006\u0004\b$\u0010%J\u0019\u0010&\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0005\u00a2\u0006\u0004\b&\u0010\u0013J\u0017\u0010'\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010*\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u000fH\u0001\u00a2\u0006\u0004\b)\u0010(R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010+R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010,R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010-R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010,R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010,R\u0014\u0010/\u001a\u00020\u001d8%X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001f"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataDecompiler;", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "V", "Lcom/intellij/psi/compiled/ClassFileDecompilers$Full;", "Lcom/intellij/openapi/fileTypes/FileType;", "fileType", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "serializerProtocol", "Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;", "flexibleTypeDeserializer", "expectedBinaryVersion", "invalidBinaryVersion", "<init>", "(Lcom/intellij/openapi/fileTypes/FileType;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata;", "doReadFile", "(Lcom/intellij/openapi/vfs/VirtualFile;)Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata;", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata$Compatible;", "fileWithMetadata", "virtualFile", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "getDecompiledText", "(Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata$Compatible;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;)Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "", "accepts", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataStubBuilder;", "getStubBuilder", "()Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibMetadataStubBuilder;", "Lcom/intellij/psi/PsiManager;", "manager", "physical", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinDecompiledFileViewProvider;", "createFileViewProvider", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/psi/PsiManager;Z)Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinDecompiledFileViewProvider;", "readFileSafely", "buildDecompiledText", "(Lcom/intellij/openapi/vfs/VirtualFile;)Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "buildDecompiledTextForTests$decompiler_native", "buildDecompiledTextForTests", "Lcom/intellij/openapi/fileTypes/FileType;", "Lkotlin/jvm/functions/Function0;", "Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;", "getMetadataStubBuilder", "metadataStubBuilder"})
public abstract class KlibMetadataDecompiler<V extends BinaryVersion>
extends ClassFileDecompilers.Full {
    @NotNull
    private final FileType fileType;
    @NotNull
    private final Function0<SerializerExtensionProtocol> serializerProtocol;
    @NotNull
    private final FlexibleTypeDeserializer flexibleTypeDeserializer;
    @NotNull
    private final Function0<V> expectedBinaryVersion;
    @NotNull
    private final Function0<V> invalidBinaryVersion;

    public KlibMetadataDecompiler(@NotNull FileType fileType, @NotNull Function0<? extends SerializerExtensionProtocol> serializerProtocol, @NotNull FlexibleTypeDeserializer flexibleTypeDeserializer, @NotNull Function0<? extends V> expectedBinaryVersion, @NotNull Function0<? extends V> invalidBinaryVersion) {
        Intrinsics.checkNotNullParameter(fileType, "fileType");
        Intrinsics.checkNotNullParameter(serializerProtocol, "serializerProtocol");
        Intrinsics.checkNotNullParameter(flexibleTypeDeserializer, "flexibleTypeDeserializer");
        Intrinsics.checkNotNullParameter(expectedBinaryVersion, "expectedBinaryVersion");
        Intrinsics.checkNotNullParameter(invalidBinaryVersion, "invalidBinaryVersion");
        this.fileType = fileType;
        this.serializerProtocol = serializerProtocol;
        this.flexibleTypeDeserializer = flexibleTypeDeserializer;
        this.expectedBinaryVersion = expectedBinaryVersion;
        this.invalidBinaryVersion = invalidBinaryVersion;
    }

    @NotNull
    protected abstract KlibMetadataStubBuilder getMetadataStubBuilder();

    @Nullable
    protected abstract FileWithMetadata doReadFile(@NotNull VirtualFile var1);

    @NotNull
    protected abstract DecompiledText getDecompiledText(@NotNull FileWithMetadata.Compatible var1, @NotNull VirtualFile var2, @NotNull SerializerExtensionProtocol var3, @NotNull FlexibleTypeDeserializer var4);

    @Override
    public boolean accepts(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return FileTypeRegistry.getInstance().isFileOfType(file2, this.fileType);
    }

    @Override
    @NotNull
    public KlibMetadataStubBuilder getStubBuilder() {
        return this.getMetadataStubBuilder();
    }

    @Override
    @NotNull
    public KotlinDecompiledFileViewProvider createFileViewProvider(@NotNull VirtualFile file2, @NotNull PsiManager manager, boolean physical) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(manager, "manager");
        return new KotlinDecompiledFileViewProvider(manager, file2, physical, arg_0 -> KlibMetadataDecompiler.createFileViewProvider$lambda$0(this, arg_0));
    }

    @Nullable
    protected final FileWithMetadata readFileSafely(@NotNull VirtualFile file2) {
        FileWithMetadata fileWithMetadata;
        Intrinsics.checkNotNullParameter(file2, "file");
        if (!file2.isValid()) {
            return null;
        }
        try {
            fileWithMetadata = this.doReadFile(file2);
        }
        catch (IOException e) {
            fileWithMetadata = null;
        }
        return fileWithMetadata;
    }

    private final DecompiledText buildDecompiledText(VirtualFile virtualFile) {
        DecompiledText decompiledText;
        boolean bl = FileTypeRegistry.getInstance().isFileOfType(virtualFile, this.fileType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Unexpected file type " + virtualFile.getFileType();
            throw new AssertionError((Object)string2);
        }
        FileWithMetadata fileWithMetadata = this.readFileSafely(virtualFile);
        if (fileWithMetadata instanceof FileWithMetadata.Incompatible) {
            decompiledText = IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText((BinaryVersion)this.expectedBinaryVersion.invoke(), ((FileWithMetadata.Incompatible)fileWithMetadata).getVersion());
        } else if (fileWithMetadata instanceof FileWithMetadata.Compatible) {
            decompiledText = this.getDecompiledText((FileWithMetadata.Compatible)fileWithMetadata, virtualFile, this.serializerProtocol.invoke(), this.flexibleTypeDeserializer);
        } else if (fileWithMetadata == null) {
            decompiledText = IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText((BinaryVersion)this.expectedBinaryVersion.invoke(), (BinaryVersion)this.invalidBinaryVersion.invoke());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return decompiledText;
    }

    @NotNull
    public final DecompiledText buildDecompiledTextForTests$decompiler_native(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter(virtualFile, "virtualFile");
        return this.buildDecompiledText(virtualFile);
    }

    private static final KtDecompiledFile createFileViewProvider$lambda$0(KlibMetadataDecompiler this$0, KotlinDecompiledFileViewProvider provider2) {
        Intrinsics.checkNotNullParameter(provider2, "provider");
        return new KlibDecompiledFile(provider2, (Function1<? super VirtualFile, DecompiledText>)new Function1<VirtualFile, DecompiledText>((Object)this$0){

            public final DecompiledText invoke(VirtualFile p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return KlibMetadataDecompiler.access$buildDecompiledText((KlibMetadataDecompiler)this.receiver, p0);
            }
        });
    }

    public static final /* synthetic */ DecompiledText access$buildDecompiledText(KlibMetadataDecompiler $this, VirtualFile virtualFile) {
        return $this.buildDecompiledText(virtualFile);
    }
}

