/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinMetadataStubBuilder;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB3\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\u0014\u001a\u0004\b\t\u0010\u0015R\u0014\u0010\n\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0014R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/BuiltInDefinitionFile;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "proto", "Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "version", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageDirectory", "", "isMetadata", "filterOutClassesExistingAsClassFiles", "<init>", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;Lcom/intellij/openapi/vfs/VirtualFile;ZZ)V", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "shouldDecompileBuiltInClass", "(Lorg/jetbrains/kotlin/name/ClassId;Lcom/intellij/openapi/vfs/VirtualFile;)Z", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPackageDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "Z", "()Z", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "getClassesToDecompile", "()Ljava/util/List;", "classesToDecompile", "Companion"})
public final class BuiltInDefinitionFile
extends KotlinMetadataStubBuilder.FileWithMetadata.Compatible {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final VirtualFile packageDirectory;
    private final boolean isMetadata;
    private final boolean filterOutClassesExistingAsClassFiles;
    private static boolean FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES = true;

    public BuiltInDefinitionFile(@NotNull ProtoBuf.PackageFragment proto, @NotNull BuiltInsBinaryVersion version, @Nullable VirtualFile packageDirectory, boolean isMetadata, boolean filterOutClassesExistingAsClassFiles) {
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(version, "version");
        super(proto, version, BuiltInSerializerProtocol.INSTANCE);
        this.packageDirectory = packageDirectory;
        this.isMetadata = isMetadata;
        this.filterOutClassesExistingAsClassFiles = filterOutClassesExistingAsClassFiles;
    }

    public /* synthetic */ BuiltInDefinitionFile(ProtoBuf.PackageFragment packageFragment, BuiltInsBinaryVersion builtInsBinaryVersion, VirtualFile virtualFile, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        this(packageFragment, builtInsBinaryVersion, virtualFile, bl, bl2);
    }

    @Nullable
    public final VirtualFile getPackageDirectory() {
        return this.packageDirectory;
    }

    public final boolean isMetadata() {
        return this.isMetadata;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ProtoBuf.Class> getClassesToDecompile() {
        List list;
        List classes2 = super.getClassesToDecompile();
        boolean bl = false;
        if (this.packageDirectory == null) {
            list = classes2;
        } else if (this.isMetadata || !FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES || !this.filterOutClassesExistingAsClassFiles) {
            list = classes2;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = classes2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProtoBuf.Class classProto2 = (ProtoBuf.Class)element$iv$iv;
                boolean bl2 = false;
                if (!this.shouldDecompileBuiltInClass(NameResolverUtilKt.getClassId(this.getNameResolver(), classProto2.getFqName()), this.packageDirectory)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private final boolean shouldDecompileBuiltInClass(ClassId classId, VirtualFile packageDirectory) {
        String realJvmClassFileName = classId.getShortClassName().asString() + '.' + JavaClassFileType.INSTANCE.getDefaultExtension();
        return packageDirectory.findChild(realJvmClassFileName) == null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/BuiltInDefinitionFile$Companion;", "", "<init>", "()V", "", "contents", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "", "filterOutClassesExistingAsClassFiles", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "read", "([BLcom/intellij/openapi/vfs/VirtualFile;Z)Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES", "Z", "getFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES", "()Z", "setFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES", "(Z)V"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES() {
            return FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES;
        }

        public final void setFILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES(boolean bl) {
            FILTER_OUT_CLASSES_EXISTING_AS_JVM_CLASS_FILES = bl;
        }

        @Nullable
        public final KotlinMetadataStubBuilder.FileWithMetadata read(@NotNull byte[] contents, @NotNull VirtualFile file2, boolean filterOutClassesExistingAsClassFiles) {
            Intrinsics.checkNotNullParameter(contents, "contents");
            Intrinsics.checkNotNullParameter(file2, "file");
            ByteArrayInputStream stream = new ByteArrayInputStream(contents);
            BuiltInsBinaryVersion version = BuiltInsBinaryVersion.Companion.readFrom(stream);
            if (!version.isCompatibleWithCurrentCompilerVersion()) {
                return new KotlinMetadataStubBuilder.FileWithMetadata.Incompatible(version);
            }
            ProtoBuf.PackageFragment proto = ProtoBuf.PackageFragment.parseFrom(stream, BuiltInSerializerProtocol.INSTANCE.getExtensionRegistry());
            Intrinsics.checkNotNull(proto);
            BuiltInDefinitionFile result2 = new BuiltInDefinitionFile(proto, version, file2.getParent(), Intrinsics.areEqual(file2.getExtension(), "kotlin_metadata"), filterOutClassesExistingAsClassFiles);
            ProtoBuf.Package packageProto = result2.getProto().getPackage();
            if (result2.getClassesToDecompile().isEmpty() && packageProto.getTypeAliasCount() == 0 && packageProto.getFunctionCount() == 0 && packageProto.getPropertyCount() == 0) {
                return null;
            }
            return result2;
        }

        public static /* synthetic */ KotlinMetadataStubBuilder.FileWithMetadata read$default(Companion companion, byte[] byArray, VirtualFile virtualFile, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.read(byArray, virtualFile, bl);
        }

        @Nullable
        public final KotlinMetadataStubBuilder.FileWithMetadata read(@NotNull byte[] contents, @NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter(contents, "contents");
            Intrinsics.checkNotNullParameter(file2, "file");
            return org.jetbrains.kotlin.analysis.decompiler.psi.BuiltInDefinitionFile$Companion.read$default(this, contents, file2, false, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

