/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.BuiltinsVirtualFileProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\tH%\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010R!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u000e8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/BuiltinsVirtualFileProviderBaseImpl;", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/BuiltinsVirtualFileProvider;", "<init>", "()V", "Lcom/intellij/openapi/project/Project;", "project", "Lcom/intellij/psi/search/GlobalSearchScope;", "createBuiltinsScope", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/psi/search/GlobalSearchScope;", "Ljava/net/URL;", "url", "Lcom/intellij/openapi/vfs/VirtualFile;", "findVirtualFile", "(Ljava/net/URL;)Lcom/intellij/openapi/vfs/VirtualFile;", "", "getBuiltinVirtualFiles", "()Ljava/util/Set;", "builtInUrls$delegate", "Lkotlin/Lazy;", "getBuiltInUrls", "builtInUrls"})
public abstract class BuiltinsVirtualFileProviderBaseImpl
extends BuiltinsVirtualFileProvider {
    @NotNull
    private final Lazy builtInUrls$delegate = LazyKt.lazy(() -> BuiltinsVirtualFileProviderBaseImpl.builtInUrls_delegate$lambda$1(this));

    private final Set<URL> getBuiltInUrls() {
        Lazy lazy = this.builtInUrls$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public GlobalSearchScope createBuiltinsScope(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        Set<VirtualFile> builtInFiles = this.getBuiltinVirtualFiles();
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope(project, (Collection<? extends VirtualFile>)builtInFiles);
        Intrinsics.checkNotNullExpressionValue(globalSearchScope, "filesScope(...)");
        return globalSearchScope;
    }

    @Nullable
    protected abstract VirtualFile findVirtualFile(@NotNull URL var1);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<VirtualFile> getBuiltinVirtualFiles() {
        void var2_2;
        void $this$mapNotNullTo$iv;
        Iterable iterable = this.getBuiltInUrls();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VirtualFile it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            URL url = (URL)element$iv;
            boolean bl2 = false;
            VirtualFile file2 = this.findVirtualFile(url);
            if (file2 == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(BuiltinsVirtualFileProvider.class);
                Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
                logger.warn("VirtualFile not found for builtin " + url);
            }
            if (file2 == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set builtInUrls_delegate$lambda$1(BuiltinsVirtualFileProviderBaseImpl this$0) {
        void var3_3;
        void $this$mapNotNullTo$iv;
        ClassLoader classLoader = this$0.getClass().getClassLoader();
        Iterable iterable = StandardClassIds.INSTANCE.getBuiltInsPackages();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            URL it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            FqName builtInPackageFqName = (FqName)element$iv;
            boolean bl2 = false;
            String resourcePath = BuiltInSerializerProtocol.INSTANCE.getBuiltInsFilePath(builtInPackageFqName);
            if (classLoader.getResource(resourcePath) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var3_3;
    }
}

