/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.ResolverForDecompiler;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.PackageFragmentProviderOptimized;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.EnumEntriesDeserializationSupportImpl;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.EnumEntriesDeserializationSupport;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0005\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u001a\u001a\u00020\u00178%X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001e\u001a\u00020\u001b8%X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010 \u001a\u00020\u001f8\u0005X\u0085\u0004\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u00118\u0005X\u0085\u0004\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u001a\u0010)\u001a\u00020(8\u0005X\u0085\u0004\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u001a\u0010.\u001a\u00020-8\u0005X\u0085\u0004\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/DeserializerForDecompilerBase;", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/ResolverForDecompiler;", "Lorg/jetbrains/kotlin/name/FqName;", "directoryPackageFqName", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;)V", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "resolveTopLevelClass", "(Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "fqName", "Lorg/jetbrains/kotlin/descriptors/impl/MutablePackageFragmentDescriptor;", "createDummyPackageFragment", "(Lorg/jetbrains/kotlin/name/FqName;)Lorg/jetbrains/kotlin/descriptors/impl/MutablePackageFragmentDescriptor;", "", "name", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "createDummyModule", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "Lorg/jetbrains/kotlin/name/FqName;", "getDirectoryPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "getDeserializationComponents", "()Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "deserializationComponents", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "builtIns", "Lorg/jetbrains/kotlin/storage/StorageManager;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "getStorageManager", "()Lorg/jetbrains/kotlin/storage/StorageManager;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "packageFragmentProvider", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "getPackageFragmentProvider", "()Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "Lorg/jetbrains/kotlin/serialization/deserialization/EnumEntriesDeserializationSupport;", "enumEntriesDeserializationSupport", "Lorg/jetbrains/kotlin/serialization/deserialization/EnumEntriesDeserializationSupport;", "getEnumEntriesDeserializationSupport", "()Lorg/jetbrains/kotlin/serialization/deserialization/EnumEntriesDeserializationSupport;"})
public abstract class DeserializerForDecompilerBase
implements ResolverForDecompiler {
    @NotNull
    private final FqName directoryPackageFqName;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final ModuleDescriptorImpl moduleDescriptor;
    @NotNull
    private final PackageFragmentProvider packageFragmentProvider;
    @NotNull
    private final EnumEntriesDeserializationSupport enumEntriesDeserializationSupport;

    public DeserializerForDecompilerBase(@NotNull FqName directoryPackageFqName) {
        Intrinsics.checkNotNullParameter(directoryPackageFqName, "directoryPackageFqName");
        this.directoryPackageFqName = directoryPackageFqName;
        StorageManager storageManager = LockBasedStorageManager.NO_LOCKS;
        Intrinsics.checkNotNullExpressionValue(storageManager, "NO_LOCKS");
        this.storageManager = storageManager;
        this.moduleDescriptor = this.createDummyModule("module for building decompiled sources");
        this.packageFragmentProvider = new PackageFragmentProviderOptimized(this){
            final /* synthetic */ DeserializerForDecompilerBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void collectPackageFragments(FqName fqName2, Collection<PackageFragmentDescriptor> packageFragments2) {
                Intrinsics.checkNotNullParameter(fqName2, "fqName");
                Intrinsics.checkNotNullParameter(packageFragments2, "packageFragments");
                packageFragments2.add(this.this$0.createDummyPackageFragment(fqName2));
            }

            public boolean isEmpty(FqName fqName2) {
                Intrinsics.checkNotNullParameter(fqName2, "fqName");
                return false;
            }

            public List<PackageFragmentDescriptor> getPackageFragments(FqName fqName2) {
                Intrinsics.checkNotNullParameter(fqName2, "fqName");
                return CollectionsKt.listOf(this.this$0.createDummyPackageFragment(fqName2));
            }

            public Collection<FqName> getSubPackagesOf(FqName fqName2, Function1<? super Name, Boolean> nameFilter) {
                Intrinsics.checkNotNullParameter(fqName2, "fqName");
                Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
                throw new UnsupportedOperationException("This method is not supposed to be called.");
            }
        };
        this.enumEntriesDeserializationSupport = new EnumEntriesDeserializationSupportImpl(this.moduleDescriptor.getPlatform());
        this.moduleDescriptor.initialize(this.packageFragmentProvider);
        ModuleDescriptorImpl[] moduleDescriptorImplArray = new ModuleDescriptorImpl[]{this.moduleDescriptor, this.moduleDescriptor.getBuiltIns().getBuiltInsModule()};
        this.moduleDescriptor.setDependencies(moduleDescriptorImplArray);
    }

    @NotNull
    public final FqName getDirectoryPackageFqName() {
        return this.directoryPackageFqName;
    }

    @NotNull
    protected abstract DeserializationComponents getDeserializationComponents();

    @NotNull
    protected abstract KotlinBuiltIns getBuiltIns();

    @NotNull
    protected final StorageManager getStorageManager() {
        return this.storageManager;
    }

    @NotNull
    protected final ModuleDescriptorImpl getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @NotNull
    protected final PackageFragmentProvider getPackageFragmentProvider() {
        return this.packageFragmentProvider;
    }

    @NotNull
    protected final EnumEntriesDeserializationSupport getEnumEntriesDeserializationSupport() {
        return this.enumEntriesDeserializationSupport;
    }

    @Override
    @Nullable
    public ClassDescriptor resolveTopLevelClass(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this.getDeserializationComponents().deserializeClass(classId);
    }

    @NotNull
    protected final MutablePackageFragmentDescriptor createDummyPackageFragment(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return new MutablePackageFragmentDescriptor(this.moduleDescriptor, fqName2);
    }

    private final ModuleDescriptorImpl createDummyModule(String name) {
        Name name2 = Name.special('<' + name + '>');
        Intrinsics.checkNotNullExpressionValue(name2, "special(...)");
        return new ModuleDescriptorImpl(name2, this.storageManager, this.getBuiltIns(), null, null, null, 56, null);
    }
}

