/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.AnnotationWithArgs;
import org.jetbrains.kotlin.analysis.decompiler.stub.AnnotationWithTarget;
import org.jetbrains.kotlin.analysis.decompiler.stub.CallableClsStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.TypeClsStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.flags.FlagsKt;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.psi.stubs.elements.KtPrimaryConstructorElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtSecondaryConstructorElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinConstructorStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinModifierListStubImpl;
import org.jetbrains.kotlin.serialization.deserialization.AnnotatedCallableKind;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fJ'\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00022\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0013R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00148WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u00148WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0016R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140\u00188WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/ConstructorClsStubBuilder;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/CallableClsStubBuilder;", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "parent", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderContext;", "outerContext", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "protoContainer", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor;", "constructorProto", "<init>", "(Lcom/intellij/psi/stubs/StubElement;Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderContext;Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor;)V", "", "createValueParameterList", "()V", "createModifierListStub", "doCreateCallableStub", "(Lcom/intellij/psi/stubs/StubElement;)Lcom/intellij/psi/stubs/StubElement;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "getReceiverType", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "receiverType", "", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/AnnotationWithTarget;", "getReceiverAnnotations", "()Ljava/util/List;", "receiverAnnotations", "getReturnType", "returnType", "getContextReceiverTypes", "contextReceiverTypes"})
final class ConstructorClsStubBuilder
extends CallableClsStubBuilder {
    @NotNull
    private final ProtoBuf.Constructor constructorProto;

    public ConstructorClsStubBuilder(@NotNull StubElement<? extends PsiElement> parent2, @NotNull ClsStubBuilderContext outerContext, @NotNull ProtoContainer protoContainer, @NotNull ProtoBuf.Constructor constructorProto) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(outerContext, "outerContext");
        Intrinsics.checkNotNullParameter(protoContainer, "protoContainer");
        Intrinsics.checkNotNullParameter(constructorProto, "constructorProto");
        super(parent2, outerContext, protoContainer, CollectionsKt.emptyList());
        this.constructorProto = constructorProto;
    }

    @Override
    @Nullable
    public ProtoBuf.Type getReceiverType() {
        return null;
    }

    @Override
    @NotNull
    public List<AnnotationWithTarget> getReceiverAnnotations() {
        return CollectionsKt.emptyList();
    }

    @Override
    @Nullable
    public ProtoBuf.Type getReturnType() {
        return null;
    }

    @Override
    @NotNull
    public List<ProtoBuf.Type> getContextReceiverTypes() {
        return CollectionsKt.emptyList();
    }

    @Override
    public void createValueParameterList() {
        TypeClsStubBuilder typeClsStubBuilder = this.getTypeStubBuilder();
        StubElement<? extends PsiElement> stubElement = this.getCallableStub();
        MessageLite messageLite = this.constructorProto;
        List<ProtoBuf.ValueParameter> list = this.constructorProto.getValueParameterList();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameterList(...)");
        TypeClsStubBuilder.createValueParameterListStub$default(typeClsStubBuilder, stubElement, messageLite, list, this.getProtoContainer(), null, 16, null);
    }

    @Override
    public void createModifierListStub() {
        KotlinModifierListStubImpl modifierListStubImpl = ClsStubBuildingKt.createModifierListStubForDeclaration$default(this.getCallableStub(), this.constructorProto.getFlags(), CollectionsKt.listOf(FlagsKt.getVISIBILITY()), null, 8, null);
        if (!Flags.HAS_ANNOTATIONS.get(this.constructorProto.getFlags()).booleanValue()) {
            return;
        }
        List<AnnotationWithArgs> annotationIds = this.getC().getComponents().getAnnotationLoader().loadCallableAnnotations(this.getProtoContainer(), this.constructorProto, AnnotatedCallableKind.FUNCTION);
        ClsStubBuildingKt.createAnnotationStubs(annotationIds, modifierListStubImpl);
    }

    @Override
    @NotNull
    public StubElement<? extends PsiElement> doCreateCallableStub(@NotNull StubElement<? extends PsiElement> parent2) {
        StubElement stubElement;
        Intrinsics.checkNotNullParameter(parent2, "parent");
        ProtoContainer protoContainer = this.getProtoContainer();
        Intrinsics.checkNotNull(protoContainer, "null cannot be cast to non-null type org.jetbrains.kotlin.serialization.deserialization.ProtoContainer.Class");
        StringRef name = ClsStubBuildingKt.ref(((ProtoContainer.Class)protoContainer).getClassId().getShortClassName());
        if (Flags.IS_SECONDARY.get(this.constructorProto.getFlags()).booleanValue()) {
            KtSecondaryConstructorElementType ktSecondaryConstructorElementType = KtStubElementTypes.SECONDARY_CONSTRUCTOR;
            Intrinsics.checkNotNullExpressionValue(ktSecondaryConstructorElementType, "SECONDARY_CONSTRUCTOR");
            stubElement = new KotlinConstructorStubImpl(parent2, ktSecondaryConstructorElementType, name, true, false, false);
        } else {
            KtPrimaryConstructorElementType ktPrimaryConstructorElementType = KtStubElementTypes.PRIMARY_CONSTRUCTOR;
            Intrinsics.checkNotNullExpressionValue(ktPrimaryConstructorElementType, "PRIMARY_CONSTRUCTOR");
            stubElement = new KotlinConstructorStubImpl(parent2, ktPrimaryConstructorElementType, name, false, false, false);
        }
        return stubElement;
    }
}

