/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.AnnotationWithArgs;
import org.jetbrains.kotlin.analysis.decompiler.stub.AnnotationWithTarget;
import org.jetbrains.kotlin.analysis.decompiler.stub.CallableClsStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsContractBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.TypeClsStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.flags.FlagsKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.flags.FlagsToModifiers;
import org.jetbrains.kotlin.contracts.description.KtEffectDeclaration;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFunctionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinModifierListStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinStubOrigin;
import org.jetbrains.kotlin.serialization.deserialization.AnnotatedCallableKind;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fJ'\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00022\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0013R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00148WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u00148WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0016R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140\u00188WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/FunctionClsStubBuilder;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/CallableClsStubBuilder;", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "parent", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderContext;", "outerContext", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "protoContainer", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function;", "functionProto", "<init>", "(Lcom/intellij/psi/stubs/StubElement;Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderContext;Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function;)V", "", "createValueParameterList", "()V", "createModifierListStub", "doCreateCallableStub", "(Lcom/intellij/psi/stubs/StubElement;)Lcom/intellij/psi/stubs/StubElement;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "getReceiverType", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "receiverType", "", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/AnnotationWithTarget;", "getReceiverAnnotations", "()Ljava/util/List;", "receiverAnnotations", "getReturnType", "returnType", "getContextReceiverTypes", "contextReceiverTypes"})
final class FunctionClsStubBuilder
extends CallableClsStubBuilder {
    @NotNull
    private final ProtoBuf.Function functionProto;

    public FunctionClsStubBuilder(@NotNull StubElement<? extends PsiElement> parent2, @NotNull ClsStubBuilderContext outerContext, @NotNull ProtoContainer protoContainer, @NotNull ProtoBuf.Function functionProto) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(outerContext, "outerContext");
        Intrinsics.checkNotNullParameter(protoContainer, "protoContainer");
        Intrinsics.checkNotNullParameter(functionProto, "functionProto");
        List<ProtoBuf.TypeParameter> list = functionProto.getTypeParameterList();
        Intrinsics.checkNotNullExpressionValue(list, "getTypeParameterList(...)");
        super(parent2, outerContext, protoContainer, list);
        this.functionProto = functionProto;
    }

    @Override
    @Nullable
    public ProtoBuf.Type getReceiverType() {
        return ProtoTypeTableUtilKt.receiverType(this.functionProto, this.getC().getTypeTable());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationWithTarget> getReceiverAnnotations() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getC().getComponents().getAnnotationLoader().loadExtensionReceiverParameterAnnotations(this.getProtoContainer(), this.functionProto, AnnotatedCallableKind.FUNCTION);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AnnotationWithArgs annotationWithArgs = (AnnotationWithArgs)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AnnotationWithTarget((AnnotationWithArgs)it, AnnotationUseSiteTarget.RECEIVER));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public ProtoBuf.Type getReturnType() {
        return ProtoTypeTableUtilKt.returnType(this.functionProto, this.getC().getTypeTable());
    }

    @Override
    @NotNull
    public List<ProtoBuf.Type> getContextReceiverTypes() {
        return ProtoTypeTableUtilKt.contextReceiverTypes(this.functionProto, this.getC().getTypeTable());
    }

    @Override
    public void createValueParameterList() {
        TypeClsStubBuilder typeClsStubBuilder = this.getTypeStubBuilder();
        StubElement<? extends PsiElement> stubElement = this.getCallableStub();
        MessageLite messageLite = this.functionProto;
        List<ProtoBuf.ValueParameter> list = this.functionProto.getValueParameterList();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameterList(...)");
        TypeClsStubBuilder.createValueParameterListStub$default(typeClsStubBuilder, stubElement, messageLite, list, this.getProtoContainer(), null, 16, null);
    }

    @Override
    public void createModifierListStub() {
        List<Object> modalityModifier = this.isTopLevel() ? CollectionsKt.emptyList() : CollectionsKt.listOf(FlagsKt.getMODALITY());
        FlagsToModifiers[] flagsToModifiersArray = new FlagsToModifiers[]{FlagsKt.getVISIBILITY(), FlagsKt.getOPERATOR(), FlagsKt.getINFIX(), FlagsKt.getEXTERNAL_FUN(), FlagsKt.getINLINE(), FlagsKt.getTAILREC(), FlagsKt.getSUSPEND(), FlagsKt.getEXPECT_FUNCTION()};
        KotlinModifierListStubImpl modifierListStubImpl = ClsStubBuildingKt.createModifierListStubForDeclaration$default(this.getCallableStub(), this.functionProto.getFlags(), CollectionsKt.plus((Collection)CollectionsKt.listOf(flagsToModifiersArray), (Iterable)modalityModifier), null, 8, null);
        if (!Flags.HAS_ANNOTATIONS.get(this.functionProto.getFlags()).booleanValue()) {
            return;
        }
        List<AnnotationWithArgs> annotations2 = this.getC().getComponents().getAnnotationLoader().loadCallableAnnotations(this.getProtoContainer(), this.functionProto, AnnotatedCallableKind.FUNCTION);
        ClsStubBuildingKt.createAnnotationStubs(annotations2, modifierListStubImpl);
    }

    @Override
    @NotNull
    public StubElement<? extends PsiElement> doCreateCallableStub(@NotNull StubElement<? extends PsiElement> parent2) {
        List<KtEffectDeclaration> list;
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Name callableName = NameResolverUtilKt.getName(this.getC().getNameResolver(), this.functionProto.getName());
        boolean hasContract = this.functionProto.hasContract();
        StubElement<? extends PsiElement> stubElement = parent2;
        StringRef stringRef = ClsStubBuildingKt.ref(callableName);
        boolean bl = this.isTopLevel();
        FqName fqName2 = this.getC().getContainerFqName().child(callableName);
        boolean bl2 = ProtoTypeTableUtilKt.hasReceiver(this.functionProto);
        boolean bl3 = true;
        boolean bl4 = Flags.MODALITY.get(this.functionProto.getFlags()) != ProtoBuf.Modality.ABSTRACT;
        List<ProtoBuf.TypeParameter> list2 = this.functionProto.getTypeParameterList();
        Intrinsics.checkNotNullExpressionValue(list2, "getTypeParameterList(...)");
        boolean bl5 = !((Collection)list2).isEmpty();
        boolean bl6 = hasContract;
        boolean $i$f$runIf = false;
        if (hasContract) {
            boolean bl7 = bl6;
            boolean bl8 = bl5;
            boolean bl9 = bl4;
            boolean bl10 = bl3;
            boolean bl11 = bl2;
            FqName fqName3 = fqName2;
            boolean bl12 = bl;
            StringRef stringRef2 = stringRef;
            StubElement<? extends PsiElement> stubElement2 = stubElement;
            boolean bl13 = false;
            List<KtEffectDeclaration> list3 = new ClsContractBuilder(this.getC(), this.getTypeStubBuilder()).loadContract(this.functionProto);
            stubElement = stubElement2;
            stringRef = stringRef2;
            bl = bl12;
            fqName2 = fqName3;
            bl2 = bl11;
            bl3 = bl10;
            bl4 = bl9;
            bl5 = bl8;
            bl6 = bl7;
            list = list3;
        } else {
            list = null;
        }
        KotlinStubOrigin kotlinStubOrigin = ClsStubBuildingKt.createStubOrigin(this.getProtoContainer());
        List<KtEffectDeclaration> list4 = list;
        boolean bl14 = bl6;
        boolean bl15 = bl5;
        boolean bl16 = bl4;
        boolean bl17 = bl3;
        boolean bl18 = bl2;
        FqName fqName4 = fqName2;
        boolean bl19 = bl;
        StringRef stringRef3 = stringRef;
        StubElement<? extends PsiElement> stubElement3 = stubElement;
        return new KotlinFunctionStubImpl(stubElement3, stringRef3, bl19, fqName4, bl18, bl17, bl16, bl15, bl14, list4, kotlinStubOrigin);
    }
}

