/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.file;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import java.lang.ref.SoftReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.CachedAttributeData;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.FileAttributeService;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.exceptions.PlatformExceptionUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ,2\u00020\u0001:\u0003-.,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0004\b\f\u0010\rJ5\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001b\u0010\u001c\u001a\u00020\u0013*\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0019\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001f\u0010 R\u0018\u0010\"\u001a\u0006*\u00020!0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020$8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R/\u0010*\u001a\u001d\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u001e*\b\u0012\u0004\u0012\u00020\u001e0(0(0'\u00a2\u0006\u0002\b)8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache;", "", "<init>", "()V", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "", "fileContent", "", "isKotlinJvmCompiledFile", "(Lcom/intellij/openapi/vfs/VirtualFile;[B)Z", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "getKotlinBinaryClass", "(Lcom/intellij/openapi/vfs/VirtualFile;[B)Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "metadataVersion", "isKotlinBinary", "kotlinJvmBinaryClass", "(Lcom/intellij/openapi/vfs/VirtualFile;[BLorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;Ljava/lang/Boolean;)Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache$KotlinBinaryClassHeaderData;", "getKotlinBinaryClassHeaderData", "(Lcom/intellij/openapi/vfs/VirtualFile;[B)Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache$KotlinBinaryClassHeaderData;", "kotlinBinaryClass", "createHeaderInfo", "(Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;)Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache$KotlinBinaryClassHeaderData;", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "toLightHeader", "(Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache$KotlinBinaryClassHeaderData;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache$KotlinBinaryData;", "getKotlinBinaryFromCache", "(Lcom/intellij/openapi/vfs/VirtualFile;)Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache$KotlinBinaryData;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/FileAttributeService;", "attributeService", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/FileAttributeService;", "", "KOTLIN_IS_COMPILED_FILE_ATTRIBUTE", "Ljava/lang/String;", "Lcom/intellij/openapi/util/Key;", "Ljava/lang/ref/SoftReference;", "Lorg/jetbrains/annotations/NotNull;", "KOTLIN_BINARY_DATA_KEY", "Lcom/intellij/openapi/util/Key;", "Companion", "KotlinBinaryClassHeaderData", "KotlinBinaryData"})
public final class ClsKotlinBinaryClassCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final FileAttributeService attributeService = ApplicationManager.getApplication().getService(FileAttributeService.class);
    @NotNull
    private final String KOTLIN_IS_COMPILED_FILE_ATTRIBUTE;
    @NotNull
    private final Key<SoftReference<KotlinBinaryData>> KOTLIN_BINARY_DATA_KEY;

    /*
     * WARNING - void declaration
     */
    public ClsKotlinBinaryClassCache() {
        void $this$KOTLIN_IS_COMPILED_FILE_ATTRIBUTE_u24lambda_u242;
        String string2;
        String string3 = string2 = "kotlin-is-binary-compiled";
        ClsKotlinBinaryClassCache clsKotlinBinaryClassCache = this;
        boolean bl = false;
        FileAttributeService.register$default(this.attributeService, (String)$this$KOTLIN_IS_COMPILED_FILE_ATTRIBUTE_u24lambda_u242, 2, false, 4, null);
        clsKotlinBinaryClassCache.KOTLIN_IS_COMPILED_FILE_ATTRIBUTE = string2;
        Key key = Key.create(this.KOTLIN_IS_COMPILED_FILE_ATTRIBUTE);
        Intrinsics.checkNotNullExpressionValue(key, "create(...)");
        this.KOTLIN_BINARY_DATA_KEY = key;
    }

    public final boolean isKotlinJvmCompiledFile(@NotNull VirtualFile file2, @Nullable byte[] fileContent) {
        Intrinsics.checkNotNullParameter(file2, "file");
        String string2 = file2.getExtension();
        JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
        Intrinsics.checkNotNull(javaClassFileType);
        if (!Intrinsics.areEqual(string2, javaClassFileType.getDefaultExtension())) {
            return false;
        }
        KotlinBinaryData binaryFromCache = this.getKotlinBinaryFromCache(file2);
        if (binaryFromCache != null) {
            KotlinBinaryData it = binaryFromCache;
            boolean bl = false;
            return it.isKotlinBinary();
        }
        return this.kotlinJvmBinaryClass(file2, fileContent, MetadataVersion.INSTANCE, null) != null;
    }

    public static /* synthetic */ boolean isKotlinJvmCompiledFile$default(ClsKotlinBinaryClassCache clsKotlinBinaryClassCache, VirtualFile virtualFile, byte[] byArray, int n, Object object) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        return clsKotlinBinaryClassCache.isKotlinJvmCompiledFile(virtualFile, byArray);
    }

    @Nullable
    public final KotlinJvmBinaryClass getKotlinBinaryClass(@NotNull VirtualFile file2, @Nullable byte[] fileContent) {
        Intrinsics.checkNotNullParameter(file2, "file");
        KotlinBinaryData cached = this.getKotlinBinaryFromCache(file2);
        if (cached != null && !cached.isKotlinBinary()) {
            return null;
        }
        Object object = cached;
        if (object == null || (object = ((KotlinBinaryData)object).getHeaderData()) == null || (object = ((KotlinBinaryClassHeaderData)object).getMetadataVersion()) == null) {
            object = MetadataVersion.INSTANCE;
        }
        KotlinBinaryData kotlinBinaryData = cached;
        return this.kotlinJvmBinaryClass(file2, fileContent, (MetadataVersion)object, kotlinBinaryData != null ? Boolean.valueOf(kotlinBinaryData.isKotlinBinary()) : null);
    }

    public static /* synthetic */ KotlinJvmBinaryClass getKotlinBinaryClass$default(ClsKotlinBinaryClassCache clsKotlinBinaryClassCache, VirtualFile virtualFile, byte[] byArray, int n, Object object) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        return clsKotlinBinaryClassCache.getKotlinBinaryClass(virtualFile, byArray);
    }

    private final KotlinJvmBinaryClass kotlinJvmBinaryClass(VirtualFile file2, byte[] fileContent, MetadataVersion metadataVersion, Boolean isKotlinBinary) {
        boolean isKotlinBinaryClass;
        KotlinClassFinder.Result classFileContent;
        KotlinClassFinder.Result result2;
        try {
            result2 = KotlinBinaryClassCache.Companion.getKotlinBinaryClassOrClassFileContent(file2, metadataVersion, fileContent);
        }
        catch (Exception e) {
            PlatformExceptionUtilsKt.rethrowIntellijPlatformExceptionIfNeeded(e);
            return null;
        }
        KotlinClassFinder.Result result3 = classFileContent = result2;
        KotlinJvmBinaryClass kotlinBinaryClass = result3 != null ? result3.toKotlinJvmBinaryClass() : null;
        boolean bl = isKotlinBinaryClass = kotlinBinaryClass != null;
        if (file2 instanceof VirtualFileWithId && !Intrinsics.areEqual(isKotlinBinaryClass, isKotlinBinary)) {
            this.attributeService.writeBooleanAttribute(this.KOTLIN_IS_COMPILED_FILE_ATTRIBUTE, file2, isKotlinBinaryClass);
        }
        if (isKotlinBinaryClass) {
            KotlinJvmBinaryClass kotlinJvmBinaryClass = kotlinBinaryClass;
            Intrinsics.checkNotNull(kotlinJvmBinaryClass);
            KotlinBinaryClassHeaderData headerInfo = this.createHeaderInfo(kotlinJvmBinaryClass);
            file2.putUserData(this.KOTLIN_BINARY_DATA_KEY, new SoftReference<KotlinBinaryData>(new KotlinBinaryData(isKotlinBinaryClass, file2.getTimeStamp(), headerInfo)));
        }
        return kotlinBinaryClass;
    }

    @Nullable
    public final KotlinBinaryClassHeaderData getKotlinBinaryClassHeaderData(@NotNull VirtualFile file2, @Nullable byte[] fileContent) {
        KotlinBinaryData kotlinBinaryData;
        Intrinsics.checkNotNullParameter(file2, "file");
        KotlinBinaryData kotlinBinaryData2 = kotlinBinaryData = this.getKotlinBinaryFromCache(file2);
        if (kotlinBinaryData2 != null) {
            KotlinBinaryData cached = kotlinBinaryData2;
            boolean bl = false;
            if (!cached.isKotlinBinary()) {
                return null;
            }
            if (cached.getHeaderData() != null) {
                return cached.getHeaderData();
            }
        }
        KotlinBinaryData kotlinBinaryData3 = kotlinBinaryData;
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.kotlinJvmBinaryClass(file2, fileContent, MetadataVersion.INSTANCE, kotlinBinaryData3 != null ? Boolean.valueOf(kotlinBinaryData3.isKotlinBinary()) : null);
        if (kotlinJvmBinaryClass == null) {
            return null;
        }
        KotlinJvmBinaryClass kotlinBinaryClass = kotlinJvmBinaryClass;
        return this.createHeaderInfo(kotlinBinaryClass);
    }

    public static /* synthetic */ KotlinBinaryClassHeaderData getKotlinBinaryClassHeaderData$default(ClsKotlinBinaryClassCache clsKotlinBinaryClassCache, VirtualFile virtualFile, byte[] byArray, int n, Object object) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        return clsKotlinBinaryClassCache.getKotlinBinaryClassHeaderData(virtualFile, byArray);
    }

    private final KotlinBinaryClassHeaderData createHeaderInfo(KotlinJvmBinaryClass kotlinBinaryClass) {
        ClassId classId = kotlinBinaryClass.getClassId();
        return this.toLightHeader(kotlinBinaryClass.getClassHeader(), classId);
    }

    private final KotlinBinaryClassHeaderData toLightHeader(KotlinClassHeader $this$toLightHeader, ClassId classId) {
        return new KotlinBinaryClassHeaderData(classId, $this$toLightHeader.getKind(), $this$toLightHeader.getMetadataVersion(), $this$toLightHeader.getMultifilePartNames(), $this$toLightHeader.getPackageName());
    }

    private final KotlinBinaryData getKotlinBinaryFromCache(VirtualFile file2) {
        CachedAttributeData<Boolean> isKotlinBinaryAttribute;
        KotlinBinaryData userData;
        SoftReference<KotlinBinaryData> softReference = file2.getUserData(this.KOTLIN_BINARY_DATA_KEY);
        KotlinBinaryData kotlinBinaryData = userData = softReference != null ? softReference.get() : null;
        if (userData != null && userData.getTimestamp() == file2.getTimeStamp()) {
            return userData;
        }
        CachedAttributeData<Boolean> cachedAttributeData = isKotlinBinaryAttribute = file2 instanceof VirtualFileWithId ? this.attributeService.readBooleanAttribute(this.KOTLIN_IS_COMPILED_FILE_ATTRIBUTE, file2) : null;
        if (isKotlinBinaryAttribute != null) {
            boolean isKotlinBinary = isKotlinBinaryAttribute.getValue();
            KotlinBinaryData kotlinBinaryData2 = new KotlinBinaryData(isKotlinBinary, file2.getTimeStamp(), null);
            if (isKotlinBinary) {
                file2.putUserData(this.KOTLIN_BINARY_DATA_KEY, new SoftReference<KotlinBinaryData>(kotlinBinaryData2));
            }
            return kotlinBinaryData2;
        }
        return null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache;", "getInstance", "()Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClsKotlinBinaryClassCache getInstance() {
            ClsKotlinBinaryClassCache clsKotlinBinaryClassCache = ApplicationManager.getApplication().getService(ClsKotlinBinaryClassCache.class);
            Intrinsics.checkNotNullExpressionValue(clsKotlinBinaryClassCache, "getService(...)");
            return clsKotlinBinaryClassCache;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\t8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010 \u001a\u00020\u001d8G\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache$KotlinBinaryClassHeaderData;", "", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader$Kind;", "kind", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "metadataVersion", "", "", "partNamesIfMultifileFacade", "packageName", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader$Kind;Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;Ljava/util/List;Ljava/lang/String;)V", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader$Kind;", "getKind", "()Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader$Kind;", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "Ljava/util/List;", "getPartNamesIfMultifileFacade", "()Ljava/util/List;", "Ljava/lang/String;", "getPackageName", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageNameWithFallback", "()Lorg/jetbrains/kotlin/name/FqName;", "packageNameWithFallback"})
    public static final class KotlinBinaryClassHeaderData {
        @NotNull
        private final ClassId classId;
        @NotNull
        private final KotlinClassHeader.Kind kind;
        @NotNull
        private final MetadataVersion metadataVersion;
        @NotNull
        private final List<String> partNamesIfMultifileFacade;
        @Nullable
        private final String packageName;

        public KotlinBinaryClassHeaderData(@NotNull ClassId classId, @NotNull KotlinClassHeader.Kind kind, @NotNull MetadataVersion metadataVersion, @NotNull List<String> partNamesIfMultifileFacade, @Nullable String packageName) {
            Intrinsics.checkNotNullParameter(classId, "classId");
            Intrinsics.checkNotNullParameter((Object)kind, "kind");
            Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
            Intrinsics.checkNotNullParameter(partNamesIfMultifileFacade, "partNamesIfMultifileFacade");
            this.classId = classId;
            this.kind = kind;
            this.metadataVersion = metadataVersion;
            this.partNamesIfMultifileFacade = partNamesIfMultifileFacade;
            this.packageName = packageName;
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @NotNull
        public final KotlinClassHeader.Kind getKind() {
            return this.kind;
        }

        @NotNull
        public final MetadataVersion getMetadataVersion() {
            return this.metadataVersion;
        }

        @NotNull
        public final List<String> getPartNamesIfMultifileFacade() {
            return this.partNamesIfMultifileFacade;
        }

        @Nullable
        public final String getPackageName() {
            return this.packageName;
        }

        @NotNull
        public final FqName getPackageNameWithFallback() {
            FqName fqName2;
            String string2 = this.packageName;
            if (string2 != null) {
                String p0 = string2;
                boolean bl = false;
                fqName2 = new FqName(p0);
            } else {
                fqName2 = this.classId.getPackageFqName();
            }
            return fqName2;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u00c7\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ0\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u00c7\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0013\u001a\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d7\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u0003\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\rR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001e\u001a\u0004\b\u001f\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache$KotlinBinaryData;", "", "", "isKotlinBinary", "", "timestamp", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache$KotlinBinaryClassHeaderData;", "headerData", "<init>", "(ZJLorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache$KotlinBinaryClassHeaderData;)V", "component1", "()Z", "component2", "()J", "component3", "()Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache$KotlinBinaryClassHeaderData;", "copy", "(ZJLorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache$KotlinBinaryClassHeaderData;)Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache$KotlinBinaryData;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Z", "J", "getTimestamp", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache$KotlinBinaryClassHeaderData;", "getHeaderData"})
    public static final class KotlinBinaryData {
        private final boolean isKotlinBinary;
        private final long timestamp;
        @Nullable
        private final KotlinBinaryClassHeaderData headerData;

        public KotlinBinaryData(boolean isKotlinBinary, long timestamp, @Nullable KotlinBinaryClassHeaderData headerData) {
            this.isKotlinBinary = isKotlinBinary;
            this.timestamp = timestamp;
            this.headerData = headerData;
        }

        public final boolean isKotlinBinary() {
            return this.isKotlinBinary;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @Nullable
        public final KotlinBinaryClassHeaderData getHeaderData() {
            return this.headerData;
        }

        public final boolean component1() {
            return this.isKotlinBinary;
        }

        public final long component2() {
            return this.timestamp;
        }

        @Nullable
        public final KotlinBinaryClassHeaderData component3() {
            return this.headerData;
        }

        @NotNull
        public final KotlinBinaryData copy(boolean isKotlinBinary, long timestamp, @Nullable KotlinBinaryClassHeaderData headerData) {
            return new KotlinBinaryData(isKotlinBinary, timestamp, headerData);
        }

        public static /* synthetic */ KotlinBinaryData copy$default(KotlinBinaryData kotlinBinaryData, boolean bl, long l, KotlinBinaryClassHeaderData kotlinBinaryClassHeaderData, int n, Object object) {
            if ((n & 1) != 0) {
                bl = kotlinBinaryData.isKotlinBinary;
            }
            if ((n & 2) != 0) {
                l = kotlinBinaryData.timestamp;
            }
            if ((n & 4) != 0) {
                kotlinBinaryClassHeaderData = kotlinBinaryData.headerData;
            }
            return kotlinBinaryData.copy(bl, l, kotlinBinaryClassHeaderData);
        }

        @NotNull
        public String toString() {
            return "KotlinBinaryData(isKotlinBinary=" + this.isKotlinBinary + ", timestamp=" + this.timestamp + ", headerData=" + this.headerData + ')';
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.isKotlinBinary);
            result2 = result2 * 31 + Long.hashCode(this.timestamp);
            result2 = result2 * 31 + (this.headerData == null ? 0 : this.headerData.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KotlinBinaryData)) {
                return false;
            }
            KotlinBinaryData kotlinBinaryData = (KotlinBinaryData)other;
            if (this.isKotlinBinary != kotlinBinaryData.isKotlinBinary) {
                return false;
            }
            if (this.timestamp != kotlinBinaryData.timestamp) {
                return false;
            }
            return Intrinsics.areEqual(this.headerData, kotlinBinaryData.headerData);
        }
    }
}

