/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.file;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.InputStream;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.DirectoryBasedClassFinderKt;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaElementsKt;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\r\u0010\u0011J\u0019\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\u000fH\u0017\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u0015\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0019\u0010\u001e\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\"R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010%"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageDirectory", "Lorg/jetbrains/kotlin/name/FqName;", "directoryPackageFqName", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/FqName;)V", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "javaClass", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "metadataVersion", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "findKotlinClassOrContent", "(Lorg/jetbrains/kotlin/load/java/structure/JavaClass;Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;)Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;)Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "Ljava/io/InputStream;", "findMetadata", "(Lorg/jetbrains/kotlin/name/ClassId;)Ljava/io/InputStream;", "packageFqName", "", "", "findMetadataTopLevelClassesInPackage", "(Lorg/jetbrains/kotlin/name/FqName;)Ljava/util/Set;", "fqName", "", "hasMetadataPackage", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "findBuiltInsData", "(Lorg/jetbrains/kotlin/name/FqName;)Ljava/io/InputStream;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPackageDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/name/FqName;", "getDirectoryPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;"})
public final class DirectoryBasedClassFinder
implements KotlinClassFinder {
    @NotNull
    private final VirtualFile packageDirectory;
    @NotNull
    private final FqName directoryPackageFqName;

    public DirectoryBasedClassFinder(@NotNull VirtualFile packageDirectory, @NotNull FqName directoryPackageFqName) {
        Intrinsics.checkNotNullParameter(packageDirectory, "packageDirectory");
        Intrinsics.checkNotNullParameter(directoryPackageFqName, "directoryPackageFqName");
        this.packageDirectory = packageDirectory;
        this.directoryPackageFqName = directoryPackageFqName;
    }

    @NotNull
    public final VirtualFile getPackageDirectory() {
        return this.packageDirectory;
    }

    @NotNull
    public final FqName getDirectoryPackageFqName() {
        return this.directoryPackageFqName;
    }

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull JavaClass javaClass, @NotNull MetadataVersion metadataVersion) {
        Intrinsics.checkNotNullParameter(javaClass, "javaClass");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        ClassId classId = JavaElementsKt.getClassId(javaClass);
        Intrinsics.checkNotNull(classId);
        return this.findKotlinClassOrContent(classId, metadataVersion);
    }

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull ClassId classId, @NotNull MetadataVersion metadataVersion) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        if (!Intrinsics.areEqual(classId.getPackageFqName(), this.directoryPackageFqName)) {
            return null;
        }
        String targetName = CollectionsKt.joinToString$default(classId.getRelativeClassName().pathSegments(), "$", null, ".class", 0, null, null, 58, null);
        VirtualFile virtualFile = this.packageDirectory.findChild(targetName);
        if (virtualFile != null && DirectoryBasedClassFinderKt.access$isKotlinWithCompatibleAbiVersion(virtualFile, metadataVersion)) {
            KotlinClassFinder.Result.KotlinClass kotlinClass2;
            KotlinJvmBinaryClass kotlinJvmBinaryClass = ClsKotlinBinaryClassCache.getKotlinBinaryClass$default(ClsKotlinBinaryClassCache.Companion.getInstance(), virtualFile, null, 2, null);
            if (kotlinJvmBinaryClass != null) {
                KotlinJvmBinaryClass p0 = kotlinJvmBinaryClass;
                boolean bl = false;
                kotlinClass2 = new KotlinClassFinder.Result.KotlinClass(p0, null, 2, null);
            } else {
                kotlinClass2 = null;
            }
            return kotlinClass2;
        }
        return null;
    }

    @Override
    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return null;
    }

    @Override
    @Nullable
    public Set<String> findMetadataTopLevelClassesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        return null;
    }

    @Override
    public boolean hasMetadataPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return false;
    }

    @Override
    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        return null;
    }
}

