/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.file;

import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinderKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.deserialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\r\u0010\u000eR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedDataFinder;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;", "classFinder", "Lcom/intellij/openapi/diagnostic/Logger;", "log", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "metadataVersion", "<init>", "(Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;Lcom/intellij/openapi/diagnostic/Logger;Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;)V", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;", "findClassData", "(Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;", "getClassFinder", "()Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;"})
public final class DirectoryBasedDataFinder
implements ClassDataFinder {
    @NotNull
    private final DirectoryBasedClassFinder classFinder;
    @NotNull
    private final Logger log;
    @NotNull
    private final MetadataVersion metadataVersion;

    public DirectoryBasedDataFinder(@NotNull DirectoryBasedClassFinder classFinder, @NotNull Logger log2, @NotNull MetadataVersion metadataVersion) {
        Intrinsics.checkNotNullParameter(classFinder, "classFinder");
        Intrinsics.checkNotNullParameter(log2, "log");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        this.classFinder = classFinder;
        this.log = log2;
        this.metadataVersion = metadataVersion;
    }

    @NotNull
    public final DirectoryBasedClassFinder getClassFinder() {
        return this.classFinder;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @Override
    @Nullable
    public ClassData findClassData(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = KotlinClassFinderKt.findKotlinClass((KotlinClassFinder)this.classFinder, classId, this.metadataVersion);
        if (kotlinJvmBinaryClass == null) {
            return null;
        }
        KotlinJvmBinaryClass binaryClass = kotlinJvmBinaryClass;
        KotlinClassHeader classHeader = binaryClass.getClassHeader();
        String[] data2 = classHeader.getData();
        if (data2 == null) {
            this.log.error("Annotation data missing for " + binaryClass.getClassId());
            return null;
        }
        String[] strings2 = classHeader.getStrings();
        if (strings2 == null) {
            this.log.error("String table not found in class " + binaryClass.getClassId());
            return null;
        }
        Pair<JvmNameResolver, ProtoBuf.Class> pair = JvmProtoBufUtil.readClassDataFrom(data2, strings2);
        JvmNameResolver nameResolver = pair.component1();
        ProtoBuf.Class classProto2 = pair.component2();
        return new ClassData(nameResolver, classProto2, classHeader.getMetadataVersion(), new KotlinJvmBinarySourceElement(binaryClass, null, false, null, 14, null));
    }
}

