/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.file;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.CallableClsStubBuilderKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClassClsStubBuilderKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderComponents;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.AnnotationLoaderForStubBuilderImpl;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.ClassDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoBasedClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001:\u0001\"BA\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u001a\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\u0013\u001a\u00020\u0012H\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016J!\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0015\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001eR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001fR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010 R(\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010!"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "", "version", "Lcom/intellij/openapi/fileTypes/FileType;", "fileType", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "serializerProtocol", "Lkotlin/Function2;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "readFile", "<init>", "(ILcom/intellij/openapi/fileTypes/FileType;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;)V", "getStubVersion", "()I", "Lcom/intellij/util/indexing/FileContent;", "content", "Lcom/intellij/psi/stubs/PsiFileStub;", "buildFileStub", "(Lcom/intellij/util/indexing/FileContent;)Lcom/intellij/psi/stubs/PsiFileStub;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;", "file", "", "filename", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "createCallableSource", "(Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;Ljava/lang/String;)Lorg/jetbrains/kotlin/descriptors/SourceElement;", "I", "Lcom/intellij/openapi/fileTypes/FileType;", "Lkotlin/jvm/functions/Function0;", "Lkotlin/jvm/functions/Function2;", "FileWithMetadata"})
public class KotlinMetadataStubBuilder
extends ClsStubBuilder {
    private final int version;
    @NotNull
    private final FileType fileType;
    @NotNull
    private final Function0<SerializerExtensionProtocol> serializerProtocol;
    @NotNull
    private final Function2<VirtualFile, byte[], FileWithMetadata> readFile;

    public KotlinMetadataStubBuilder(int version, @NotNull FileType fileType, @NotNull Function0<? extends SerializerExtensionProtocol> serializerProtocol, @NotNull Function2<? super VirtualFile, ? super byte[], ? extends FileWithMetadata> readFile) {
        Intrinsics.checkNotNullParameter(fileType, "fileType");
        Intrinsics.checkNotNullParameter(serializerProtocol, "serializerProtocol");
        Intrinsics.checkNotNullParameter(readFile, "readFile");
        this.version = version;
        this.fileType = fileType;
        this.serializerProtocol = serializerProtocol;
        this.readFile = readFile;
    }

    @Override
    public int getStubVersion() {
        return 27 + this.version;
    }

    @Override
    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content) {
        boolean bl;
        Intrinsics.checkNotNullParameter(content, "content");
        VirtualFile virtualFile = content.getFile();
        Intrinsics.checkNotNullExpressionValue(virtualFile, "getFile(...)");
        VirtualFile virtualFile2 = virtualFile;
        boolean bl2 = bl = Intrinsics.areEqual(virtualFile2.getExtension(), this.fileType.getDefaultExtension()) || Intrinsics.areEqual(virtualFile2.getFileType(), this.fileType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Unexpected file type " + virtualFile2.getFileType().getName();
            throw new AssertionError((Object)string2);
        }
        byte[] byArray = content.getContent();
        Intrinsics.checkNotNullExpressionValue(byArray, "getContent(...)");
        FileWithMetadata fileWithMetadata = this.readFile.invoke(virtualFile2, byArray);
        if (fileWithMetadata == null) {
            return null;
        }
        FileWithMetadata file2 = fileWithMetadata;
        FileWithMetadata fileWithMetadata2 = file2;
        if (fileWithMetadata2 instanceof FileWithMetadata.Incompatible) {
            return ClsStubBuildingKt.createIncompatibleAbiVersionFileStub();
        }
        if (fileWithMetadata2 instanceof FileWithMetadata.Compatible) {
            ProtoBuf.Package packageProto = ((FileWithMetadata.Compatible)file2).getProto().getPackage();
            FqName packageFqName = ((FileWithMetadata.Compatible)file2).getPackageFqName();
            NameResolverImpl nameResolver = ((FileWithMetadata.Compatible)file2).getNameResolver();
            SerializerExtensionProtocol protocol = this.serializerProtocol.invoke();
            ClsStubBuilderComponents components = new ClsStubBuilderComponents(new ProtoBasedClassDataFinder(((FileWithMetadata.Compatible)file2).getProto(), nameResolver, ((FileWithMetadata.Compatible)file2).getVersion(), null, 8, null), new AnnotationLoaderForStubBuilderImpl(protocol), virtualFile2, protocol, null, null, 48, null);
            NameResolver nameResolver2 = nameResolver;
            ProtoBuf.TypeTable typeTable = packageProto.getTypeTable();
            Intrinsics.checkNotNullExpressionValue(typeTable, "getTypeTable(...)");
            ClsStubBuilderContext context = components.createContext(nameResolver2, packageFqName, new TypeTable(typeTable));
            KotlinFileStubImpl fileStub = ClsStubBuildingKt.createFileStub(packageFqName, false);
            StubElement stubElement = fileStub;
            NameResolver nameResolver3 = context.getNameResolver();
            TypeTable typeTable2 = context.getTypeTable();
            FileWithMetadata.Compatible compatible = (FileWithMetadata.Compatible)file2;
            String string3 = content.getFileName();
            Intrinsics.checkNotNullExpressionValue(string3, "getFileName(...)");
            ProtoContainer.Package package_ = new ProtoContainer.Package(packageFqName, nameResolver3, typeTable2, this.createCallableSource(compatible, string3));
            Intrinsics.checkNotNull(packageProto);
            CallableClsStubBuilderKt.createPackageDeclarationsStubs(stubElement, context, package_, packageProto);
            for (ProtoBuf.Class classProto2 : ((FileWithMetadata.Compatible)file2).getClassesToDecompile()) {
                ClassClsStubBuilderKt.createClassStub(fileStub, classProto2, nameResolver, NameResolverUtilKt.getClassId(nameResolver, classProto2.getFqName()), null, context);
            }
            return fileStub;
        }
        throw new NoWhenBranchMatchedException();
    }

    @Nullable
    protected SourceElement createCallableSource(@NotNull FileWithMetadata.Compatible file2, @NotNull String filename) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(filename, "filename");
        return null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "", "<init>", "()V", "Incompatible", "Compatible", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Incompatible;"})
    public static abstract class FileWithMetadata {
        private FileWithMetadata() {
        }

        public /* synthetic */ FileWithMetadata(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u00020\u00108\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\u00020\u00158\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "proto", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "version", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "serializerProtocol", "<init>", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "getProto", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "getNameResolver", "()Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "classesToDecompile", "Ljava/util/List;", "getClassesToDecompile", "()Ljava/util/List;"})
        public static class Compatible
        extends FileWithMetadata {
            @NotNull
            private final ProtoBuf.PackageFragment proto;
            @NotNull
            private final BinaryVersion version;
            @NotNull
            private final NameResolverImpl nameResolver;
            @NotNull
            private final FqName packageFqName;
            @NotNull
            private final List<ProtoBuf.Class> classesToDecompile;

            /*
             * WARNING - void declaration
             */
            public Compatible(@NotNull ProtoBuf.PackageFragment proto, @NotNull BinaryVersion version, @NotNull SerializerExtensionProtocol serializerProtocol) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter(proto, "proto");
                Intrinsics.checkNotNullParameter(version, "version");
                Intrinsics.checkNotNullParameter(serializerProtocol, "serializerProtocol");
                super(null);
                this.proto = proto;
                this.version = version;
                ProtoBuf.StringTable stringTable = this.proto.getStrings();
                Intrinsics.checkNotNullExpressionValue(stringTable, "getStrings(...)");
                ProtoBuf.QualifiedNameTable qualifiedNameTable = this.proto.getQualifiedNames();
                Intrinsics.checkNotNullExpressionValue(qualifiedNameTable, "getQualifiedNames(...)");
                this.nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
                Integer n = this.proto.getPackage().getExtension(serializerProtocol.getPackageFqName());
                Intrinsics.checkNotNullExpressionValue(n, "getExtension(...)");
                this.packageFqName = new FqName(this.nameResolver.getPackageFqName(((Number)n).intValue()));
                List<ProtoBuf.Class> list = this.proto.getClass_List();
                Intrinsics.checkNotNullExpressionValue(list, "getClass_List(...)");
                Iterable iterable = list;
                Compatible compatible = this;
                boolean $i$f$filter = false;
                void var6_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ProtoBuf.Class proto2 = (ProtoBuf.Class)element$iv$iv;
                    boolean bl = false;
                    ClassId classId = NameResolverUtilKt.getClassId(this.nameResolver, proto2.getFqName());
                    if (!(!classId.isNestedClass() && !ClassDeserializer.Companion.getBLACK_LIST().contains(classId))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                compatible.classesToDecompile = (List)destination$iv$iv;
            }

            @NotNull
            public final ProtoBuf.PackageFragment getProto() {
                return this.proto;
            }

            @NotNull
            public final BinaryVersion getVersion() {
                return this.version;
            }

            @NotNull
            public final NameResolverImpl getNameResolver() {
                return this.nameResolver;
            }

            @NotNull
            public final FqName getPackageFqName() {
                return this.packageFqName;
            }

            @NotNull
            public List<ProtoBuf.Class> getClassesToDecompile() {
                return this.classesToDecompile;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Incompatible;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "version", "<init>", "(Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;)V", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;"})
        public static final class Incompatible
        extends FileWithMetadata {
            @NotNull
            private final BinaryVersion version;

            public Incompatible(@NotNull BinaryVersion version) {
                Intrinsics.checkNotNullParameter(version, "version");
                super(null);
                this.version = version;
            }

            @NotNull
            public final BinaryVersion getVersion() {
                return this.version;
            }
        }
    }
}

