/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.FirDesignationState;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignation;
import org.jetbrains.kotlin.fir.FirElementWithResolveState;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00028\u0000H%\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH$\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00028\u0000H\u0007\u00a2\u0006\u0004\b\u000e\u0010\bJ\r\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0011R\u0018\u0010\u0012\u001a\u0004\u0018\u00018\u00008\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/ContextByDesignationCollector;", "", "C", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/FirDesignation;", "designation", "<init>", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/FirDesignation;)V", "getCurrentContext", "()Ljava/lang/Object;", "Lorg/jetbrains/kotlin/fir/FirElementWithResolveState;", "target", "", "goToNestedDeclaration", "(Lorg/jetbrains/kotlin/fir/FirElementWithResolveState;)V", "getCollectedContext", "nextStep", "()V", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/FirDesignation;", "context", "Ljava/lang/Object;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/FirDesignationState;", "designationState", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/FirDesignationState;"})
public abstract class ContextByDesignationCollector<C> {
    @NotNull
    private final FirDesignation designation;
    @Nullable
    private C context;
    @NotNull
    private final FirDesignationState designationState;

    public ContextByDesignationCollector(@NotNull FirDesignation designation) {
        Intrinsics.checkNotNullParameter(designation, "designation");
        this.designation = designation;
        this.designationState = new FirDesignationState(this.designation);
    }

    @NotNull
    protected abstract C getCurrentContext();

    protected abstract void goToNestedDeclaration(@NotNull FirElementWithResolveState var1);

    @NotNull
    public final C getCollectedContext() {
        C c = this.context;
        if (c == null) {
            throw new IllegalStateException("Context is not collected yet".toString());
        }
        return c;
    }

    public final void nextStep() {
        if (this.designationState.canGoNext()) {
            this.designationState.goNext();
            if (Intrinsics.areEqual(this.designationState.getCurrentDeclarationIfPresent(), this.designation.getTarget())) {
                if (!(this.context == null)) {
                    throw new IllegalStateException("Check failed.");
                }
                this.context = this.getCurrentContext();
            }
            this.goToNestedDeclaration(this.designationState.getCurrentDeclaration());
        } else if (Intrinsics.areEqual(this.designationState.getCurrentDeclarationIfPresent(), this.designation.getTarget())) {
            this.designationState.goToInnerDeclaration();
        }
    }
}

